/*
 * Decompiled with CFR 0.152.
 */
package costo_plugin_kml2b.visitors;

import costo.graph.CostoLibrary;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlArrayExpression;
import costo.graph.expressions.KmlArrayInitializer;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlBinOP;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlCompositeExpression;
import costo.graph.expressions.KmlCondition;
import costo.graph.expressions.KmlConstant;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlFunction;
import costo.graph.expressions.KmlFunctionCall;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.expressions.KmlIfExpression;
import costo.graph.expressions.KmlLitteralValue;
import costo.graph.expressions.KmlMandatoryCall;
import costo.graph.expressions.KmlNaryOperatorExpression;
import costo.graph.expressions.KmlParOp;
import costo.graph.expressions.KmlPredicate;
import costo.graph.expressions.KmlSignature;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.expressions.KmlUnaryOp;
import costo.graph.expressions.KmlUnchangedExpression;
import costo.graph.expressions.NavigateExpression;
import costo.graph.types.CostoArray;
import costo.graph.types.CostoBoolean;
import costo.graph.types.CostoEnum;
import costo.graph.types.CostoInteger;
import costo.graph.types.CostoRange;
import costo.graph.types.CostoSet;
import costo.graph.types.CostoType;
import costo.graph.types.StructuredType;
import costo_plugin_kml2b.visitors.Kml2BVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class Kml2BExpressionVisitor
implements ExpressionVisitor {
    public ArrayList<String> vars = new ArrayList();
    public String bExp = "";
    public String type = "";
    public String value = "";
    public CostoLibrary librairies;
    public String l_prefix = "";

    public void Kml2BExpressionVisitor(CostoLibrary cl) {
        this.librairies = cl;
    }

    public boolean visit(KmlArrayExpression expression) {
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        Kml2BExpressionVisitor v1 = new Kml2BExpressionVisitor();
        expression.getLeftPart().accept((ExpressionVisitor)v);
        expression.getIndex().accept((ExpressionVisitor)v1);
        this.bExp = String.valueOf(v.bExp) + "(" + v1.bExp + ")";
        this.l_prefix = String.valueOf(v.l_prefix) + "(" + v1.l_prefix + ")";
        this.addVars(v.vars);
        this.addVars(v1.vars);
        return false;
    }

    public boolean visit(KmlAssignmentExpression expression) {
        Kml2BExpressionVisitor v1 = new Kml2BExpressionVisitor();
        Kml2BExpressionVisitor v2 = new Kml2BExpressionVisitor();
        expression.getLeftOperand().accept((ExpressionVisitor)v1);
        this.addVar(expression.getLeftOperand().getRawValue());
        expression.getRightOperand().accept((ExpressionVisitor)v2);
        if (expression.getRightOperand() instanceof KmlFunctionCall) {
            KmlFunctionCall fc = new KmlFunctionCall();
            fc = (KmlFunctionCall)expression.getRightOperand();
            if (fc.getFunctionName().equals("oneOf")) {
                this.bExp = String.valueOf(v1.bExp) + v2.bExp;
                this.l_prefix = String.valueOf(v1.l_prefix) + v2.l_prefix;
            } else {
                this.bExp = String.valueOf(v1.bExp) + " := " + v2.bExp;
                this.l_prefix = String.valueOf(v1.l_prefix) + " := " + v2.l_prefix;
            }
        } else {
            this.bExp = String.valueOf(v1.bExp) + " " + expression.getOperator() + " " + v2.bExp;
            this.l_prefix = String.valueOf(v1.l_prefix) + " := " + v2.l_prefix;
        }
        return false;
    }

    public boolean visit(Variable expression) {
        this.bExp = expression.getName();
        this.addVar(this.bExp);
        if (this.bExp.length() == 1) {
            this.bExp = String.valueOf(this.bExp) + this.bExp;
        }
        this.type = this.visitType(expression.getCtype());
        this.value = expression.getValue();
        this.l_prefix = "l_" + this.bExp;
        return false;
    }

    public String visitType(CostoType ct) {
        Kml2BVisitor v = new Kml2BVisitor();
        if (ct != null) {
            if (ct instanceof CostoInteger) {
                return "INT";
            }
            if (ct instanceof CostoBoolean) {
                return "BOOL";
            }
            if (ct instanceof CostoArray) {
                String s = "";
                CostoArray ca = (CostoArray)ct;
                s = this.visitType((CostoType)ca.getRange()).replace("[", "(");
                s = s.replace("]", ")");
                return String.valueOf(s) + " --> " + v.visitType(ca.getReftype());
            }
            if (ct instanceof CostoEnum) {
                CostoEnum ce = (CostoEnum)ct;
                return Spec.listToString((Collection)ce.getEnums(), (String)"{", (String)",", (String)"}");
            }
            if (ct instanceof CostoRange) {
                CostoRange cr = (CostoRange)ct;
                return String.valueOf(cr.getBorneInfName()) + ".." + cr.getBorneSupName();
            }
            if (ct instanceof CostoSet) {
                CostoSet cs = (CostoSet)ct;
                return this.visitType(cs.getReftype());
            }
            if (ct instanceof StructuredType) {
                StructuredType ca = (StructuredType)ct;
                String raw = "struct (";
                ArrayList al = new ArrayList();
                al.addAll(ca.getFields().keySet());
                Collections.sort(al);
                Iterator it = al.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    raw = String.valueOf(raw) + key + ":" + this.visitType((CostoType)ca.getFields().get(key));
                    if (!it.hasNext()) continue;
                    raw = String.valueOf(raw) + ", ";
                }
                raw = String.valueOf(raw) + ")";
                return " : " + raw;
            }
            return ct.getName();
        }
        return "Undefined Type";
    }

    public boolean visit(CostoType ct) {
        Kml2BVisitor v = new Kml2BVisitor();
        if (ct != null) {
            if (ct instanceof CostoInteger) {
                this.bExp = "INT";
            } else if (ct instanceof CostoBoolean) {
                this.bExp = "BOOL";
            } else if (ct instanceof CostoArray) {
                String s = "";
                CostoArray ca = (CostoArray)ct;
                s = this.visitType((CostoType)ca.getRange()).replace("[", "(");
                s = s.replace("]", ")");
                this.bExp = String.valueOf(s) + " --> " + v.visitType(ca.getReftype());
            } else if (ct instanceof CostoEnum) {
                CostoEnum ce = (CostoEnum)ct;
                this.bExp = Spec.listToString((Collection)ce.getEnums(), (String)"{", (String)",", (String)"}");
            } else if (ct instanceof CostoRange) {
                CostoRange cr = (CostoRange)ct;
                this.bExp = String.valueOf(cr.getBorneInfName()) + ".." + cr.getBorneSupName();
            } else if (ct instanceof CostoSet) {
                CostoSet cs = (CostoSet)ct;
                this.bExp = this.visitType(cs.getReftype());
            } else if (ct instanceof StructuredType) {
                StructuredType ca = (StructuredType)ct;
                String raw = "struct (";
                ArrayList al = new ArrayList();
                al.addAll(ca.getFields().keySet());
                Collections.sort(al);
                Iterator it = al.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    raw = String.valueOf(raw) + key + ":" + this.visitType((CostoType)ca.getFields().get(key));
                    if (!it.hasNext()) continue;
                    raw = String.valueOf(raw) + ", ";
                }
                raw = String.valueOf(raw) + ")";
                this.bExp = " : " + raw;
            } else {
                this.bExp = ct.getName();
            }
        }
        return true;
    }

    public String btyping(Variable var) {
        String s = "";
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        v.visit(var);
        if (var.getCtype() instanceof CostoSet) {
            CostoSet cs = new CostoSet();
            cs = (CostoSet)var.getCtype();
            s = String.valueOf(v.bExp) + " <: " + this.visitType(cs.getReftype());
        } else {
            s = String.valueOf(v.bExp) + " :" + v.type;
        }
        return s;
    }

    public boolean visit(KmlBinOP expression) {
        Kml2BExpressionVisitor vl = new Kml2BExpressionVisitor();
        Kml2BExpressionVisitor vr = new Kml2BExpressionVisitor();
        expression.getLeftOperand().accept((ExpressionVisitor)vl);
        expression.getRightOperand().accept((ExpressionVisitor)vr);
        String op = expression.getOperator();
        if (op == "implies") {
            this.bExp = String.valueOf(vl.bExp) + " => " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " => " + vr.l_prefix;
        } else if (op == "equiv") {
            this.bExp = String.valueOf(vl.bExp) + " <=> " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " <=> " + vr.l_prefix;
        } else if (op == "and") {
            this.bExp = String.valueOf(vl.bExp) + " & " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " & " + vr.l_prefix;
        } else if (op == "<>") {
            this.bExp = String.valueOf(vl.bExp) + " /= " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " /= " + vr.l_prefix;
        } else if (op == "in") {
            this.bExp = String.valueOf(vl.bExp) + " : " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " : " + vr.l_prefix;
        } else if (op == "&&") {
            this.bExp = String.valueOf(vl.bExp) + " & " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " & " + vr.l_prefix;
        } else if (op == "||") {
            this.bExp = String.valueOf(vl.bExp) + " or " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " or " + vr.l_prefix;
        } else if (op == "=" && expression.getRightOperand().getType() instanceof CostoBoolean && expression.getRightOperand() instanceof KmlBinOP) {
            if (expression.getLeftOperand() instanceof KmlIdentifier) {
                this.bExp = String.valueOf(vl.bExp) + " = bool(" + vr.bExp + ")";
                this.l_prefix = String.valueOf(vl.l_prefix) + " = bool(" + vr.l_prefix + ")";
            }
        } else {
            this.bExp = String.valueOf(vl.bExp) + " " + op + " " + vr.bExp;
            this.l_prefix = String.valueOf(vl.l_prefix) + " " + op + " " + vr.l_prefix;
        }
        this.addVars(vl.vars);
        this.addVars(vr.vars);
        this.type = this.visitType(expression.getType());
        return false;
    }

    public boolean visit(KmlCommunication expression) {
        return false;
    }

    public boolean visit(KmlCompositeExpression expression) {
        return false;
    }

    public boolean visit(KmlArrayInitializer expression) {
        return false;
    }

    public boolean visit(KmlCondition expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.bExp = "lol";
        return false;
    }

    public boolean visit(KmlConstant expression) {
        this.bExp = expression.getRawValue();
        if (expression.getType() == CostoBoolean.instance) {
            this.bExp = this.bExp.toUpperCase();
        }
        this.l_prefix = this.bExp;
        this.type = this.visitType(expression.getType());
        return false;
    }

    public boolean visit(KmlFunctionCall expression) {
        KmlFunctionCall f = (KmlFunctionCall)expression.deepCopy();
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        Kml2BExpressionVisitor v1 = new Kml2BExpressionVisitor();
        this.type = this.visitType(expression.getType());
        if (!expression.getOperands().isEmpty() && expression.getOperands() != null) {
            for (KmlExpression op : f.getOperands()) {
                if (!(op instanceof KmlIdentifier)) continue;
                op.setRawValue("l_" + op.getRawValue());
            }
            for (KmlExpression operand : expression.getOperands()) {
                v.visit(operand);
                this.addVar(v.bExp);
            }
            if (expression.getFunctionName().startsWith("old")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                this.l_prefix = this.bExp = v.bExp;
            }
            if (expression.getFunctionName().equals("union")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " \\/ " + v1.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " \\/ " + v1.l_prefix;
            }
            if (expression.getFunctionName().equals("intersection")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " /\\ " + v1.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " /\\ " + v1.l_prefix;
            }
            if (expression.getFunctionName().equals("isEmpty")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                this.bExp = "bool (" + v.bExp + " == {})";
                v1.visit((KmlExpression)f.getOperands().get(0));
                this.l_prefix = "bool (" + v1.l_prefix + " = {})";
            }
            if (expression.getFunctionName().equals("notEmpty")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                this.bExp = String.valueOf(v.bExp) + " /= {}";
                v1.visit((KmlExpression)f.getOperands().get(0));
                this.l_prefix = String.valueOf(v1.l_prefix) + " /= {}";
            }
            if (expression.getFunctionName().equals("size")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                this.bExp = "card (" + v.bExp + ") ";
                v1.visit((KmlExpression)f.getOperands().get(0));
                this.l_prefix = "card (" + v1.l_prefix + ") ";
            }
            if (expression.getFunctionName().equals("excludes")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v1.bExp) + " /: " + v.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v1.l_prefix) + " /: " + v.l_prefix;
            }
            if (expression.getFunctionName().equals("excludesAll")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " /<: " + v1.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " /<: " + v1.l_prefix;
            }
            if (expression.getFunctionName().equals("excluding")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " - {" + v1.bExp + "}";
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " - {" + v1.l_prefix + "}";
            }
            if (expression.getFunctionName().equals("add")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " \\/ {" + v1.bExp + "}";
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " \\/ {" + v1.l_prefix + "}";
            }
            if (expression.getFunctionName().equals("includes")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v1.bExp) + " : " + v.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v1.l_prefix) + " : " + v.l_prefix;
            }
            if (expression.getFunctionName().equals("includesAll")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v1.bExp) + " <: " + v.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v1.l_prefix) + " <: " + v.l_prefix;
            }
            if (expression.getFunctionName().equals("including")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " \\/ {" + v1.bExp + "}";
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " \\/ {" + v1.l_prefix + "}";
            }
            if (expression.getFunctionName().equals("count")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = "TODO";
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = "TODO";
            }
            if (expression.getFunctionName().equals("singleton")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                this.bExp = "{" + v.bExp + "}";
                v1.visit((KmlExpression)f.getOperands().get(0));
                this.l_prefix = "{" + v1.l_prefix + "}";
            }
            if (expression.getFunctionName().equals("KWin")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " : " + v1.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " : " + v1.l_prefix;
            }
            if (expression.getFunctionName().equals("notIn")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v1.bExp) + " /: " + v.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v1.l_prefix) + " /: " + v.l_prefix;
            }
            if (expression.getFunctionName().equals("oneOf")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                this.l_prefix = this.bExp = " :: " + v.bExp;
            }
            if (expression.getFunctionName().equals("differ")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                v1.visit((KmlExpression)expression.getOperands().get(1));
                this.bExp = String.valueOf(v.bExp) + " - " + v1.bExp;
                v.visit((KmlExpression)f.getOperands().get(0));
                v1.visit((KmlExpression)f.getOperands().get(1));
                this.l_prefix = String.valueOf(v.l_prefix) + " - " + v1.l_prefix;
            }
            if (expression.getFunctionName().equals("asArray")) {
                v.visit((KmlExpression)expression.getOperands().get(0));
                this.bExp = "0..card(" + v.bExp + ")" + " --> " + v.bExp;
                v1.visit((KmlExpression)f.getOperands().get(0));
                this.l_prefix = "0..card(" + v1.l_prefix + ")" + " --> " + v1.l_prefix;
                this.type = "INT --> " + v.bExp;
            }
        }
        if (expression.getFunctionName().equals("arrayInit")) {
            KmlExpression exp = (KmlExpression)expression.getOperands().get(0);
            CostoArray ca = (CostoArray)exp.getType();
            v.visit((KmlExpression)expression.getOperands().get(0));
            v1.visit((KmlExpression)expression.getOperands().get(1));
            this.l_prefix = this.bExp = "(" + ca.getRange().getBorneInfName() + ".." + ca.getRange().getBorneSupName() + ") * {" + v1.bExp + "}";
        }
        return false;
    }

    public boolean visit(KmlIdentifier expression) {
        this.bExp = expression.getRawValue();
        if (this.bExp.length() == 1) {
            this.bExp = String.valueOf(this.bExp) + this.bExp;
        }
        this.l_prefix = "l_" + this.bExp;
        if (expression.getRawValue().equals("emptySet")) {
            this.bExp = "{}";
            this.l_prefix = "{}";
        } else {
            this.addVar(this.bExp);
        }
        if (expression.getType() != null) {
            this.type = this.visitType(expression.getType());
        }
        return false;
    }

    public boolean visit(KmlIfExpression expression) {
        return false;
    }

    public boolean visit(KmlLitteralValue expression) {
        return false;
    }

    public boolean visit(KmlMandatoryCall expression) {
        return false;
    }

    public boolean visit(KmlNaryOperatorExpression expression) {
        return false;
    }

    public boolean visit(KmlParOp expression) {
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        expression.getOperand().accept((ExpressionVisitor)v);
        this.bExp = String.valueOf(expression.getStart()) + v.bExp + expression.getEnd();
        this.l_prefix = String.valueOf(expression.getStart()) + v.l_prefix + expression.getEnd();
        this.type = this.visitType(expression.getType());
        this.vars = v.vars;
        return false;
    }

    public boolean visit(KmlPredicate expression) {
        this.bExp = "";
        this.l_prefix = "";
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        Kml2BExpressionVisitor v1 = new Kml2BExpressionVisitor();
        KmlPredicate p = (KmlPredicate)expression.deepCopy();
        ArrayList<String> va = new ArrayList<String>();
        ArrayList<String> lva = new ArrayList<String>();
        if (p.getExistentials() != null) {
            for (Variable var : p.getExistentials().values()) {
                va.add(this.btyping(var));
                var.setName("l_" + var.getName());
                lva.add(this.btyping(var));
            }
        }
        if (p.getUniversals() != null) {
            for (Variable var : p.getUniversals().values()) {
                va.add(this.btyping(var));
                var.setName("l_" + var.getName());
                lva.add(this.btyping(var));
            }
        }
        if (expression.getUniversals() != null) {
            this.bExp = String.valueOf(this.bExp) + Spec.listToString(expression.getUniversals().keySet(), (String)"! ", (String)";", (String)"");
            this.l_prefix = String.valueOf(this.l_prefix) + Spec.listToString(p.getUniversals().keySet(), (String)"! ", (String)";", (String)"");
        }
        if (expression.getExistentials() != null) {
            this.bExp = String.valueOf(this.bExp) + " " + Spec.listToString(expression.getExistentials().keySet(), (String)" # ", (String)";", (String)"");
            this.l_prefix = String.valueOf(this.l_prefix) + Spec.listToString(p.getUniversals().keySet(), (String)"! ", (String)";", (String)"");
        }
        if (expression.getExistentials() != null || expression.getUniversals() != null) {
            this.bExp = String.valueOf(this.bExp) + " . ";
            this.l_prefix = String.valueOf(this.l_prefix) + ".";
        }
        expression.getExpression().accept((ExpressionVisitor)v);
        p.getExpression().accept((ExpressionVisitor)v1);
        if (this.bExp != "") {
            this.bExp = String.valueOf(this.bExp) + "(" + Spec.listToString(va, (String)"", (String)" & ", (String)" & ") + v.bExp + ")";
            this.l_prefix = String.valueOf(this.l_prefix) + "(" + Spec.listToString(lva, (String)"", (String)" & ", (String)" & ") + v1.l_prefix + ")";
        } else {
            this.bExp = v.bExp;
            p.getExpression().accept((ExpressionVisitor)v1);
            this.l_prefix = v1.l_prefix;
        }
        this.vars = v.vars;
        this.type = this.visitType(expression.getType());
        return false;
    }

    public boolean visit(KmlSignature expression) {
        return false;
    }

    public boolean visit(KmlFunction expression) {
        return false;
    }

    public boolean visit(KmlTypedStuff expression) {
        this.bExp = expression.getRawValue();
        if (expression.getType() == CostoBoolean.instance) {
            this.bExp = String.valueOf(this.bExp.toUpperCase()) + "lol";
        } else {
            this.addVar(this.bExp);
        }
        this.l_prefix = this.bExp;
        this.type = this.visitType(expression.getType());
        if (expression instanceof KmlUnchangedExpression) {
            KmlUnchangedExpression exp = (KmlUnchangedExpression)expression;
            ArrayList<String> al = new ArrayList<String>();
            for (KmlIdentifier op : exp.getVariables()) {
                al.add("l_" + op.getRawValue() + " = " + op.getRawValue());
                this.l_prefix = this.bExp = Spec.listToString(al, (String)"", (String)" & ", (String)"");
            }
        }
        if (expression instanceof KmlFunctionCall && ((KmlFunctionCall)expression).getFunctionName().equals("old")) {
            this.l_prefix = this.bExp = expression.getRawValue();
        }
        return true;
    }

    public boolean visit(KmlUnchangedExpression expression) {
        ArrayList<String> al = new ArrayList<String>();
        for (KmlIdentifier op : expression.getVariables()) {
            al.add("l_" + op.getRawValue() + " := " + op.getRawValue());
            this.l_prefix = this.bExp = Spec.listToString(al, (String)"", (String)" & ", (String)"");
        }
        return false;
    }

    public boolean visit(KmlUnaryOp expression) {
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        expression.getOperand().accept((ExpressionVisitor)v);
        String op = expression.getOpname();
        if (op == "old") {
            this.bExp = v.bExp;
            this.l_prefix = v.l_prefix;
        }
        if (op == "not") {
            this.bExp = " not (" + v.bExp + ")";
            this.l_prefix = " not (" + v.l_prefix + ")";
        } else if (op == "~") {
            this.bExp = " not (" + v.bExp + ")";
            this.l_prefix = " not (" + v.l_prefix + ")";
        } else {
            if (op == null) {
                op = "";
            }
            this.bExp = String.valueOf(op) + " (" + v.bExp + ")";
            this.l_prefix = String.valueOf(op) + " (" + v.l_prefix + ")";
        }
        this.type = this.visitType(expression.getType());
        this.vars = v.vars;
        return false;
    }

    public void addVar(String s) {
        if (!this.vars.contains(s)) {
            this.vars.add(s);
        }
    }

    public void addVars(ArrayList<String> al) {
        Iterator<String> iter = al.iterator();
        while (iter.hasNext()) {
            this.addVar(iter.next());
        }
    }

    public boolean visit(NavigateExpression expression) {
        return false;
    }

    public boolean visit(KmlExpression expression) {
        if (expression instanceof KmlFunctionCall) {
            this.visit((KmlFunctionCall)expression);
        } else {
            this.bExp = expression.getRawValue();
            if (expression.getType() == CostoBoolean.instance) {
                this.bExp = this.bExp.toUpperCase();
            } else {
                this.addVar(this.bExp);
            }
            this.l_prefix = this.bExp;
            this.type = this.visitType(expression.getType());
        }
        return true;
    }
}

