/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml2latex;

import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.Composition;
import costo.graph.KmlElement;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.visitors.KmlElementVisitor;
import costolib.ui.interfaces.IComponentActor;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kml2latex.LatexContext;
import kml2latex.visitors.KmlLatexExpressionVisitor;
import kml2latex.visitors.KmlLatexVisitor;

public class ComponentKml2LatexActor
implements IComponentActor {
    public static boolean verbose = true;
    public static boolean errverbose = true;
    private String currentDir = "";

    public void doSomethingWithComponent(Component comp, KmlElement currentSelection, String relativePath) {
        try {
            LatexContext lctx = this.fixContextAndPaths(comp, true, relativePath);
            if (verbose) {
                System.out.println("Starting generation for " + comp.getName());
            }
            Configuration cfg = new Configuration();
            cfg.setClassForTemplateLoading(this.getClass(), "templates");
            Template templ = cfg.getTemplate("template.ftl");
            Map<String, Object> root = this.translate_to_latex(lctx, comp, relativePath);
            this.writeLatexFile(lctx, templ, root);
        }
        catch (IOException e) {
            if (errverbose) {
                System.err.println("file error (path) :" + this.getCurrentDir());
            }
            e.printStackTrace();
        }
    }

    public boolean isApplicableFor(KmlElement currentSelection) {
        return false;
    }

    public void setCurrentDir(String currentDir) {
        this.currentDir = currentDir;
        File f = new File(currentDir);
        f.mkdirs();
        if (verbose) {
            System.out.println(String.valueOf(currentDir) + " " + f.exists());
        }
    }

    private String getCurrentDir() {
        return this.currentDir;
    }

    public void writeLatexFile(LatexContext lc, Template templ, Map<String, Object> root) throws IOException {
        String filename = String.valueOf(lc.getOutputdir()) + lc.getComponent().getName() + ".tex";
        FileWriter fw = new FileWriter(filename);
        try {
            templ.process(root, (Writer)fw);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        fw.flush();
        fw.close();
        if (verbose) {
            System.out.println("written in " + filename);
        }
    }

    protected LatexContext fixContextAndPaths(Component comp, Boolean isMain, String relativePath) {
        LatexContext lc = null;
        String compPath = comp.getFilePath();
        String projectroot = compPath.substring(0, compPath.indexOf(relativePath));
        int lastdot = relativePath.lastIndexOf(".");
        String exportdirRelPath = relativePath.substring(0, lastdot);
        String cleanedRelPath = exportdirRelPath.replaceAll("/", "\u00c3\u00b9").replaceAll("[^\\p{Alnum}.\u00c3\u00b9]", "");
        String exportingPath = String.valueOf(projectroot) + "LATEX" + "/" + cleanedRelPath.replaceAll("\u00c3\u00b9", "/") + "/";
        if (verbose) {
            System.out.println("exportingPath " + exportingPath);
        }
        this.setCurrentDir(exportingPath);
        Properties kml2latexProp = new Properties();
        try {
            kml2latexProp.load(new FileInputStream(String.valueOf(projectroot) + "Kml2latex.userprefs"));
            String latexdir = kml2latexProp.getProperty("kmlToLatex.latexdir");
            lc = new LatexContext(comp, isMain, latexdir, exportingPath, String.valueOf(exportingPath) + "FIGURES/", kml2latexProp);
            if (verbose) {
                System.out.println("context " + lc.toString());
            }
        }
        catch (FileNotFoundException e) {
            if (errverbose) {
                System.err.println("file " + projectroot + "Kml2latex.userprefs" + " does not exist");
            }
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lc;
    }

    private Map<String, Object> translate_to_latex(LatexContext lctx, Component comp, String relativePath) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Date dt = new Date();
        root.put("today", dt);
        root.put("latexContext", lctx);
        KmlLatexExpressionVisitor ev = new KmlLatexExpressionVisitor();
        KmlLatexVisitor lvisitor = new KmlLatexVisitor(lctx, (ExpressionVisitor)ev);
        comp.accept((KmlElementVisitor)lvisitor);
        root.put("cSpec", lvisitor.getSpec());
        root.put("comment", comp.getComment());
        root.put("servList", lvisitor.getServices());
        root.put("composition", comp.isComposite());
        if (comp.isComposite()) {
            Composition compos = comp.getComposition();
            root.put("compositionSpec", lvisitor.getComposition());
            ArrayList subComponentDescr = new ArrayList();
            for (ComponentVariable subcv : compos.getAssembly().getNamedComponents()) {
                Component subc = subcv.getComponentType();
                System.out.println("subcompos to visited: " + subc.getName());
                HashMap<String, Object> base = new HashMap<String, Object>();
                LatexContext sublctx = new LatexContext(subc, false, lctx);
                base.put("latexContext", sublctx);
                KmlLatexVisitor sublvisitor = new KmlLatexVisitor(sublctx, (ExpressionVisitor)ev);
                subc.accept((KmlElementVisitor)sublvisitor);
                base.put("cSpec", sublvisitor.getSpec());
                base.put("comment", subc.getComment());
                base.put("servList", sublvisitor.getServices());
                base.put("composition", subc.isComposite());
                if (subc.isComposite()) {
                    base.put("compositionSpec", sublvisitor.getComposition());
                }
                subComponentDescr.add(base);
            }
            root.put("subcompList", subComponentDescr);
            System.err.println("subcompList=" + subComponentDescr.size());
        }
        System.out.println("visited: " + lvisitor.getCvisited());
        return root;
    }
}

