/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui;

import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.CostoLibrary;
import costolib.ui.editorstest.SimpleTemplate;
import costolib.ui.interfaces.IComponentListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "costolib.ui";
    private static Activator plugin;
    private HashMap<String, Component> loadedComponentsByPath = new HashMap();
    private ArrayList<SimpleTemplate> templates;
    private CostoLibrary costolib;
    private Component currentComponent;
    private List<IComponentListener> componentListeners = new ArrayList<IComponentListener>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.createTemplates();
        plugin = this;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = reg.getConfigurationElementsFor("COSTOLIB_PLUGIN_UI.componentViewer");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            this.componentListeners.add((IComponentListener)elem.createExecutableExtension("class"));
            ++n2;
        }
    }

    public Image getIcon(String relativeURL) {
        Image image = plugin.getImageRegistry().get(relativeURL);
        if (image == null) {
            URL imageURL = plugin.getBundle().getEntry(relativeURL);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
            image = descriptor.createImage();
            plugin.getImageRegistry().put(relativeURL, image);
        }
        return image;
    }

    public void setCostoLib(ComponentFactory cf) {
        String libpath = null;
        if (Activator.getDefault().getPreferenceStore().getBoolean("defaultLibrary")) {
            if (this.costolib == null) {
                try {
                    URL typesurl = Platform.getBundle((String)"COSTOLIB_PLUGIN_CORE").getEntry("/kmllibs/DEFAULT/types.klt");
                    URL functionsurl = Platform.getBundle((String)"COSTOLIB_PLUGIN_CORE").getEntry("/kmllibs/DEFAULT/functions.klf");
                    URL constantsurl = Platform.getBundle((String)"COSTOLIB_PLUGIN_CORE").getEntry("/kmllibs/DEFAULT/constants.klc");
                    InputStream types = null;
                    InputStream functions = null;
                    InputStream constants = null;
                    if (typesurl != null) {
                        types = typesurl.openStream();
                    }
                    if (functionsurl != null) {
                        functions = functionsurl.openStream();
                    }
                    if (constantsurl != null) {
                        constants = constantsurl.openStream();
                    }
                    this.costolib = new CostoLibrary(cf, "DEFAULT", types, functions, constants);
                    if (typesurl != null) {
                        types.close();
                    }
                    if (functionsurl != null) {
                        functions.close();
                    }
                    if (constantsurl != null) {
                        constants.close();
                    }
                }
                catch (Exception exception) {}
            }
            cf.setStartingLibrary(this.costolib);
        } else {
            libpath = String.valueOf(Activator.getDefault().getPreferenceStore().getString("customLibraryPath")) + File.separator;
        }
        cf.loadDefaultLibrary(libpath);
    }

    public ComponentFactory getComponentFactory(String abspath) throws IOException {
        ComponentFactory cf = new ComponentFactory();
        cf.init();
        this.setCostoLib(cf);
        cf.setAbsSpecDir(abspath);
        return cf;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("costolib.ui.messages");
    }

    private void createTemplates() {
        Properties textTemplates = new Properties();
        HashSet<SimpleTemplate> uniquetemps = new HashSet<SimpleTemplate>();
        try {
            InputStream templatesStream = Platform.getBundle((String)"COSTOLIB_PLUGIN_UI").getEntry("/resources/templates.txt").openStream();
            textTemplates.load(templatesStream);
            for (Map.Entry<Object, Object> entry : textTemplates.entrySet()) {
                String[] prefixes;
                String prefix = entry.getKey().toString();
                prefix = prefix.replaceAll("\\d", "");
                String[] stringArray = prefixes = prefix.split("_");
                int n = prefixes.length;
                int n2 = 0;
                while (n2 < n) {
                    String value;
                    String pref = stringArray[n2];
                    String description = entry.getValue().toString();
                    int i = description.indexOf(64);
                    if (i != -1) {
                        value = description.substring(i + 1);
                        description = description.substring(0, i);
                    } else {
                        value = description;
                    }
                    uniquetemps.add(new SimpleTemplate(pref, description, value));
                    ++n2;
                }
            }
            templatesStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.templates = this.sortedList(uniquetemps);
        this.expanseTemplates();
    }

    private ArrayList<SimpleTemplate> sortedList(Set<SimpleTemplate> set) {
        ArrayList<SimpleTemplate> names = new ArrayList<SimpleTemplate>();
        names.addAll(set);
        Collections.sort(names);
        return names;
    }

    private void expanseTemplates() {
        for (SimpleTemplate st : this.templates) {
            int i;
            String value = st.getTemplateValue();
            while ((i = value.indexOf("$")) != -1) {
                try {
                    int endname = st.getTemplateValue().indexOf(" ", i);
                    String templatename = st.getTemplateValue().substring(i + 1, endname);
                    String templatevalue = "";
                    for (SimpleTemplate each : this.templates) {
                        if (!each.getTemplatePrefix().equals(templatename)) continue;
                        templatevalue = each.getTemplateValue();
                        break;
                    }
                    value = String.valueOf(value.substring(1, i)) + templatevalue + value.substring(endname);
                    st.setTemplateValue(value);
                }
                catch (Exception exception) {}
            }
        }
    }

    public ArrayList<SimpleTemplate> getTemplates() {
        return this.templates;
    }

    public Component get(Object key) {
        return this.loadedComponentsByPath.get(key);
    }

    public Component put(String key, Component value) {
        return this.loadedComponentsByPath.put(key, value);
    }

    public void setCurrentComponent(Component currentComponent) {
        this.currentComponent = currentComponent;
        for (IComponentListener compL : this.componentListeners) {
            compL.componentChanged(currentComponent);
        }
    }
}

