/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.builder;

import costo.checks.errorLogger.KmlError;
import costo.checks.errorLogger.KmlLogger;
import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.ComponentVariable;
import costo.graph.CostoLibrary;
import costolib.ui.Activator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class SampleBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "COSTOLIB_PLUGIN_UI.KMLBuilder";
    private static final String MARKER_TYPE = "COSTOLIB_PLUGIN_UI.KMLProblem";
    private HashMap<String, Vector<IResource>> libDependencies = new HashMap();
    private HashMap<String, Vector<IResource>> assemblyDependencies = new HashMap();

    private void addMarker(IFile file, KmlError error) {
        try {
            int severity = error.getErrortype().contains("WARNING") ? 1 : 2;
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)error.getMessage());
            marker.setAttribute("severity", severity);
            int lineNumber = error.getLine();
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("column", error.getColumn());
            marker.setAttribute("ERROR_TYPE", (Object)error.getErrortype());
        }
        catch (CoreException coreException) {}
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta != null) {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    void checkKML(IResource resource) {
        if (resource instanceof IFile && (resource.getName().endsWith(".kcp") || resource.getName().endsWith(".kti"))) {
            this.checkComponentFile(resource, false);
        }
        if (resource instanceof IFolder && this.isALibrary((IFolder)resource)) {
            this.checkLibrary((IFolder)resource);
        }
    }

    public void checkLibrary(IFolder resource) {
        String abspath = resource.getRawLocation().removeLastSegments(1).toString();
        String libname = resource.getRawLocation().lastSegment().toString();
        try {
            ComponentFactory cf = Activator.getDefault().getComponentFactory(abspath);
            CostoLibrary cos = new CostoLibrary(libname, cf);
            this.checkLibDependencies(libname);
            this.manageLibErrors(cf.getLogger(), resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkLibDependencies(String libname) {
        Vector<IResource> res = this.libDependencies.get(libname);
        if (res == null) {
            return;
        }
        int i = 0;
        while (i < res.size()) {
            this.checkComponentFile(res.get(i), true);
            ++i;
        }
    }

    private void checkAssemblyDependencies(String compPath) {
        Vector<IResource> res = this.assemblyDependencies.get(compPath);
        if (res == null) {
            return;
        }
        int i = 0;
        while (i < res.size()) {
            this.checkComponentFile(res.get(i), true);
            ++i;
        }
    }

    private void manageLibErrors(KmlLogger logger, IFolder resource) {
        this.deleteMarkers(resource);
        for (ArrayList errors : logger.getErrorsByType().values()) {
            for (KmlError error : errors) {
                Path path = new Path(error.getFilename());
                IFile other = (IFile)resource.findMember(path.lastSegment());
                if (other == null) continue;
                this.addMarker(other, error);
            }
        }
    }

    private void deleteMarkers(IFolder resource) {
        this.deleteMarkers((IFile)resource.findMember("types.klt"));
        this.deleteMarkers((IFile)resource.findMember("functions.klf"));
        this.deleteMarkers((IFile)resource.findMember("constants.klc"));
    }

    private boolean isALibrary(IFolder resource) {
        if (resource.findMember("types.klt") != null) {
            return true;
        }
        if (resource.findMember("functions.klf") != null) {
            return true;
        }
        return resource.findMember("constants.klc") != null;
    }

    private void checkComponentFile(IResource resource, boolean recheck) {
        IFile file = (IFile)resource;
        this.deleteMarkers(file);
        try {
            String abspath = file.getRawLocation().removeLastSegments(1).toString();
            String compname = file.getRawLocation().lastSegment().toString();
            ComponentFactory cf = Activator.getDefault().getComponentFactory(abspath);
            Component comp = cf.getComponent(compname);
            if (comp != null) {
                Activator.getDefault().put(comp.getFilePath(), comp);
                this.checkAssemblyDependencies(comp.getFilePath());
                if (!recheck) {
                    this.computeDependencies(resource, comp);
                }
            }
            this.manageKmlErrors(cf.getLogger(), file);
        }
        catch (Throwable e1) {
            System.err.println("Caught exception in the builder for " + file.getRawLocation().toString());
            e1.printStackTrace();
        }
    }

    private void computeDependencies(IResource resource, Component comp) {
        for (CostoLibrary lib : comp.getLibraries()) {
            if (lib.getName().equals("DEFAULT")) continue;
            this.addLibDependency(lib.getName(), resource);
        }
        if (comp.isComposite()) {
            for (ComponentVariable compvar : comp.getComposition().getAssemblyNamedComponents()) {
                if (compvar.getComponentType() == null || compvar.getComponentType() == comp) continue;
                if (this.depends(resource.getFullPath().toString(), compvar.getComponentType().getFilePath())) {
                    comp.getLogger().log("circular dependency in composition", (Object)comp, "COMPOSITION ERROR", compvar.getLine(), compvar.getColumn(), comp.getFilePath());
                    continue;
                }
                this.addAssemblyDependency(compvar.getComponentType().getFilePath(), resource);
            }
        }
    }

    private boolean depends(String main, String sub) {
        for (Map.Entry<String, Vector<IResource>> entry : this.assemblyDependencies.entrySet()) {
            if (!entry.getKey().contains(main)) continue;
            if (entry.getValue() == null) {
                return false;
            }
            for (IResource r : entry.getValue()) {
                if (!sub.contains(r.getFullPath().toString())) continue;
                return true;
            }
        }
        return false;
    }

    private void addAssemblyDependency(String filePath, IResource resource) {
        Vector<Object> res = this.assemblyDependencies.get(filePath);
        if (res == null) {
            res = new Vector();
        }
        if (!res.contains(resource)) {
            res.add(resource);
        }
        this.assemblyDependencies.put(filePath, res);
    }

    private void addLibDependency(String name, IResource resource) {
        Vector<Object> res = this.libDependencies.get(name);
        if (res == null) {
            res = new Vector();
        }
        if (!res.contains(resource)) {
            res.add(resource);
        }
        this.libDependencies.put(name, res);
    }

    private void manageKmlErrors(KmlLogger logger, IFile file) {
        for (ArrayList errors : logger.getErrorsByType().values()) {
            for (KmlError error : errors) {
                if (error.getFilename().equals(file.getRawLocation().toOSString())) {
                    this.addMarker(file, error);
                    continue;
                }
                if (!error.getFilename().endsWith("srv") && !error.getFilename().endsWith("txt") && !error.getFilename().endsWith("ksv") && !error.getFilename().endsWith("klt") && !error.getFilename().endsWith("klc") && !error.getFilename().endsWith("klf")) continue;
                Path path = new Path(error.getFilename());
                IFile other = (IFile)file.getParent().findMember(path.lastSegment());
                if (other == null) continue;
                this.addMarker(other, error);
            }
        }
    }

    private void deleteMarkers(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new SampleResourceVisitor());
        }
        catch (CoreException coreException) {}
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    SampleBuilder.this.checkKML(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    SampleBuilder.this.checkKML(resource);
                }
            }
            return true;
        }
    }

    class SampleResourceVisitor
    implements IResourceVisitor {
        SampleResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            SampleBuilder.this.checkKML(resource);
            return true;
        }
    }
}

