/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.editorstest;

import costo.graph.Component;
import costo.graph.Composition;
import costo.graph.KmlElement;
import costo.graph.KmlStructuralElement;
import costo.graph.Link;
import costolib.ui.Activator;
import costolib.ui.editorstest.SimpleTemplate;
import costolib.ui.editorstest.XMLEditor;
import costolib.ui.interfaces.IComponentActor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;

public class CostoEditorContributor
extends BasicTextEditorActionContributor {
    private static final String ACTORS_EXTENSION_ID = "costolib.ui.componentActor";

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        this.addExternalActions(toolBarManager);
    }

    private void addTemplateActions(IToolBarManager toolBarManager) {
        for (SimpleTemplate templ : Activator.getDefault().getTemplates()) {
            toolBarManager.add((IAction)new TemplateAction(templ));
        }
    }

    private void addExternalActions(IToolBarManager toolBarManager) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = reg.getConfigurationElementsFor(ACTORS_EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contributor = iConfigurationElementArray[n2];
            try {
                String name = contributor.getAttribute("button_name");
                IComponentActor actor = (IComponentActor)contributor.createExecutableExtension("class");
                toolBarManager.add((IAction)new ExporterAction(name, actor));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        Activator.getDefault().setCurrentComponent(((XMLEditor)part).getCurrentComponent());
    }

    private class ExporterAction
    extends Action {
        private IComponentActor actor;
        private String projectPath;
        private String relativePath;

        public ExporterAction(String text, IComponentActor actor) {
            super(text);
            this.actor = null;
            this.projectPath = null;
            this.actor = actor;
        }

        public void run() {
            Component comp = this.getComponent();
            if (comp == null) {
                System.err.println("comp is null");
            } else if (this.actor != null) {
                KmlElement selectedElement = this.getSelectedElement(comp);
                this.actor.doSomethingWithComponent(comp, selectedElement, this.relativePath);
            }
            super.run();
        }

        private KmlElement getSelectedElement(Component comp) {
            XMLEditor editor = (XMLEditor)CostoEditorContributor.this.getActiveEditorPart();
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            this.projectPath = editor.getProjectRoot();
            this.relativePath = editor.getRelativePathToProjectRoot();
            if (comp == null) {
                return null;
            }
            TextSelection selection = (TextSelection)editor.getSelectionProvider().getSelection();
            int cursoroffset = selection.getOffset();
            KmlStructuralElement selectedelem = null;
            int line = 0;
            try {
                line = doc.getLineOfOffset(cursoroffset) + 1;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (comp.getStructuralElements() != null) {
                for (KmlStructuralElement elem : comp.getStructuralElements()) {
                    if (!elem.lineInElement(line)) continue;
                    selectedelem = elem;
                }
            }
            if (selectedelem != null && selectedelem instanceof Composition) {
                for (Link ln : ((Composition)selectedelem).getAssembly().getLinks().values()) {
                    if (ln.getLine() != line) continue;
                    return ln;
                }
            }
            return selectedelem;
        }

        private Component getComponent() {
            Component comp = null;
            try {
                XMLEditor editor = (XMLEditor)CostoEditorContributor.this.getActiveEditorPart();
                comp = editor.getCurrentComponent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return comp;
        }
    }

    private class TemplateAction
    extends Action {
        private SimpleTemplate templ;

        public TemplateAction(SimpleTemplate templ) {
            super(templ.getTemplatePrefix());
            this.templ = templ;
        }

        public void run() {
            this.insertIntoEditor(this.templ.getTemplateValue());
            super.run();
        }

        private void insertIntoEditor(String templateValue) {
            XMLEditor editor = (XMLEditor)CostoEditorContributor.this.getActiveEditorPart();
            editor.getEditorInput();
        }

        private KmlElement getSelectedElement(Component comp) {
            return null;
        }
    }
}

