/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.editorstest;

import costo.graph.Component;
import costo.graph.KmlStructuralElement;
import costolib.ui.editorstest.XMLEditor;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;

public class KmlReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private XMLEditor editor;
    private IDocument fDocument;
    protected final ArrayList<Position> fPositions = new ArrayList();
    protected int fOffset;
    protected int fRangeEnd;

    public XMLEditor getEditor() {
        return this.editor;
    }

    public void setEditor(XMLEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.fOffset = 0;
        this.fRangeEnd = this.fDocument.getLength();
        this.calculatePositions();
    }

    protected void calculatePositions() {
        this.fPositions.clear();
        this.analysePositionsFromComponent(this.editor.getCurrentComponent());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                KmlReconcilingStrategy.this.editor.updateFoldingStructure(KmlReconcilingStrategy.this.fPositions);
            }
        });
    }

    private void analysePositionsFromComponent(Component currentComponent) {
        if (currentComponent == null) {
            return;
        }
        for (KmlStructuralElement elem : currentComponent.getStructuralElements()) {
            if (elem.getLine() == 0 || elem.getLastLine() == 0) continue;
            this.emitLineColPosition(elem);
        }
    }

    protected void emitLineColPosition(KmlStructuralElement elem) {
        if (elem.getLine() > 0 && elem.getLastLine() != elem.getLine()) {
            int startOffset = this.editor.getOffsetFrom(elem.getLine() - 1, 0);
            int length = this.editor.getOffsetFrom(elem.getLastLine(), 0) - startOffset;
            if (length < 1) {
                length = 1;
            }
            this.fPositions.add(new Position(startOffset, length));
        }
    }
}

