/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.editorstest;

import costo.graph.Link;
import costolib.ui.editorstest.ColorManager;
import costolib.ui.editorstest.CompletionProcessor;
import costolib.ui.editorstest.KmlReconcilingStrategy;
import costolib.ui.editorstest.XMLDoubleClickStrategy;
import costolib.ui.editorstest.XMLEditor;
import costolib.ui.editorstest.XMLScanner;
import costolib.ui.editorstest.XMLTagScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private ColorManager colorManager;
    private XMLEditor editor;

    public XMLConfiguration(ColorManager colorManager, XMLEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler pr = new PresentationReconciler();
        DefaultDamagerRepairer ddr = new DefaultDamagerRepairer((ITokenScanner)new XMLTagScanner(this.colorManager));
        pr.setRepairer((IPresentationRepairer)ddr, "__dftl_partition_content_type");
        pr.setDamager((IPresentationDamager)ddr, "__dftl_partition_content_type");
        return pr;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextHover(sourceViewer);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        CompletionProcessor cap = new CompletionProcessor(this.editor);
        ca.setContentAssistProcessor((IContentAssistProcessor)cap, "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant test = new QuickAssistAssistant();
        test.setQuickAssistProcessor(new IQuickAssistProcessor(){

            public String getErrorMessage() {
                return "error";
            }

            public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
                return null;
            }

            public boolean canFix(Annotation annotation) {
                if (annotation instanceof MarkerAnnotation) {
                    MarkerAnnotation markannot = (MarkerAnnotation)annotation;
                    try {
                        if (markannot.getMarker().getAttribute("ERROR_TYPE").equals("LINK COMPATIBILITY ERROR")) {
                            for (Link ln : XMLConfiguration.this.editor.getCurrentComponent().getComposition().getAssembly().getLinks().values()) {
                                if (ln.getLine() != ((Integer)markannot.getMarker().getAttribute("lineNumber")).intValue()) continue;
                                System.err.println(ln);
                            }
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }

            public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
                return true;
            }
        });
        return null;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        KmlReconcilingStrategy strategy = new KmlReconcilingStrategy();
        strategy.setEditor(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }
}

