/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.editorstest;

import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.KmlStructuralElement;
import costolib.ui.Activator;
import costolib.ui.editorstest.ColorManager;
import costolib.ui.editorstest.XMLConfiguration;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class XMLEditor
extends TextEditor {
    private ProjectionSupport projectionSupport;
    private ColorManager colorManager = new ColorManager();
    private IContentOutlinePage contentOutlinePage;
    private Component currentComponent;
    private Annotation[] oldAnnotations;
    private ProjectionAnnotationModel annotationModel;
    private String relativePathToProjectRoot;
    private String projectRoot;

    public Component getCurrentComponent() {
        return this.currentComponent;
    }

    public void setCurrentComponent(Component currentComponent) {
        this.currentComponent = currentComponent;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.reloadComponent();
    }

    public KmlStructuralElement getSelectedStructuralElement(int line) {
        if (this.currentComponent == null) {
            return null;
        }
        for (KmlStructuralElement elem : this.currentComponent.getStructuralElements()) {
            if (!elem.lineInElement(line)) continue;
            return elem;
        }
        return null;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.reloadComponent();
    }

    private void reloadComponent() {
        StringReader sr = new StringReader(this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get());
        try {
            String abspath = "";
            IEditorInput input = this.getEditorInput();
            if (input instanceof FileEditorInput) {
                abspath = ((FileEditorInput)input).getFile().getRawLocation().removeLastSegments(1).toString();
                try {
                    this.relativePathToProjectRoot = ((FileEditorInput)input).getFile().getProjectRelativePath().toString();
                }
                catch (Exception exception) {}
            }
            ComponentFactory cf = Activator.getDefault().getComponentFactory(abspath);
            this.currentComponent = cf.loadComponent((Reader)sr);
            if (this.currentComponent != null) {
                this.currentComponent.setFilePath(String.valueOf(abspath) + "/" + this.currentComponent.getName() + ".kcp");
            }
            Activator.getDefault().setCurrentComponent(this.currentComponent);
        }
        catch (Throwable e) {
            System.err.println(e.getClass());
            e.printStackTrace();
        }
    }

    public XMLEditor() {
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager, this));
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(Activator.getDefault().getResourceBundle(), "Editor.ContentAssist.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)action);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(ArrayList<Position> positions) {
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }

    public int getOffsetFrom(int line, int column) {
        try {
            return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(line) + column;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public String getRelativePathToProjectRoot() {
        return this.relativePathToProjectRoot;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }
}

