/*
 * Decompiled with CFR 0.152.
 */
package kml2mec;

import java.util.ArrayList;

public class MecFunction {
    protected String name;
    protected ArrayList<String> param;
    protected String result;
    protected String comment;
    protected String body;

    public MecFunction() {
        this.body = "";
        this.comment = "";
        this.name = "";
        this.param = new ArrayList();
        this.result = "";
    }

    public MecFunction(String body, String comment, String name, ArrayList<String> param, String result) {
        this.body = body;
        this.comment = comment;
        this.name = name;
        this.param = param;
        this.result = result;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<String> getParam() {
        return this.param;
    }

    public void setParam(ArrayList<String> param) {
        this.param = param;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String toString() {
        String s = "function " + this.name + "(";
        int leng = this.param.size();
        for (String p : this.param) {
            s = String.valueOf(s) + p;
            if (--leng <= 0) continue;
            s = String.valueOf(s) + "; ";
        }
        s = String.valueOf(s) + ") ";
        if (this.result.length() > 1) {
            s = String.valueOf(s) + " return " + this.result;
        }
        s = String.valueOf(s) + ";\n";
        if (this.comment.length() > 1) {
            s = String.valueOf(s) + "  \\* " + this.comment + " *\\";
        }
        s = String.valueOf(s) + "\nbegin \n" + this.body + "\n" + "end.\n";
        return s;
    }

    public static MecFunction inevitable() {
        MecFunction mf = new MecFunction();
        mf.name = "inevitable";
        mf.param.add("Y : trans");
        mf.param.add("X : state");
        mf.result = "Z : state";
        mf.comment = "Get the Z states that are impossible to avoid \n      from the X states and the Y transitions.";
        mf.body = "   Z = X \\/ (src(Y /\\ rtgt(Z)) - src(Y /\\ rtgt(*-Z)))";
        return mf;
    }
}

