/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.chaine;

import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.Service;
import costo.graph.ServiceIdentifier;
import costo.graph.Variable;
import costo.graph.types.CostoType;
import costolib_plugin_kml_test.chaine.ITComponent;
import costolib_plugin_kml_test.chaine.TAssignment;
import costolib_plugin_kml_test.chaine.TConcretize;
import costolib_plugin_kml_test.chaine.TMock;
import costolib_plugin_kml_test.chaine.TUtile;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TService {
    private ITComponent tOwner;
    private boolean isSut = false;
    private boolean isProvider = false;
    private boolean isMock = false;
    private ServiceIdentifier sid = null;
    private Service service = null;
    protected TAssignment tassignment;
    Map<Service, Object> requiredSatServ = new HashMap<Service, Object>();
    private Variable varAssigned = null;
    private Variable result = null;
    private Map<String, Variable> servParams = new HashMap<String, Variable>();
    private List<Variable> variables = new ArrayList<Variable>();

    public TService(ServiceIdentifier sid, ITComponent towner) {
        this.sid = sid;
        this.tOwner = towner;
        this.service = sid.getServ();
        if (this.service == null) {
            System.out.println(sid + " is null ");
        }
    }

    public JPanel getProvPanel() {
        JPanel paramAssignPanel = new JPanel();
        ArrayList<Variable> params = this.sid.getServ().getParameters();
        if (params == null) {
            params = new ArrayList<Variable>();
        }
        if (this.sid.getServ().getResultVar() != null) {
            params.add(this.sid.getServ().getResultVar());
            this.isProvider = true;
        }
        if (params != null && !params.isEmpty()) {
            paramAssignPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), String.valueOf(this.sid.getServ().getName()) + " Parameters"));
            paramAssignPanel.setLayout(new GridLayout(0, 3, 10, 10));
            int parampos = 0;
            final TService tserv = this;
            for (final Variable param : params) {
                if (!param.getName().equals(this.service.getResultVar().getName())) {
                    this.variables.add(param);
                }
                this.servParams.put(param.getName(), null);
                final JButton assignButton = new JButton("unassigned");
                final int pos = parampos;
                assignButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Variable absvar = null;
                        if (param == TService.this.service.getResultVar()) {
                            absvar = TUtile.selectOutputVariableToAssign(param);
                            if (absvar == null) {
                                return;
                            }
                            if (absvar.getName().startsWith("New Output Variable")) {
                                TUtile.intentionPanel.createNewOutputVariable(absvar);
                            }
                        } else {
                            absvar = TUtile.selectInputVariableToAssign(param);
                            if (absvar == null) {
                                return;
                            }
                            if (absvar.getName().startsWith("New Input Variable")) {
                                TUtile.intentionPanel.createNewInputVariable(absvar);
                            }
                        }
                        if (!TService.this.isSut) {
                            TUtile.outputAssignments.remove(absvar.getName());
                        }
                        if (!absvar.getName().equals("unassigned")) {
                            TService.this.servParams.put(param.getName(), absvar);
                            if (absvar != null && !TUtile.inOutvarsUsed.contains(absvar)) {
                                TUtile.inOutvarsUsed.add(absvar);
                            }
                        } else {
                            TService.this.servParams.put(param.getName(), null);
                        }
                        if (param == TService.this.service.getResultVar()) {
                            TService.this.result = absvar;
                            TUtile.intentionPanel.assignOutputParameter(absvar, param, TService.this.sid, pos);
                            if (!TService.this.isSut) {
                                TUtile.outputAssignments.put(absvar.getName(), tserv);
                            }
                        } else {
                            TUtile.intentionPanel.assignInputParameter(absvar, param, TService.this.sid, pos);
                        }
                        assignButton.setText(absvar.getName());
                        TUtile.evaluateStateAssigments();
                    }
                });
                paramAssignPanel.add(assignButton);
                paramAssignPanel.add(new JLabel(param.toString()));
                paramAssignPanel.add(new JLabel(""));
            }
            ++parampos;
        }
        return paramAssignPanel;
    }

    public JPanel getRequiredView(JPanel reqPanel) {
        ServiceIdentifier reqsi = null;
        if (this.sid != null) {
            reqsi = new ServiceIdentifier(this.sid.getCompVar(), this.service);
        }
        final ServiceIdentifier reqsi2 = reqsi;
        final JButton assignButton = new JButton("unassigned");
        final JButton nb = new JButton("unassigned");
        final Service reqServ = this.service;
        assignButton.setName(this.service.getName());
        assignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Variable absvar = TUtile.selectInputVariableToAssign(reqServ);
                if (absvar == null) {
                    return;
                }
                if (absvar.getName().startsWith("New Input Variable")) {
                    System.out.println("Must create new variable");
                    TUtile.intentionPanel.createNewInputVariable(absvar);
                }
                if (!absvar.getName().equals("unassigned")) {
                    TService.this.varAssigned = absvar;
                } else {
                    TService.this.varAssigned = null;
                }
                TUtile.intentionPanel.assignRequired(absvar, reqsi2);
                assignButton.setText(absvar.getName());
                TUtile.evaluateStateAssigments();
            }
        });
        reqPanel.add(assignButton);
        reqPanel.add(new JLabel(reqServ.getSignature()));
        nb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceIdentifier selected;
                ServiceIdentifier lastSelected = null;
                if (TService.this.tassignment != null && (TService.this.tassignment.getType() == TConcretize.TSERVICE || TService.this.tassignment.getType() == TConcretize.TMOCK)) {
                    TService provServ = (TService)TService.this.tassignment.getObject();
                    lastSelected = provServ.getSid();
                    ITComponent tcomp = provServ.getTOwner();
                    tcomp.removeProvided(provServ);
                }
                if ((selected = TUtile.assignReq(reqsi2, lastSelected)) != null) {
                    TUtile.mocks.remove(TService.this.sid.getVarName());
                    nb.setText(selected.toString());
                    if (!selected.getVarName().contains("Mock")) {
                        for (ITComponent tcomp : TUtile.tcomponents) {
                            if (!tcomp.getCompVar().equals(selected.getCompVar())) continue;
                            if (!tcomp.isVisible()) {
                                tcomp.setVisible(true);
                            }
                            TService tserv = new TService(selected, tcomp);
                            tcomp.addProvided(tserv);
                            TService.this.tassignment = new TAssignment(TConcretize.TSERVICE, tserv);
                            break;
                        }
                    } else {
                        CostoType ctype = TService.this.sid.getServ().getReturnCostoType();
                        ComponentVariable cMock = new ComponentVariable(selected.getVarName(), new Component(String.valueOf(ctype.getName()) + "Mock"));
                        TMock tMock = new TMock(cMock, ctype);
                        TUtile.tcomponents.add(tMock);
                        tMock.setVisible(true);
                        Service srv = new Service("value", true);
                        srv.setOrigCompName(cMock.getVarName());
                        srv.setReturnCostoType(ctype);
                        srv.setOwner(cMock.getComponentType());
                        srv.setOrigin(cMock);
                        ServiceIdentifier sId = new ServiceIdentifier(cMock, srv);
                        TService tserv = new TService(sId, tMock);
                        tMock.addProvided(tserv);
                        TService.this.tassignment = new TAssignment(TConcretize.TMOCK, tserv);
                        TUtile.mocks.put(TService.this.sid.getVarName(), tserv);
                    }
                } else {
                    TService.this.tassignment = null;
                    nb.setText("unassigned");
                }
                TUtile.hideUnusedTab();
                TUtile.evaluateStateAssigments();
            }
        });
        reqPanel.add(nb);
        return reqPanel;
    }

    public boolean isAssigned() {
        if (this.isProvider) {
            Variable rsltVal = this.servParams.get(this.service.getResultVar());
            if (rsltVal == null) {
                Iterator<String> iterator = this.servParams.keySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            } else {
                System.out.println(String.valueOf(this.service.getName()) + " assing from its return ");
            }
            return true;
        }
        if (this.tassignment != null) {
            if (this.tassignment.getType() == TConcretize.INPUT_VAR || this.tassignment.getType() == TConcretize.TMOCK) {
                return true;
            }
            if (this.tassignment.getType() == TConcretize.TSERVICE) {
                TService tserv = (TService)this.tassignment.getObject();
                return tserv.isAssigned();
            }
        }
        return false;
    }

    public Map<String, String> getLink() {
        HashMap<String, String> link = new HashMap<String, String>();
        if (this.tassignment != null) {
            if (this.tassignment.getType() != TConcretize.INPUT_VAR) {
                if (this.tassignment.getType() == TConcretize.TMOCK) {
                    TService tserv = (TService)this.tassignment.getObject();
                    link.put("type", "tserv");
                    link.put("name", "");
                    link.put("link", "p-r");
                    link.put("comp1", tserv.getSid().getCompVarName());
                    link.put("comp2", this.sid.getCompVarName());
                    link.put("service1", tserv.getSid().getServiceName());
                    link.put("service2", this.sid.getServiceName());
                } else if (this.tassignment.getType() == TConcretize.TSERVICE) {
                    TService tserv = (TService)this.tassignment.getObject();
                    link.put("type", "tserv");
                    link.put("name", "");
                    link.put("link", "p-r");
                    link.put("comp1", tserv.getSid().getCompVarName());
                    link.put("comp2", this.sid.getCompVarName());
                    link.put("service1", tserv.getSid().getServiceName());
                    link.put("service2", this.sid.getServiceName());
                }
            }
        } else {
            System.out.println("** assignment is null");
        }
        return link;
    }

    public JPanel getMockProvPanel() {
        this.isProvider = true;
        this.isMock = true;
        JPanel paramAssignPanel = new JPanel();
        paramAssignPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), String.valueOf(this.sid.getServ().getName()) + " Parameters"));
        paramAssignPanel.setLayout(new GridLayout(0, 3, 10, 10));
        final TService tserv = this;
        final Variable param = new Variable("Result", this.service.getReturnCostoType());
        param.setType(this.service.getReturnCostoType().getName());
        this.servParams.put(param.getName(), null);
        final JButton assignButton = new JButton("unassigned");
        assignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Variable absvar = null;
                absvar = TUtile.selectOutputVariableToAssign(param);
                if (absvar == null) {
                    return;
                }
                if (absvar.getName().startsWith("New Output Variable")) {
                    TUtile.intentionPanel.createNewOutputVariable(absvar);
                }
                TUtile.outputAssignments.remove(absvar.getName());
                if (!absvar.getName().equals("unassigned")) {
                    TService.this.servParams.put(param.getName(), absvar);
                    if (absvar != null && !TUtile.inOutvarsUsed.contains(absvar)) {
                        TUtile.inOutvarsUsed.add(absvar);
                    }
                } else {
                    TService.this.servParams.put(param.getName(), null);
                }
                TService.this.result = absvar;
                TUtile.outputAssignments.put(absvar.getName(), tserv);
                System.out.println("RS is sett from " + TService.this.result);
                TUtile.intentionPanel.assignOutputParameter(absvar, param, TService.this.sid, 0);
                assignButton.setText(absvar.getName());
                TUtile.evaluateStateAssigments();
            }
        });
        paramAssignPanel.add(assignButton);
        paramAssignPanel.add(new JLabel(param.toString()));
        paramAssignPanel.add(new JLabel(""));
        return paramAssignPanel;
    }

    public void setSid(ServiceIdentifier sid) {
        this.sid = sid;
    }

    public void setSut() {
        this.isSut = true;
    }

    public boolean isSut() {
        return this.isSut;
    }

    public boolean isProvider() {
        return this.isProvider;
    }

    public void settOwner(ITComponent tOwner) {
        this.tOwner = tOwner;
    }

    public ITComponent getTOwner() {
        return this.tOwner;
    }

    public Variable getVarAssigned() {
        return this.varAssigned;
    }

    public void setVarAssigned(Variable varAssigned) {
        this.varAssigned = varAssigned;
    }

    public Map<String, Variable> getServParams() {
        return this.servParams;
    }

    public void setServParams(Map<String, Variable> servParams) {
        this.servParams = servParams;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Variable getResult() {
        return this.result;
    }

    public void setResult(Variable result) {
        this.result = result;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public ServiceIdentifier getSid() {
        return this.sid;
    }

    public boolean isMock() {
        return this.isMock;
    }

    public void setMock(boolean isMock) {
        this.isMock = isMock;
    }
}

