/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.utils;

import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.Service;
import costo.graph.ServiceIdentifier;
import costolib_plugin_kml_test.utils.JCompServSelector;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class JCompositeServSelector
extends JPanel {
    ArrayList<JCompServSelector> subsel = new ArrayList();
    private Component comp;
    private List<ComponentVariable> subcomplist = null;

    public JCompositeServSelector(Component comp) {
        this.comp = comp;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), comp.getName()));
        if (comp.isComposite()) {
            this.subcomplist = comp.getComposition().getAssembly().getNamedComponentsWithoutSelf();
        } else {
            this.subcomplist = new ArrayList<ComponentVariable>();
            this.subcomplist.add(new ComponentVariable("", comp));
        }
        for (ComponentVariable cv : this.subcomplist) {
            JCompServSelector sel = new JCompServSelector(cv);
            this.subsel.add(sel);
            this.add(sel);
        }
    }

    public ArrayList<ServiceIdentifier> getSelected() {
        ArrayList<ServiceIdentifier> slist = new ArrayList<ServiceIdentifier>();
        for (JCompServSelector sel : this.subsel) {
            slist.addAll(sel.getSelected());
        }
        return slist;
    }

    public List<Service> getSelectedServices() {
        ArrayList<Service> slist = new ArrayList<Service>();
        for (ServiceIdentifier serv : this.getSelected()) {
            slist.add(serv.getServ());
        }
        return slist;
    }

    public List<ComponentVariable> getSubcomplist() {
        return this.subcomplist;
    }
}

