/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.utils;

import costo.graph.Component;
import costo.graph.ServiceIdentifier;
import costo.graph.Variable;
import costo.graph.expressions.KmlPredicate;
import costolib_plugin_kml_test.utils.table.AbstractVariableAssignment;
import costolib_plugin_kml_test.utils.table.Concretization;
import costolib_plugin_kml_test.utils.table.InputVarTableModel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class TestIntentionControlPanel
extends JPanel {
    private JTextArea invarlist = new JTextArea(5, 20);
    private JTextArea outvarlist = new JTextArea(5, 20);
    private JTextArea oracle = new JTextArea();
    private JTable invartable;
    InputVarTableModel inputVarTModel;
    private JTable outvartable;
    InputVarTableModel outputVarTModel;
    Component intention;
    private Map<Variable, AbstractVariableAssignment> inputVarsAssignment = new HashMap<Variable, AbstractVariableAssignment>();
    private Map<Variable, AbstractVariableAssignment> outputVarsAssignment = new HashMap<Variable, AbstractVariableAssignment>();
    private List<ServiceIdentifier> suts = new ArrayList<ServiceIdentifier>();
    private Map<String, Map<String, Object>> varsOracle = new HashMap<String, Map<String, Object>>();

    public TestIntentionControlPanel(Component intention) {
        this.setLayout(new FlowLayout());
        this.intention = intention;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Test Intention"));
        ArrayList<AbstractVariableAssignment> invarassign = new ArrayList<AbstractVariableAssignment>();
        for (Variable invar : intention.getVariables().values()) {
            AbstractVariableAssignment assign = new AbstractVariableAssignment(invar);
            invarassign.add(assign);
            this.inputVarsAssignment.put(invar, assign);
        }
        this.inputVarTModel = new InputVarTableModel(invarassign);
        this.invartable = new JTable(this.inputVarTModel);
        JScrollPane invarscrollPane = new JScrollPane(this.invartable);
        invarscrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Variables"));
        invarscrollPane.setPreferredSize(new Dimension(300, 200));
        this.add(invarscrollPane);
        ArrayList<AbstractVariableAssignment> outvarassign = new ArrayList<AbstractVariableAssignment>();
        for (Variable outvar : intention.getConstants().values()) {
            AbstractVariableAssignment assign = new AbstractVariableAssignment(outvar);
            outvarassign.add(assign);
            this.outputVarsAssignment.put(outvar, assign);
        }
        this.outputVarTModel = new InputVarTableModel(outvarassign);
        this.outvartable = new JTable(this.outputVarTModel);
        JScrollPane outvarscrollPane = new JScrollPane(this.outvartable);
        outvarscrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Variables"));
        outvarscrollPane.setPreferredSize(new Dimension(300, 200));
        this.add(outvarscrollPane);
        this.oracle.setText(intention.getProperties().values().toString());
        JPanel oraclePanel = new JPanel();
        oraclePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Oracle Predicate"));
        oraclePanel.add(this.oracle);
        this.add(oraclePanel);
        for (KmlPredicate pred : this.intention.getProperties().values()) {
            System.out.println("1 :" + pred);
            System.out.println("2 :" + pred.getRawValue());
            System.out.println("3 :" + pred.getExpression());
            System.out.println("4 :" + pred.getUniversals());
            System.out.println("5 :" + pred.getExpression().getCommunicationAction());
        }
    }

    private void updateIntent() {
        this.invarlist.setText(this.intention.getVariables().values().toString());
        this.invarlist.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Variables"));
        this.outvarlist.setText(this.intention.getConstants().values().toString());
        this.outvarlist.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Variables"));
        this.oracle.setText(this.intention.getProperties().values().toString());
        this.oracle.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Oracle"));
    }

    public void assignStateVarOld(Variable absvar, Variable var) {
        AbstractVariableAssignment assign = this.inputVarsAssignment.get(absvar);
        if (var.getName().equals("unassigned")) {
            assign.setConcretetype(Concretization.NONE);
            assign.setControlled(false);
        } else if (!var.equals((Object)assign.getStatevar())) {
            assign.setStatevar(var);
            assign.setControlled(false);
            assign.setConcretetype(Concretization.STATEVAR);
        }
        this.inputVarTModel.fireTableDataChanged();
    }

    public void assignStateVar(Variable absvar, Variable param, ServiceIdentifier sid) {
        AbstractVariableAssignment assign = this.inputVarsAssignment.get(absvar);
        if (assign == null || absvar.getName().equals("unassigned")) {
            for (Variable var : this.inputVarsAssignment.keySet()) {
                AbstractVariableAssignment abstAss = this.inputVarsAssignment.get(var);
                if (!var.equals((Object)param)) continue;
                abstAss.removeAssignment(param);
                break;
            }
        } else if (!param.equals((Object)assign.getParameter())) {
            this.unAssignInput(param);
            assign.setParameter(param);
            assign.setServiceToCall(sid);
            assign.addAssignment(param, sid);
            assign.setConcretetype(Concretization.PARAMETER);
        }
        this.inputVarTModel.fireTableDataChanged();
    }

    public void assignInputParameter(Variable absvar, Variable param, ServiceIdentifier sid, int position) {
        AbstractVariableAssignment assign = this.inputVarsAssignment.get(absvar);
        if (assign == null || absvar.getName().equals("unassigned")) {
            for (Variable var : this.inputVarsAssignment.keySet()) {
                AbstractVariableAssignment abstAss = this.inputVarsAssignment.get(var);
                if (abstAss.getPosition() != position || abstAss.getServiceToCall() == null || !abstAss.getServiceToCall().equals((Object)sid)) continue;
                abstAss.removeAssignment(param);
                break;
            }
        } else if (!param.equals((Object)assign.getParameter())) {
            this.unAssignInput(param);
            assign.setParameter(param);
            assign.setServiceToCall(sid);
            assign.setPosition(position);
            assign.addAssignment(param, sid);
            assign.setConcretetype(Concretization.PARAMETER);
        }
        this.inputVarTModel.fireTableDataChanged();
    }

    public void assignOutputParameter(Variable absvar, Variable param, ServiceIdentifier sid, int position) {
        AbstractVariableAssignment assign = this.outputVarsAssignment.get(absvar);
        if (assign == null || absvar.getName().equals("unassigned")) {
            for (Variable var : this.outputVarsAssignment.keySet()) {
                AbstractVariableAssignment abstAss = this.outputVarsAssignment.get(var);
                if (abstAss.getPosition() != position || abstAss.getServiceToCall() == null || !abstAss.getServiceToCall().equals((Object)sid)) continue;
                abstAss.removeAssignment(param);
                break;
            }
        } else if (!param.equals((Object)assign.getParameter())) {
            this.unAssignOutput(param);
            assign.setParameter(param);
            assign.setServiceToCall(sid);
            assign.setPosition(position);
            assign.addAssignment(param, sid);
            assign.setConcretetype(Concretization.STATEVAR);
        }
        this.outputVarTModel.fireTableDataChanged();
    }

    public void unAssignInput(Variable param) {
        for (Variable var : this.inputVarsAssignment.keySet()) {
            AbstractVariableAssignment abstAss = this.inputVarsAssignment.get(var);
            if (!abstAss.getAssignment().containsKey(param)) continue;
            abstAss.removeAssignment(param);
        }
    }

    public void unAssignOutput(Variable param) {
        for (Variable var : this.outputVarsAssignment.keySet()) {
            AbstractVariableAssignment abstAss = this.outputVarsAssignment.get(var);
            if (!abstAss.getAssignment().containsKey(param)) continue;
            abstAss.removeAssignment(param);
        }
    }

    public void assignRequired(Variable absvar, ServiceIdentifier sid) {
        AbstractVariableAssignment assign = this.inputVarsAssignment.get(absvar);
        if (sid != null && !sid.equals((Object)assign.getServiceToCall())) {
            assign.setControlled(true);
            assign.setServiceToCall(sid);
            assign.setConcretetype(Concretization.REQUIRED);
        }
        this.inputVarTModel.fireTableDataChanged();
    }

    public void assignRequiredLink(Variable absvar, ServiceIdentifier sid) {
        if (absvar == null) {
            return;
        }
        AbstractVariableAssignment assign = this.inputVarsAssignment.get(absvar);
        assign.setProviderService(sid);
        if (sid == null) {
            assign.setControlled(false);
        } else {
            assign.setControlled(true);
        }
        this.inputVarTModel.fireTableDataChanged();
    }

    public JPanel getOraclePanel() {
        String[] prop_list;
        JPanel oraclePanel = new JPanel();
        oraclePanel.setLayout(new GridLayout(0, 3, 10, 10));
        oraclePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Oracle(s) assignment"));
        String[] operators = new String[]{"=", "<>", ">", ">=", "<", "<="};
        String properties = this.intention.getProperties().values().toString();
        properties = properties.replace("[", "");
        properties = properties.replace("]", "");
        properties.trim();
        String[] stringArray = prop_list = properties.split(" and ");
        int n = prop_list.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            String rawVal = prop = prop.trim();
            String initVal = "";
            String operator = "";
            int i = 0;
            while (i < operators.length) {
                String op = operators[i];
                if (rawVal.contains(op)) {
                    operator = op;
                    String[] liste = rawVal.split(op);
                    rawVal = liste[0];
                    if (liste.length >= 2) {
                        initVal = liste[1];
                    }
                }
                ++i;
            }
            final String oracleName = rawVal = rawVal.trim();
            if (oracleName != null && !oracleName.isEmpty()) {
                Variable correspVar = null;
                for (Variable invar : this.intention.getVariables().values()) {
                    if (invar.getName().equals(oracleName)) {
                        // empty if block
                    }
                    correspVar = invar;
                }
                if (correspVar == null) {
                    for (Variable outvar : this.intention.getConstants().values()) {
                        if (outvar.getName().equals(oracleName)) {
                            // empty if block
                        }
                        correspVar = outvar;
                    }
                }
                final JButton assignButton = new JButton("unassigned");
                assignButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ServiceIdentifier abServ = TestIntentionControlPanel.this.selectVariableToAssign(oracleName);
                        if (abServ == null) {
                            return;
                        }
                        assignButton.setText(abServ.toString());
                        Map val = (Map)TestIntentionControlPanel.this.varsOracle.get(oracleName);
                        val.put("service", abServ);
                        TestIntentionControlPanel.this.varsOracle.put(oracleName, val);
                    }
                });
                oraclePanel.add(assignButton);
                oraclePanel.add(new JLabel(prop));
                oraclePanel.add(new JLabel(""));
                Map<String, Object> val = this.varsOracle.get(oracleName);
                if (val == null) {
                    val = new HashMap<String, Object>();
                }
                val.put("operator", operator);
                val.put("value", initVal);
                val.put("type", correspVar.getType());
                val.put("service", null);
                this.varsOracle.put(oracleName, val);
            }
            ++n2;
        }
        return oraclePanel;
    }

    public ServiceIdentifier selectVariableToAssign(String target) {
        if (this.suts == null || this.suts.isEmpty()) {
            System.out.println("no srvices");
        }
        if (this.intention == null || this.suts == null || this.suts.isEmpty()) {
            return null;
        }
        Object[] tablo = new ServiceIdentifier[this.suts.size()];
        tablo = this.suts.toArray(tablo);
        ServiceIdentifier serv = (ServiceIdentifier)JOptionPane.showInputDialog(this, "Select the service to assign to " + target, "Assign to " + target, -1, null, tablo, tablo[0]);
        return serv;
    }

    public void setSuts(List<ServiceIdentifier> suts) {
        this.suts.addAll(suts);
    }

    public Map<String, Map<String, Object>> getVarsOracle() {
        return this.varsOracle;
    }

    public void createNewInputVariable(Variable variable) {
        if (this.inputVarsAssignment.containsKey(variable)) {
            return;
        }
        String result = "";
        while (result == "") {
            result = JOptionPane.showInputDialog(null, (Object)"Enter new variable name:");
            for (Variable invar : this.intention.getVariables().values()) {
                if (!invar.getName().equals(result)) continue;
                result = "";
            }
        }
        variable.setName(result);
        AbstractVariableAssignment assign = new AbstractVariableAssignment(variable);
        this.inputVarsAssignment.put(variable, assign);
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        variables.putAll(this.intention.getVariables());
        variables.put(variable.getName(), variable);
        this.intention.setVariables(variables);
        ArrayList<AbstractVariableAssignment> invarassign = new ArrayList<AbstractVariableAssignment>();
        invarassign.addAll(this.inputVarsAssignment.values());
        this.inputVarTModel = new InputVarTableModel(invarassign);
        this.invartable.setModel(this.inputVarTModel);
        this.inputVarTModel.fireTableDataChanged();
    }

    public void createNewOutputVariable(Variable variable) {
        if (this.outputVarsAssignment.containsKey(variable)) {
            return;
        }
        String result = "";
        while (result == "") {
            result = JOptionPane.showInputDialog(null, (Object)"Enter new output variable name:");
            for (Variable invar : this.intention.getConstants().values()) {
                if (!invar.getName().equals(result)) continue;
                result = "";
            }
        }
        variable.setName(result);
        AbstractVariableAssignment assign = new AbstractVariableAssignment(variable);
        this.outputVarsAssignment.put(variable, assign);
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        variables.putAll(this.intention.getConstants());
        variables.put(variable.getName(), variable);
        this.intention.setConstants(variables);
        ArrayList<AbstractVariableAssignment> invarassign = new ArrayList<AbstractVariableAssignment>();
        invarassign.addAll(this.outputVarsAssignment.values());
        this.outputVarTModel = new InputVarTableModel(invarassign);
        this.outvartable.setModel(this.outputVarTModel);
        this.outputVarTModel.fireTableDataChanged();
    }

    public Map<Variable, AbstractVariableAssignment> getInputVarsAssignment() {
        return this.inputVarsAssignment;
    }

    public Map<Variable, AbstractVariableAssignment> getOutputVarsAssignment() {
        return this.outputVarsAssignment;
    }
}

