/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.utils;

import costo.graph.ComponentFactory;
import costo.graph.Variable;
import costo.graph.expressions.KmlExpression;
import costolib_plugin_kml_test.testconfig.TestIntention;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class TestIntentionPanel
extends JPanel {
    private TestIntention intent = new TestIntention();
    private JTextField name;
    private JTextPane descr;
    private JTextPane vars;
    private JTextPane oracle;
    private ComponentFactory f = new ComponentFactory();

    public TestIntentionPanel() {
        this.f.loadCostolib();
        this.setLayout(new BorderLayout());
        this.name = new JTextField(null, 30);
        this.name.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Intention Name"));
        this.add((Component)this.name, "North");
        this.descr = new JTextPane();
        this.descr.setText("Insert Description");
        this.descr.setPreferredSize(new Dimension(100, 100));
        this.descr.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Description"));
        this.add((Component)this.descr, "West");
        this.vars = new JTextPane();
        this.vars.setPreferredSize(new Dimension(100, 100));
        this.vars.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Variables"));
        this.add((Component)this.vars, "Center");
        JButton testExpr = new JButton("validate");
        testExpr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestIntentionPanel.this.descr.setText(String.valueOf(TestIntentionPanel.this.getInputData().values().toString()) + " " + TestIntentionPanel.this.getOracle().toString());
            }
        });
        this.add((Component)testExpr, "East");
        this.oracle = new JTextPane();
        this.oracle.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Oracle"));
        this.add((Component)this.oracle, "South");
    }

    public TestIntention getIntent() {
        this.intent.setName(this.name.getText());
        this.intent.setDescription(this.descr.getText());
        this.intent.setAbstrinputdata(this.getInputData());
        this.intent.setOracle(this.getOracle());
        return this.intent;
    }

    private KmlExpression getOracle() {
        KmlExpression expr = null;
        try {
            expr = this.f.loadExpression(this.oracle.getText());
        }
        catch (Exception exception) {}
        return expr;
    }

    private Map<String, Variable> getInputData() {
        HashMap<String, Variable> varmap = new HashMap<String, Variable>();
        try {
            ArrayList kmlvars = this.f.loadVarDecls(this.vars.getText());
            for (Variable v : kmlvars) {
                varmap.put(v.getName(), v);
                System.out.println(v);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return varmap;
    }

    public void setIntent(TestIntention intent) {
        this.intent = intent;
    }
}

