/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_tdata;

import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.ComponentVariable;
import costo.graph.CostoLibrary;
import costo.graph.KmlElement;
import costolib.ui.interfaces.IComponentActor;
import costolib_plugin_kml2java.Kml2JavaComponentActor1;
import costolib_plugin_tdata.mut.MutantCreator;
import costolib_plugin_tdata.mut.Utile;
import costolib_plugin_tdata.utils.FrameTestData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class MutationAnalysis
implements IComponentActor {
    public boolean isApplicableFor(KmlElement currentSelection) {
        return false;
    }

    public void doSomethingWithComponent(Component comp, KmlElement currentSelection, String relativePath) {
        this.copyFoldersAndFiles(comp);
        this.getValuesVariables(comp);
        MutantCreator mutation = new MutantCreator(comp);
        boolean jarsLoaded = false;
        if (!mutation.isOk()) {
            return;
        }
        int nbMut = 0;
        while (mutation.generateNewMutant()) {
            System.out.println("MUTANT:" + ++nbMut);
            if (!mutation.isOk()) continue;
            Component mutComp = this.getComponentTHInDir(comp, mutation.getMutantDir());
            String relativMutPath = relativePath.replace(comp.getName(), "mutants/Mutant" + mutation.getMutantId() + "/" + comp.getName());
            Kml2JavaComponentActor1 kml2Java = new Kml2JavaComponentActor1();
            kml2Java.doSomethingWithComponent(mutComp, (KmlElement)mutComp, relativMutPath);
            String packageName = kml2Java.getExportPackage();
            String dir = kml2Java.getSourceDir();
            System.out.println("MUT-packageName: " + packageName);
            if (!jarsLoaded) {
                mutation.loadSpecificsJars(dir);
                if (!mutation.isOk()) {
                    return;
                }
                jarsLoaded = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            mutation.launchMutant(dir, packageName);
        }
    }

    private void getValuesVariables(Component component) {
        HashMap<String, String> map = new HashMap<String, String>();
        FrameTestData.pathDir = component.getFactory().getAbsSpecDir();
        String path = String.valueOf(FrameTestData.pathDir) + File.separator + "data" + File.separator + component.getName() + ".properties";
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(new File(path)));
            for (Object key : prop.keySet()) {
                map.put((String)key, prop.getProperty((String)key));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyFoldersAndFiles(Component compTH) {
        String baseDir = compTH.getFactory().getAbsSpecDir();
        for (CostoLibrary lib : compTH.getLibraries()) {
            String libName = lib.getName();
            String pathLib = String.valueOf(baseDir) + File.separator + (String)libName;
            File dirLib = new File(pathLib);
            if (!dirLib.isDirectory()) continue;
            try {
                File destDir = new File(String.valueOf(baseDir) + File.separator + "original" + File.separator + (String)libName);
                if (!destDir.isDirectory()) {
                    destDir.mkdirs();
                }
                Utile.copyFolder(dirLib, destDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList subcomplist = compTH.getComposition().getAssembly().getNamedComponentsWithoutSelf();
        for (ComponentVariable compVar : subcomplist) {
            String pathCompfile = String.valueOf(baseDir) + File.separator + compVar.getComponentType().getName() + ".kcp";
            File cmpFile = new File(pathCompfile);
            File dstFile = new File(String.valueOf(baseDir) + File.separator + "original" + File.separator + compVar.getComponentType().getName() + ".kcp");
            if (cmpFile.isFile() && !dstFile.exists()) {
                try {
                    Utile.copyFolder(cmpFile, dstFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println(cmpFile + " is not a file");
        }
        String pathCompfile = String.valueOf(baseDir) + File.separator + compTH.getName() + ".kcp";
        File cmpFile = new File(pathCompfile);
        File dstFile = new File(String.valueOf(baseDir) + File.separator + "original" + File.separator + compTH.getName() + ".kcp");
        if (cmpFile.isFile() && !dstFile.exists()) {
            try {
                Utile.copyFolder(cmpFile, dstFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Component getComponentTHInDir(Component compTH, String path) {
        ComponentFactory cf = new ComponentFactory("mafactory", path);
        for (CostoLibrary lib : compTH.getLibraries()) {
            cf.loadDefaultLibrary(String.valueOf(path) + File.separator + lib.getName());
        }
        Component comp = compTH;
        comp.setFilePath(String.valueOf(path) + File.separator + compTH.getName() + ".kcp");
        return comp;
    }
}

