/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_tdata.utils;

import costolib_plugin_tdata.utils.FrameTestData;
import costolib_plugin_tdata.utils.ModeChoiceFrame;
import costolib_plugin_tdata.utils.XmlBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class EditorFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon image = new ImageIcon("images/site.png");
    public JEditorPane jeditor;
    public String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "img" + File.separator;
    private Map<String, String> map = new HashMap<String, String>();
    StringBuilder top = new StringBuilder();

    public EditorFrame(Map<String, String> map) {
        this.map = map;
        this.setTitle("Test Datas Building");
        this.setDefaultCloseOperation(2);
        this.setSize(1000, 400);
        this.init();
        this.setVisible(true);
    }

    public EditorFrame() {
    }

    private void init() {
        JButton prev = new JButton("Back");
        prev.setActionCommand("preview");
        prev.addActionListener(this);
        JTextPane topan = new JTextPane();
        topan.setOpaque(true);
        StyledDocument doc0 = topan.getStyledDocument();
        SimpleAttributeSet center0 = new SimpleAttributeSet();
        StyleConstants.setAlignment(center0, 0);
        doc0.setParagraphAttributes(0, 0, center0, true);
        for (String key : this.map.keySet()) {
            String title = key + ":" + this.map.get(key);
            this.top.append(String.valueOf(title) + "; ");
        }
        topan.setText("#" + this.top + "\n");
        topan.setFont(new Font("Serif", 1, 24));
        topan.setBackground(Color.white);
        topan.setEditable(false);
        JTextPane lbl = new JTextPane();
        lbl.setOpaque(true);
        StyledDocument doc = lbl.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, 0, center, true);
        lbl.setText("*****Warning***** \n TestData Building \n Each value must be separated with \";\" ");
        lbl.setFont(new Font("Serif", 1, 24));
        lbl.setBackground(Color.ORANGE);
        lbl.setEditable(false);
        JPanel nonEdit = new JPanel(new BorderLayout());
        nonEdit.setEnabled(true);
        nonEdit.add((Component)lbl, "North");
        nonEdit.add((Component)topan, "South");
        this.getContentPane().add((Component)nonEdit, "North");
        JToolBar toolBar = new JToolBar();
        JButton valid = new JButton("Submit");
        valid.setActionCommand("process");
        valid.addActionListener(this);
        JButton reset = new JButton("Cancel");
        reset.setActionCommand("reset");
        reset.addActionListener(this);
        toolBar.setLayout(new FlowLayout());
        toolBar.add(reset);
        toolBar.add(prev);
        toolBar.add(valid);
        this.setPreferredSize(new Dimension(500, 300));
        this.getContentPane().add((Component)toolBar, "South");
        this.jeditor = new JEditorPane();
        this.jeditor.setContentType("text/plain");
        this.getContentPane().add((Component)new JScrollPane(this.jeditor), "Center");
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("preview".equals(e.getActionCommand())) {
            this.dispose();
            new ModeChoiceFrame(this.map);
        }
        if ("reset".equals(e.getActionCommand())) {
            this.jeditor.setText("");
            return;
        }
        if ("process".equals(e.getActionCommand())) {
            String source = this.jeditor.getText();
            Scanner scanner = new Scanner(source);
            ArrayList<List<Map<String, String>>> allcases = new ArrayList<List<Map<String, String>>>();
            boolean control = true;
            while (scanner.hasNextLine()) {
                ArrayList sCase = new ArrayList();
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                String[] str = line.split(";");
                if (str.length != this.map.size()) {
                    JOptionPane.showMessageDialog(null, "Warning : Some values are missing or data building structure is wrong \n Please complete missing data or respect \";\" separator");
                    return;
                }
                int i = 0;
                while (i < str.length) {
                    HashMap<String, String> var = new HashMap<String, String>();
                    try {
                        String key = (String)this.map.keySet().toArray()[i];
                        String value = str[i];
                        String name = key.toString();
                        String[] str2 = name.split(":");
                        var.put("name", str2[0]);
                        var.put("value", value);
                        sCase.add(var);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Somme of cell are empty");
                    }
                    ++i;
                }
                allcases.add(sCase);
            }
            if (!control || allcases.size() == 0) {
                JOptionPane.showMessageDialog(null, "Warning : Some field are empty, Please complete them before processing");
            } else {
                new XmlBuilder(allcases, FrameTestData.pathDir);
                JOptionPane jop = new JOptionPane("Process complete successfully", 1);
                final JDialog dia = jop.createDialog("Information");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1500L);
                            dia.dispose();
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                        }
                    }
                }).start();
                dia.setVisible(true);
            }
        }
    }
}

