/*
 * Decompiled with CFR 0.152.
 */
package costo.kml2java.export;

import costo.graph.Component;
import costo.kml2java.export.ComponentJavaContextCreatorVisitor;
import costolib_plugin_kml2java.Activator;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public class ComponentToJava {
    private boolean consoleOutput = false;
    private TemplateLoader loader = Activator.getDefault().getTemplateLoader();
    private Configuration config;
    private String currentDir = "";
    private String srcdir = "";
    private Component component;

    public ComponentToJava(Component component) {
        this.component = component;
        this.config = new Configuration();
        this.config.setTemplateLoader(this.loader);
    }

    public void setCurrentDir(String currentDir) {
        this.currentDir = currentDir;
        File f = new File(currentDir);
        f.mkdirs();
    }

    public void exportComponent(ComponentJavaContextCreatorVisitor visitor) {
        for (SimpleHash compHash : visitor.getComponentClassRoots()) {
            this.generate(compHash, "componenttemplate.ftl");
            try {
                if (((TemplateBooleanModel)compHash.get("appli")).getAsBoolean()) {
                    this.generate(compHash, "applilaunchtemplate.ftl", "APPLICATION_");
                    if (Activator.getDefault().getPreferenceStore().getBoolean("generateGUIMonitor")) {
                        this.generate(compHash, "guiapplilaunchtemplate.ftl", "MONITORED_APPLICATION_");
                    }
                }
                if (!((TemplateBooleanModel)compHash.get("appliTest")).getAsBoolean()) continue;
                ArrayList<String> imports = new ArrayList<String>();
                imports.add("costo.kml2java.framework.test.ServiceEvolutionValidator");
                SimpleHash lunHash = new SimpleHash();
                String xml_path = String.valueOf(this.component.getFactory().getAbsSpecDir()) + "/data/data.xml";
                String package_lib = "mylib";
                lunHash.put("xml_path", (Object)xml_path);
                lunHash.put("package_lib", (Object)package_lib);
                lunHash.put("package", (Object)compHash.get("package"));
                lunHash.put("imports", imports);
                lunHash.put("name", (Object)("Launcher" + compHash.get("name")));
                lunHash.put("class_lib", (Object)"PlatoonTestlibMap");
                lunHash.put("component_class_name", (Object)compHash.get("name"));
                this.generate(lunHash, "comp_tests_launcher.ftl");
                System.out.println("GENERATING MUTANT FILE");
                lunHash.put("name", (Object)("Mutation" + compHash.get("name")));
                this.generate(lunHash, "mutant_tests_launcher.ftl");
                this.generateTestLibMapClass(compHash);
                this.generateLibMapClass(compHash);
            }
            catch (TemplateModelException e) {
                e.printStackTrace();
            }
        }
        for (SimpleHash libHash : visitor.getLibClassRoots()) {
            this.generate(libHash, "typetemplate.ftl");
        }
        for (SimpleHash servHash : visitor.getServicesClassRoots()) {
            this.generate(servHash, "servicetemplate.ftl");
        }
        for (SimpleHash servHash : visitor.getPromotedServicesClassRoots()) {
            this.generate(servHash, "promotedservicetemplate.ftl");
        }
        for (SimpleHash ltsHash : visitor.getLtsClassRoots()) {
            this.generate(ltsHash, "ltstemplate.ftl");
        }
        for (SimpleHash structHash : visitor.getStructClassRoots()) {
            this.generate(structHash, "typetemplate.ftl");
        }
        for (SimpleHash enumHash : visitor.getEnumClassRoots()) {
            this.generate(enumHash, "enumtemplate.ftl");
        }
    }

    private void generate(SimpleHash compHash, String templatename) {
        this.generate(compHash, templatename, "");
    }

    private void generate(SimpleHash structHash, String templatename, String prefix) {
        try {
            Template tempmodel = this.config.getTemplate(templatename);
            OutputStreamWriter out = this.consoleOutput ? new OutputStreamWriter(System.out) : this.getWriter(String.valueOf(prefix) + structHash.get("name").toString());
            tempmodel.process((Object)structHash, (Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    private Writer getWriter(String string) throws IOException {
        return new FileWriter(String.valueOf(this.currentDir) + File.separator + string + ".java");
    }

    public void generateTestLibMapClass(SimpleHash compHash) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("costo.kml2java.framework.IProvidedService");
        SimpleHash libMapHash = new SimpleHash();
        try {
            libMapHash.put("package", (Object)"mylib");
            libMapHash.put("imports", imports);
            libMapHash.put("name", (Object)"PlatoonTestlibMap");
            String curdir = this.currentDir;
            this.currentDir = String.valueOf(this.srcdir) + File.separator + "mylib";
            File dir = new File(this.currentDir);
            if (!dir.isDirectory() && !dir.mkdir()) {
                return;
            }
            this.generate(libMapHash, "comp_test_lib_map.ftl");
            this.currentDir = curdir;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateLibMapClass(SimpleHash compHash) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("costo.kml2java.framework.IProvidedService");
        SimpleHash libMapHash = new SimpleHash();
        try {
            libMapHash.put("package", (Object)"mylib");
            libMapHash.put("imports", imports);
            libMapHash.put("name", (Object)"PlatoonlibMap");
            String curdir = this.currentDir;
            this.currentDir = String.valueOf(this.srcdir) + File.separator + "mylib";
            File dir = new File(this.currentDir);
            if (!dir.isDirectory() && !dir.mkdir()) {
                return;
            }
            this.generate(libMapHash, "comp_lib_map.ftl");
            this.currentDir = curdir;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSrcdir(String srcdir) {
        this.srcdir = srcdir;
    }
}

