/*
 * Decompiled with CFR 0.152.
 */
package costo.kml2java.export;

import costo.kml2java.export.SimpleReplacement;

public class OperatorToMethodCall
extends SimpleReplacement {
    private boolean reverse2args = false;

    public OperatorToMethodCall(String newname, boolean reverse2args) {
        super(newname);
        this.reverse2args = reverse2args;
    }

    public OperatorToMethodCall(String newname) {
        super(newname);
    }

    @Override
    public String generateFromBinOP(String left, String right) {
        if (left == null) {
            left = "";
        }
        if (this.reverse2args) {
            return this.generateFromBinOPOrdered(right, left);
        }
        return this.generateFromBinOPOrdered(left, right);
    }

    private String generateFromBinOPOrdered(String left, String right) {
        StringBuilder temp = new StringBuilder();
        temp.append(left);
        temp.append(".");
        temp.append(this.getNewname());
        temp.append("(");
        temp.append(right);
        temp.append(")");
        return temp.toString();
    }

    @Override
    public String generateFromFunCall(String[] args) {
        if (this.reverse2args && args.length > 1) {
            String temp = args[0];
            args[0] = args[1];
            args[1] = temp;
        }
        return this.generateFromFunCallSep(args);
    }

    private String generateFromFunCallSep(String[] args) {
        StringBuilder theargs = new StringBuilder(args[0]);
        theargs.append(".");
        theargs.append(this.getNewname());
        theargs.append("(");
        if (args.length > 1) {
            int i = 1;
            while (i < args.length) {
                theargs.append(args[i]);
                theargs.append(",");
                ++i;
            }
            theargs.deleteCharAt(theargs.length() - 1);
        }
        theargs.append(")");
        return theargs.toString();
    }
}

