/*
 * Decompiled with CFR 0.152.
 */
package mec;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import mec.grammar.AnalyserLexMec;
import mec.grammar.AnalyserSynMec;
import mec.graph.MecRes;

public class MecLoader {
    public static MecRes loadMecRes(String spec_abs_path, String mec_res_name) throws FileNotFoundException, RecognitionException, TokenStreamException {
        MecRes mec_res = null;
        System.out.println("The file is " + spec_abs_path + mec_res_name);
        FileReader file = new FileReader(String.valueOf(spec_abs_path) + mec_res_name);
        AnalyserLexMec lexer = new AnalyserLexMec(file);
        AnalyserSynMec parser = new AnalyserSynMec(lexer);
        System.setProperty("mec.absspecdir", spec_abs_path);
        mec_res = parser.mec_result();
        mec_res.setFileName(String.valueOf(spec_abs_path) + mec_res_name);
        mec_res.computeMarkup();
        return mec_res;
    }

    public static MecRes loadMecRes() throws FileNotFoundException, RecognitionException, TokenStreamException, IOException {
        String[] nothing = null;
        return MecLoader.loadMecRes(nothing);
    }

    public static MecRes loadMecRes(String[] args) throws FileNotFoundException, RecognitionException, TokenStreamException, IOException {
        String specdir = "";
        String mec_res_name = "";
        String basedir = "";
        if (args == null || args.length < 3) {
            try {
                Properties userprop = new Properties();
                userprop.load(new FileInputStream("MecRes.userprefs"));
                String archi = userprop.getProperty("mec.archi");
                basedir = archi.equals("windows") ? String.valueOf(userprop.getProperty("mec.Winbasedir")) + userprop.getProperty("mec.user") + "/workspace/" : (archi.equals("linux") ? String.valueOf(userprop.getProperty("mec.Linbasedir")) + userprop.getProperty("mec.user") + "/workspace/" : userprop.getProperty("mec.basedir"));
                specdir = userprop.getProperty("mec.specdir");
                if (mec_res_name == null || mec_res_name.equals("")) {
                    mec_res_name = userprop.getProperty("mec.sts");
                }
            }
            catch (Exception exception) {
                System.err.println("Preference file MecRes.userprefs not found");
                System.err.println("Please create this file or give relative specification path then component name as parameters");
            }
        }
        if (args.length > 0) {
            specdir = args[0];
        }
        if (args.length > 1) {
            mec_res_name = args[1];
        }
        if (args.length > 2) {
            basedir = args[2];
        }
        System.out.println("\nThe base dir is " + basedir);
        System.out.println("The spec dir is " + specdir);
        System.out.println("The main sts is " + mec_res_name);
        return MecLoader.loadMecRes(String.valueOf(basedir) + specdir, mec_res_name);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        try {
            MecRes mec_res = MecLoader.loadMecRes(args);
            System.out.println("---------------------------\n MecRes contents : \n");
            System.out.println(mec_res.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

