/*
 * Decompiled with CFR 0.152.
 */
package mec.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import mec.graph.FSMLabel;
import mec.graph.FSMTransition;

public class FSMState {
    private String id;
    private LinkedList<FSMTransition> outGoingFSMTransitions;
    private LinkedList<FSMTransition> inComingFSMTransitions;
    private ArrayList<FSMLabel> labels;
    private boolean marque;

    public FSMState() {
        this.setId("");
        this.outGoingFSMTransitions = new LinkedList();
        this.marque = false;
    }

    public FSMState(String id) {
        this.setId(id);
        this.outGoingFSMTransitions = new LinkedList();
        this.marque = false;
    }

    public String toString() {
        String s = this.id;
        if (this.labels == null) {
            return s;
        }
        for (FSMLabel l : this.labels) {
            s = String.valueOf(s) + "<" + l + ">";
        }
        return s;
    }

    public void addOutGoingFSMTransition(FSMTransition as) {
        this.outGoingFSMTransitions.add(as);
    }

    public int getOutGoingDegree() {
        return this.outGoingFSMTransitions.size();
    }

    public Iterator<FSMTransition> iteratorOnOutGoingFSMTransitions() {
        return this.outGoingFSMTransitions.iterator();
    }

    public LinkedList<FSMTransition> getOutGoingFSMTransitions() {
        return this.outGoingFSMTransitions;
    }

    public void addService(FSMLabel s) {
        this.labels.add(s);
    }

    public ArrayList<FSMLabel> getlabels() {
        return this.labels;
    }

    public FSMLabel getService(int i) {
        return this.labels.get(i);
    }

    public void setService(ArrayList<FSMLabel> al) {
        this.labels = new ArrayList();
        int i = 0;
        while (i < al.size()) {
            this.labels.add(al.get(i));
            ++i;
        }
    }

    public void updatelabels(FSMState n) {
        if (!this.id.equals(n.getId())) {
            return;
        }
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        if (n.getlabels() != null) {
            for (FSMLabel lab : n.getlabels()) {
                if (this.labels.contains(lab)) continue;
                this.labels.add(lab);
            }
        }
        if (n.getOutGoingFSMTransitions() != null) {
            for (FSMTransition arc : n.getOutGoingFSMTransitions()) {
                if (this.outGoingFSMTransitions.contains(arc)) continue;
                this.outGoingFSMTransitions.add(arc);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getMarque() {
        return this.marque;
    }

    public void setMarque(boolean marque) {
        this.marque = marque;
    }

    public LinkedList<FSMTransition> getInComingFSMTransitions() {
        return this.inComingFSMTransitions;
    }

    public void setInComingFSMTransitions(LinkedList<FSMTransition> inComingFSMTransitions) {
        this.inComingFSMTransitions = inComingFSMTransitions;
    }

    public void addInComingFSMTransition(FSMTransition temp) {
        this.inComingFSMTransitions.add(temp);
    }
}

