/*
 * Decompiled with CFR 0.152.
 */
package kml2latex;

import costo.graph.Component;
import java.util.Date;
import java.util.Properties;
import utils.LatexUtils;

public class LatexContext {
    boolean valid;
    Level grain;
    Boolean isMain;
    Component component;
    String name;
    String author;
    String specdir;
    String basedir;
    String latexdir;
    String outputdir;
    String figoutputdir;
    String filPath;
    String datespec;
    Properties kml2latexProp;

    public LatexContext(Component component, Boolean isMain, String latexdir, String outputdir, String figoutputdir, Properties kml2latexProp) {
        this.isMain = isMain;
        this.valid = true;
        this.grain = Level.component;
        this.component = component;
        this.setDir(component.getFilePath(), latexdir, outputdir, figoutputdir);
        this.datespec = new Date().toString();
        this.name = LatexUtils.LatexFilter(this.component.getName());
        this.filPath = component.getFilePath();
        this.author = "AeLoS - Coloss";
        this.kml2latexProp = kml2latexProp;
    }

    public LatexContext() {
        this.valid = false;
    }

    public LatexContext(Component component, Boolean isMain, LatexContext mainlc) {
        this(component, isMain, mainlc.getLatexdir(), mainlc.getOutputdir(), mainlc.getFigoutputdir(), mainlc.getKml2latexProp());
        if (isMain.booleanValue()) {
            this.valid = false;
        }
    }

    public String getOutputdir() {
        return this.outputdir;
    }

    public String getFigoutputdir() {
        return this.figoutputdir;
    }

    public void setDir(String basedir, String latexdir, String outputdir, String figoutputdir) {
        this.basedir = basedir;
        this.latexdir = latexdir;
        this.outputdir = outputdir;
        this.figoutputdir = figoutputdir;
    }

    public Boolean isMain() {
        return this.isMain;
    }

    public String getDatespec() {
        return this.datespec;
    }

    public String getAuthor() {
        return this.author;
    }

    public Component getComponent() {
        return this.component;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String getLatexdir() {
        return this.latexdir;
    }

    public String getName() {
        return this.name;
    }

    public Properties getKml2latexProp() {
        return this.kml2latexProp;
    }

    public String toString() {
        String s;
        if (this.valid) {
            s = this.isMain != false ? "Main " : "Sub";
            s = String.valueOf(s) + this.grain.toString();
            s = String.valueOf(s) + this.component.getName() + "\n";
            s = String.valueOf(s) + "Dirs : B-" + this.getBasedir() + " L-" + this.getLatexdir() + " O-" + this.getOutputdir() + " OF-" + this.getFigoutputdir();
        } else {
            s = "Context not valid";
        }
        return s;
    }

    public static enum Level {
        composite,
        component,
        service;

    }
}

