/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_tdata.utils;

import costolib_plugin_tdata.utils.FrameTestData;
import costolib_plugin_tdata.utils.ModeChoiceFrame;
import costolib_plugin_tdata.utils.XmlBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;

public class TableFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Map<String, String> map = new HashMap<String, String>();
    JTable table;
    DefaultTableModel tableur;
    ImageIcon image = new ImageIcon("images/site.png");

    public TableFrame(int numRow, Map<String, String> map) {
        this.map = map;
        this.setSize(1000, 400);
        this.setTitle("Test Datas Building");
        this.setIconImage(this.image.getImage());
        this.setDefaultCloseOperation(2);
        this.init(numRow);
        this.setVisible(true);
    }

    private void init(int numRow) {
        this.tableur = new DefaultTableModel();
        for (String key : this.map.keySet()) {
            String title = String.valueOf(key) + ": " + this.map.get(key);
            this.tableur.addColumn(title);
            this.tableur.setRowCount(numRow);
            this.table = new JTable(this.tableur);
            this.add((Component)new JScrollPane(this.table), "Center");
            JPanel actions = new JPanel();
            JButton process = new JButton("Submit");
            process.setActionCommand("process");
            process.addActionListener(this);
            JButton cancel = new JButton("Cancel");
            cancel.setActionCommand("cancel");
            cancel.addActionListener(this);
            actions.add(cancel);
            actions.add(process);
            this.getContentPane().add((Component)actions, "South");
            JButton prev = new JButton("Back");
            prev.setActionCommand("preview");
            prev.addActionListener(this);
            JToolBar toolBar = new JToolBar();
            toolBar.add((Component)prev, "West");
            this.getContentPane().add((Component)toolBar, "North");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("preview".equals(e.getActionCommand())) {
            this.dispose();
            new ModeChoiceFrame(this.map);
        } else {
            if ("cancel".equals(e.getActionCommand())) {
                int ligne = 0;
                while (ligne < this.tableur.getRowCount()) {
                    int col = 0;
                    while (col < this.tableur.getColumnCount()) {
                        try {
                            String chaine = (String)this.tableur.getValueAt(ligne, col);
                            if (chaine != null) {
                                this.tableur.setValueAt(null, ligne, col);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Error");
                        }
                        ++col;
                    }
                    ++ligne;
                }
                return;
            }
            if ("process".equals(e.getActionCommand())) {
                boolean control = true;
                ArrayList<List<Map<String, String>>> allcases = new ArrayList<List<Map<String, String>>>();
                int ligne = 0;
                while (ligne < this.tableur.getRowCount()) {
                    ArrayList sCase = new ArrayList();
                    int col = 0;
                    while (col < this.tableur.getColumnCount()) {
                        try {
                            String chaine = (String)this.tableur.getValueAt(ligne, col);
                            if (chaine != null) {
                                HashMap<String, String> var = new HashMap<String, String>();
                                String name = this.tableur.getColumnName(col);
                                String[] str = name.split(":");
                                var.put("name", str[0]);
                                var.put("value", chaine);
                                sCase.add(var);
                            } else {
                                control = false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Somme of cell are empty");
                        }
                        ++col;
                    }
                    allcases.add(sCase);
                    ++ligne;
                }
                if (!control) {
                    JOptionPane.showMessageDialog(null, "Warning : Some field are empty, Please complete them before processing");
                } else {
                    new XmlBuilder(allcases, FrameTestData.pathDir);
                    JOptionPane jop = new JOptionPane("Process complete successfully", 1);
                    final JDialog dia = jop.createDialog("Information");
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1500L);
                                dia.dispose();
                            }
                            catch (Throwable th) {
                                th.printStackTrace();
                            }
                        }
                    }).start();
                    dia.setVisible(true);
                }
            }
        }
    }
}

