/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml2mec;

import costo.graph.Assembly;
import costo.graph.Component;
import costo.graph.Composition;
import costo.graph.KmlElement;
import costo.graph.LTS;
import costo.graph.Link;
import costo.graph.NonExistingLinkException;
import costo.graph.Service;
import costolib.ui.interfaces.IComponentActor;
import costolib_plugin_kml2mec.Activator;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import kml2mec.Kml2mecUtils;
import kml2mec.KmlMecContext;
import kml2mec.MecFunction;
import kml2mec.MecHeader;
import kml2mec.MecLTS;
import kml2mec.MecSTS;

public class ComponentKml2MecActor
implements IComponentActor {
    public static boolean verbose = true;
    public static boolean errverbose = true;
    private TemplateLoader loader = Activator.getDefault().getTemplateLoader();
    private Configuration config = new Configuration();
    private String currentDir = "";
    protected KmlMecContext kmc;

    public ComponentKml2MecActor() {
        this.config.setTemplateLoader(this.loader);
    }

    public void doSomethingWithComponent(Component comp, KmlElement currentSelection, String relativePath) {
        Assembly ass;
        Composition composi = comp.getComposition();
        if (composi != null && (ass = composi.getAssembly()) != null) {
            Object[] links = ass.getLinks().keySet().toArray();
            Icon icon = null;
            String linkname = (String)JOptionPane.showInputDialog(null, "Select the link :", "Link checking", -1, icon, links, links[0]);
            try {
                Link ln = ass.getLink(linkname);
                KmlMecContext kmc = this.fixContextAndPaths(composi, ln, icon, relativePath);
                kmc.computeRunnableServices();
                MecSTS sts = ComponentKml2MecActor.translate_to_mec(kmc);
                this.writeMecFileToCurrentdir(sts);
            }
            catch (NonExistingLinkException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                if (errverbose) {
                    System.err.println("file error (path) :" + this.getCurrentDir());
                }
                e.printStackTrace();
            }
        }
    }

    public boolean isApplicableFor(KmlElement currentSelection) {
        return false;
    }

    public void setCurrentDir(String currentDir) {
        this.currentDir = currentDir;
        File f = new File(currentDir);
        f.mkdirs();
        System.out.println(String.valueOf(currentDir) + " " + f.exists());
    }

    private String getCurrentDir() {
        return this.currentDir;
    }

    public void writeMecFileToCurrentdir(MecSTS sts) throws IOException {
        String filename = String.valueOf(this.getCurrentDir()) + "/" + sts.getName() + ".mec";
        FileWriter file = new FileWriter(filename);
        file.write(sts.toString());
        file.close();
        if (verbose) {
            System.out.println("written in " + filename);
        }
    }

    private KmlMecContext fixContextAndPaths(Composition composi, Link ln, Icon icon, String relativePath) {
        Service serv2;
        Service serv1 = ln.getFirst().getServ();
        if (serv1.isProvided()) {
            serv2 = ln.getSecond().getServ();
        } else {
            serv2 = serv1;
            serv1 = ln.getSecond().getServ();
        }
        Component provider = serv1.getOwner();
        Component requirer = serv2.getOwner();
        ArrayList<String> requirer_provided = new ArrayList<String>();
        for (Service prov : serv2.getOwner().getServices()) {
            if (!prov.isProvided() || !prov.getInterface().getExtrequired().contains(serv2.getName())) continue;
            requirer_provided.add(prov.getName());
        }
        Object[] services = requirer_provided.toArray();
        String servname = (String)JOptionPane.showInputDialog(null, "Select the provided service :", "Service checking", -1, icon, services, services[0]);
        Service callerserv = serv2.getOwner().getService(servname);
        String compPath = composi.getOwner().getFilePath();
        String projectroot = compPath.substring(0, compPath.indexOf(relativePath));
        int lastdot = relativePath.lastIndexOf(".");
        String exportdirRelPath = relativePath.substring(0, lastdot);
        String cleanedRelPath = exportdirRelPath.replaceAll("/", "\u00c3\u00b9").replaceAll("[^\\p{Alnum}.\u00c3\u00b9]", "");
        String exportingPath = String.valueOf(projectroot) + "MEC" + "/" + cleanedRelPath.replaceAll("\u00c3\u00b9", "/");
        if (verbose) {
            System.out.println("exportingPath " + exportingPath);
        }
        this.setCurrentDir(exportingPath);
        this.kmc = new KmlMecContext(composi, ln, provider, requirer, serv1, callerserv, serv2, exportingPath);
        if (verbose) {
            System.out.println("context " + this.kmc.toString());
        }
        return this.kmc;
    }

    public static MecSTS translate_to_mec(KmlMecContext mc) {
        MecSTS sts = new MecSTS();
        Service stc = mc.getService_tocheck();
        String syncSyst = "Verif_" + Kml2mecUtils.toMecString(stc.getFullName());
        MecHeader head = new MecHeader();
        head.setFileName(syncSyst);
        head.setComment("Model checking of services with MEC IV \n --> Case study: ATM");
        head.setRelComment("Peer-to-peer checking");
        sts.setHeader(head);
        ArrayList<MecLTS> runnableMecLTS = new ArrayList<MecLTS>();
        for (LTS lts : mc.getRunLTS()) {
            runnableMecLTS.add(new MecLTS(lts));
        }
        sts.setLts(runnableMecLTS);
        if (errverbose) {
            System.out.println(mc.getRunLinks().toString());
        }
        sts.computeSyncFromServices(mc.getRunServ(), mc.getRunLinks(), mc.getService_required().getName());
        sts.addFunction(MecFunction.inevitable());
        sts.defaultSession();
        return sts;
    }
}

