/*
 * Decompiled with CFR 0.152.
 */
package kml2mec;

import costo.graph.Component;
import costo.graph.Composition;
import costo.graph.LTS;
import costo.graph.Link;
import costo.graph.NonExistingLinkException;
import costo.graph.Service;
import costo.graph.ServiceInterface;
import costo.graph.expressions.KmlCommunication;
import costolib_plugin_kml2mec.ComponentKml2MecActor;
import java.util.ArrayList;
import kml2mec.InvalidMecContextException;
import kml2mec.KmlMecLink;

public class KmlMecContext {
    private boolean valid;
    private Composition enclosingComponent;
    private Link mainLink;
    private Component comp_tocheck;
    private Component comp_calling;
    private Service service_tocheck;
    private Service service_calling;
    private Service service_required;
    private ArrayList<Service> runServ;
    private ArrayList<LTS> runLTS;
    private ArrayList<KmlMecLink> runLinks;
    private String outputdir;

    public KmlMecContext(Composition enclosingComponent, Link mainLink, Component comp_tocheck, Component comp_calling, Service service_tocheck, Service service_calling, Service service_required, String outputdir) {
        this.valid = true;
        this.enclosingComponent = enclosingComponent;
        this.mainLink = mainLink;
        this.comp_tocheck = comp_tocheck;
        this.comp_calling = comp_calling;
        this.service_tocheck = service_tocheck;
        this.service_calling = service_calling;
        this.service_required = service_required;
        this.outputdir = outputdir;
    }

    public KmlMecContext() {
        this.valid = false;
    }

    public KmlMecContext InvalidMecContext() {
        KmlMecContext mc = new KmlMecContext();
        mc.valid = false;
        return mc;
    }

    public String getOutputdir() {
        return this.outputdir;
    }

    public Component getComp_calling() {
        return this.comp_calling;
    }

    public Component getComp_tocheck() {
        return this.comp_tocheck;
    }

    public Service getService_calling() {
        return this.service_calling;
    }

    public Service getService_required() {
        return this.service_required;
    }

    public Service getService_tocheck() {
        return this.service_tocheck;
    }

    public boolean getValid() {
        return this.valid;
    }

    public ArrayList<Service> getRunServ() {
        return this.runServ;
    }

    public ArrayList<LTS> getRunLTS() {
        return this.runLTS;
    }

    public ArrayList<KmlMecLink> getRunLinks() {
        return this.runLinks;
    }

    public void setComp_calling(Component comp_calling) throws InvalidMecContextException {
        if (comp_calling == null) {
            throw new InvalidMecContextException("null calling Component");
        }
        this.comp_calling = comp_calling;
    }

    public void setComp_tocheck(Component comp_tocheck) throws InvalidMecContextException {
        if (comp_tocheck == null) {
            throw new InvalidMecContextException("null Component to check");
        }
        this.comp_tocheck = comp_tocheck;
    }

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }

    public void setRunLinks(ArrayList<KmlMecLink> runLinks) {
        this.runLinks = runLinks;
    }

    public void setRunLTS(ArrayList<LTS> runLTS) {
        this.runLTS = runLTS;
    }

    public void setRunServ(ArrayList<Service> runServ) {
        this.runServ = runServ;
    }

    public void setService_calling(Service service_calling) throws InvalidMecContextException {
        if (service_calling == null) {
            throw new InvalidMecContextException("null service_calling");
        }
        this.service_calling = service_calling;
    }

    public void setService_required(Service service_required) throws InvalidMecContextException {
        if (service_required == null) {
            throw new InvalidMecContextException("null required service");
        }
        this.service_required = service_required;
    }

    public void setService_tocheck(Service service_tocheck) throws InvalidMecContextException {
        if (service_tocheck == null) {
            throw new InvalidMecContextException("null Service to check");
        }
        this.service_tocheck = service_tocheck;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public Composition getEnclosingComponent() {
        return this.enclosingComponent;
    }

    public void setEnclosingComponent(Composition system) throws InvalidMecContextException {
        this.enclosingComponent = system;
        if (system == null) {
            throw new InvalidMecContextException(" No composition loaded.");
        }
        if (system != null && system.getAssembly().getAssemblyNamedComponents().isEmpty()) {
            throw new InvalidMecContextException(String.valueOf(system.getName()) + " is not a correct composition for behavior checking.");
        }
    }

    public void computeRunnableServices() throws NonExistingLinkException {
        Link link;
        boolean verbose = ComponentKml2MecActor.errverbose;
        this.runServ = new ArrayList();
        this.runLTS = new ArrayList();
        this.runLinks = new ArrayList();
        this.runLinks.add(KmlMecLink.MecLinkPR(this.mainLink, this.service_calling, "_" + this.service_required.getName()));
        this.runServ.add(this.service_tocheck);
        this.runServ.add(this.service_calling);
        LTS flat_tc = this.service_tocheck.getBehavior().getFlatVersion("__CALLER");
        this.runLTS.add(flat_tc);
        LTS flat_c = this.service_calling.getBehavior().getFlatVersion("_" + this.service_required.getName());
        this.runLTS.add(flat_c);
        ServiceInterface interf_tc = this.service_tocheck.getDeepInterface();
        ServiceInterface interf_c = this.service_calling.getDeepInterface();
        if (verbose) {
            System.out.println("flat_tc: " + flat_tc.toString());
        }
        if (verbose) {
            System.out.println("flat_c: " + flat_c.toString());
        }
        if (verbose) {
            System.out.println("interf_tc: " + interf_tc.toString());
        }
        if (verbose) {
            System.out.println("interf_c: " + interf_c.toString());
        }
        if (verbose) {
            System.out.println("TEST1=====look for list : " + interf_tc.getCalrequired());
        }
        block0: for (Object element : interf_tc.getCalrequired()) {
            String servName = (String)element;
            if (verbose) {
                System.out.println("TEST2=====look for : " + servName + ".");
            }
            for (Object element2 : this.mainLink.getSubLinks()) {
                link = (Link)element2;
                if (verbose) {
                    System.out.println("TEST3=====in link : " + link + " \n type: " + link.getLinktype() + " name: " + link.getFirst().getServiceName() + ".");
                }
                if (link.getLinktype() != 2 || !link.getFirst().getServiceName().equals(servName)) continue;
                if (verbose) {
                    System.out.println("TEST4===== found");
                }
                if (!interf_c.getSubprovided().contains(link.getSecond().getServiceName())) {
                    this.runServ.add(link.getSecond().getServ());
                    this.runLTS.add(link.getSecond().getServ().getBehavior().getFlatVersion());
                    if (verbose) {
                        System.out.println("add provided service from:" + link.toString());
                    }
                    this.runLinks.add(KmlMecLink.MecLinkSRP(link, this.service_tocheck, "__CALLER"));
                    continue block0;
                }
                this.runLinks.add(KmlMecLink.MecLinkSRSP(link, this.service_tocheck, "__CALLER", this.service_calling, "_" + this.service_required.getName()));
                continue block0;
            }
        }
        ArrayList called = flat_c.getCalledServices("_" + this.service_required.getName());
        called.remove(this.service_required.getName());
        if (verbose) {
            System.out.println("TESTb1=====look for : _" + this.service_required.getName() + " --" + called);
        }
        block2: for (KmlCommunication servName : called) {
            if (servName.getCommunicationName() == this.service_required.getName()) continue;
            if (verbose) {
                System.out.println("TESTb2=====look for : " + servName + ".");
            }
            if (this.mainLink.getSubLinks() == null) continue;
            for (Object element : this.mainLink.getSubLinks()) {
                link = (Link)element;
                if (verbose) {
                    System.out.println("TESTb3=====in link : " + link + " \n type: " + link.getLinktype() + " name: " + link.getFirst().getServiceName() + ".");
                }
                if (link.getLinktype() != 1 || !link.getSecond().getServiceName().equals(servName)) continue;
                if (verbose) {
                    System.out.println("TESTb4===== found");
                }
                if (!interf_tc.getSubprovided().contains(link.getFirst().getServiceName())) {
                    this.runServ.add(link.getFirst().getServ());
                    this.runLTS.add(link.getFirst().getServ().getBehavior().getFlatVersion());
                    if (verbose) {
                        System.out.println("calreq-prov " + interf_tc.getSubprovided() + " - " + link.getFirst().getServiceName());
                    }
                    if (verbose) {
                        System.out.println("add provided service from:" + link.toString());
                    }
                    this.runLinks.add(KmlMecLink.MecLinkPSR(link, this.service_calling, "_" + this.service_required.getName()));
                    continue block2;
                }
                if (verbose) {
                    System.out.println("calreq-subprov");
                }
                this.runLinks.add(KmlMecLink.MecLinkSPSR(link, this.service_calling, "_" + this.service_required.getName(), this.service_tocheck, "__CALLER"));
                continue block2;
            }
        }
        this.valid = true;
    }
}

