/*
 * Decompiled with CFR 0.152.
 */
package kml2mec;

import costo.graph.Link;
import costo.graph.Service;

public class KmlMecLink {
    protected int linktype;
    protected Link kmllink;
    protected Service callserv;
    protected String callchannel;
    protected Service provserv;
    protected String provchannel;

    public KmlMecLink(Link link, Service callserv, String callchannel, Service provserv, String provchannel) {
        this.kmllink = link;
        this.linktype = link.getLinktype();
        this.callchannel = callchannel;
        this.callserv = callserv;
        this.provchannel = provchannel;
        this.provserv = provserv;
    }

    public static KmlMecLink MecLinkPR(Link link, Service callserv, String callchannel) {
        KmlMecLink ml = new KmlMecLink(link, callserv, callchannel, link.getFirst().getServ(), "__CALLER");
        return ml;
    }

    public static KmlMecLink MecLinkRP(Link link, Service provserv, String provchannel) {
        KmlMecLink ml = new KmlMecLink(link, link.getSecond().getServ(), "__CALLER", provserv, provchannel);
        return ml;
    }

    public static KmlMecLink MecLinkPSR(Link link, Service callserv, String callchannel) {
        KmlMecLink ml = new KmlMecLink(link, callserv, callchannel, link.getFirst().getServ(), "__CALLER");
        ml.setLinktype(7);
        return ml;
    }

    public static KmlMecLink MecLinkSRP(Link link, Service provserv, String provchannel) {
        KmlMecLink ml = new KmlMecLink(link, provserv, provchannel, link.getSecond().getServ(), "__CALLER");
        ml.setLinktype(5);
        return ml;
    }

    public static KmlMecLink MecLinkSRSP(Link link, Service callserv, String callchannel, Service provserv, String provchannel) {
        KmlMecLink ml = new KmlMecLink(link, callserv, callchannel, provserv, provchannel);
        ml.setLinktype(6);
        return ml;
    }

    public static KmlMecLink MecLinkSPSR(Link link, Service callserv, String callchannel, Service provserv, String provchannel) {
        KmlMecLink ml = new KmlMecLink(link, callserv, callchannel, provserv, provchannel);
        ml.setLinktype(8);
        return ml;
    }

    public int getLinktype() {
        return this.linktype;
    }

    public void setLinktype(int linktype) {
        this.linktype = linktype;
    }

    public Service getCallServ() {
        return this.callserv;
    }

    public String getCallChannel() {
        return this.callchannel;
    }

    public Service getProvServ() {
        return this.provserv;
    }

    public String getProvChannel() {
        return this.provchannel;
    }

    public String getServname1() {
        return this.kmllink.getFirst().getServiceName();
    }

    public String getServname2() {
        return this.kmllink.getSecond().getServiceName();
    }

    public String toString() {
        String s = super.toString();
        s = String.valueOf(s) + " call : " + this.callserv.getName() + "/" + this.callchannel;
        s = String.valueOf(s) + " prov : " + this.provserv.getName() + "/" + this.provchannel;
        return s;
    }
}

