/*
 * Decompiled with CFR 0.152.
 */
package kml2mec;

import costo.graph.LTS;
import costo.graph.Label;
import costo.graph.Service;
import costo.graph.State;
import costo.graph.Transition;
import java.util.ArrayList;
import java.util.Collections;
import kml2mec.Kml2mecUtils;

public class MecLTS
extends LTS {
    protected Boolean reInitialisable = false;

    public MecLTS(LTS a) {
        super(a);
    }

    public MecLTS(Service serv) {
        super(serv);
    }

    public void setReInitialisable() {
        this.reInitialisable = true;
    }

    static String convertToMec(Label label) {
        String s;
        switch (label.getActionType()) {
            case 256: {
                s = "nop";
                break;
            }
            case 2: {
                s = "start" + label.getChannel() + "_" + label.getMessage();
                break;
            }
            case 1: {
                s = "call" + Kml2mecUtils.toMecString(String.valueOf(label.getChannel()) + "_" + label.getMessage());
                break;
            }
            case 8: {
                s = "rcv" + Kml2mecUtils.toMecString(label.getExpression().getRawValue());
                break;
            }
            case 16: {
                s = "emit" + Kml2mecUtils.toMecString(label.getExpression().getRawValue());
                break;
            }
            case 32: {
                s = "emit_result" + label.getChannel() + "_" + label.getMessage();
                break;
            }
            case 4: {
                s = "rcv_result" + label.getChannel() + "_" + label.getMessage();
                break;
            }
            case 128: {
                s = "internal_" + label.getMessage();
                break;
            }
            default: {
                s = Kml2mecUtils.toMecString(label.getRawLabel());
            }
        }
        return s;
    }

    public String toString() {
        String s = "transition_system ";
        ArrayList<String> translist = new ArrayList<String>();
        String serv = this.getServiceName();
        s = String.valueOf(s) + this.getComponentName() + "_" + serv;
        s = String.valueOf(s) + " < width = 0 >;\n";
        s = String.valueOf(s) + "init |- e -> init, \\* epsilon transition *\\ \n";
        s = String.valueOf(s) + "     start__CALLER_" + serv + " -> " + this.getInitialState().getName() + ";\n";
        MecLTS flat = this;
        for (State st : flat.getStatesMap().values()) {
            String stemp = String.valueOf(st.getName()) + " |- e -> " + st.getName() + " \\* epsilon transition *\\";
            for (Transition tr : st.getOutGoingTransitions()) {
                stemp = String.valueOf(stemp) + ",\n      ";
                stemp = String.valueOf(stemp) + MecLTS.convertToMec(tr.getLabel());
                stemp = String.valueOf(stemp) + " -> " + tr.getTarget().getName();
            }
            stemp = String.valueOf(stemp) + ";\n";
            translist.add(stemp);
        }
        Collections.sort(translist);
        for (String ss : translist) {
            s = String.valueOf(s) + ss;
        }
        if (this.reInitialisable.booleanValue()) {
            for (State st : this.getFinalStates()) {
                s = String.valueOf(s) + st.getName() + " |- start__CALLER_" + serv + " -> " + this.getInitialState().getName() + "; \n";
                s = String.valueOf(s) + "\\* epsilon transition for reinitialisation *\\ \n";
            }
        }
        s = String.valueOf(s) + " < initial = { init }; final = { ";
        int leng = this.getFinalStates().size();
        for (State st : this.getFinalStates()) {
            s = String.valueOf(s) + st.getName();
            if (--leng <= 0) continue;
            s = String.valueOf(s) + " , ";
        }
        s = String.valueOf(s) + " } >.\n";
        return s;
    }
}

