/*
 * Decompiled with CFR 0.152.
 */
package mecloader.popup.actions;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import costo.utils.exports.LTStoEPS;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import mec.MecLoader;
import mec.exports.Mec2Dot;
import mec.graph.MecRes;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class LoadMecResultAction
implements IObjectActionDelegate {
    private Shell shell;
    private IFile file;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.file != null) {
            IPath location = this.file.getLocation();
            String spec_abs_path = String.valueOf(location.removeLastSegments(1).toString()) + "/";
            String mec_res_name = location.lastSegment();
            try {
                MecRes test = MecLoader.loadMecRes(spec_abs_path, mec_res_name);
                if (test != null) {
                    Mec2Dot.write(test.getSts(), String.valueOf(test.getFileName()) + ".dot");
                    IFile propfile = this.file.getProject().getFile("Kml2latex.userprefs");
                    Properties p = new Properties();
                    p.load(propfile.getContents());
                    LTStoEPS.LayoutDotFile((String)("\"" + test.getFileName() + "\""), (String)"ps1", (Properties)p);
                    LTStoEPS.LayoutDotFile((String)("\"" + test.getFileName() + "\""), (String)"svg", (Properties)p);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                MessageDialog.openInformation((Shell)this.shell, (String)"MECDOT", (String)"Load Mec Result failed.");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (RecognitionException e) {
                MessageDialog.openInformation((Shell)this.shell, (String)"MECDOT", (String)"Load Mec Result failed.");
                e.printStackTrace();
            }
            catch (TokenStreamException e) {
                MessageDialog.openInformation((Shell)this.shell, (String)"MECDOT", (String)"Load Mec Result failed.");
                e.printStackTrace();
            }
            catch (IOException e) {
                MessageDialog.openInformation((Shell)this.shell, (String)"MECDOT", (String)"Load Mec Result failed.");
                e.printStackTrace();
            }
        }
        MessageDialog.openInformation((Shell)this.shell, (String)"MECDOT", (String)"Load Mec Result was executed.");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TreeSelection) {
            TreeSelection treesel = (TreeSelection)selection;
            this.file = (IFile)treesel.getFirstElement();
        }
    }
}

