/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_graphpopup.popup.actions;

import costo.graph.LTS;
import costo.graph.Service;
import costo.graph.State;
import costo.graph.Transition;
import costolib.ui.utils.PopupActionOnComponent;
import costolib_plugin_graphpopup.util.TransitionEdge;
import org.eclipse.jface.action.IAction;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;

public class DoGraphAction
extends PopupActionOnComponent {
    public void run(IAction action) {
        System.out.println(this.getSelectedComponent());
        Service serv = this.selectServiceFromGUI(1);
        if (serv == null) {
            return;
        }
        this.doGraphStuff(serv);
    }

    private void doSimpleGraphStuff(Service serv) {
        DirectedGraph<String, DefaultEdge> graph = this.convertLtsToSimpleDirectedGraph(serv.getBehavior());
        System.out.println("GRAPH" + graph);
        CycleDetector cycleD = new CycleDetector(graph);
        System.out.println("cycles " + cycleD.findCycles());
        StrongConnectivityInspector strongCD = new StrongConnectivityInspector(graph);
        System.out.println("STRongly connected subgraphs " + strongCD.stronglyConnectedSubgraphs());
    }

    private void doGraphStuff(Service serv) {
        DirectedGraph<State, TransitionEdge> graph = this.convertLtsToDirectedGraph(serv.getBehavior());
        System.out.println("GRAPH" + graph);
        CycleDetector cycleD = new CycleDetector(graph);
        System.out.println("cycles " + cycleD.findCycles());
        StrongConnectivityInspector strongCD = new StrongConnectivityInspector(graph);
        System.out.println("STRongly connected subgraphs " + strongCD.stronglyConnectedSubgraphs());
    }

    private DirectedGraph<String, DefaultEdge> convertLtsToSimpleDirectedGraph(LTS behavior) {
        if (behavior == null) {
            return null;
        }
        DirectedMultigraph graph = new DirectedMultigraph(DefaultEdge.class);
        for (State s : behavior.getStatesMap().values()) {
            graph.addVertex((Object)s.getName());
        }
        for (Transition t : behavior.getTransitions()) {
            graph.addEdge((Object)t.getSource().getName(), (Object)t.getTarget().getName());
        }
        return graph;
    }

    private DirectedGraph<State, TransitionEdge> convertLtsToDirectedGraph(LTS behavior) {
        if (behavior == null) {
            return null;
        }
        DirectedMultigraph graph = new DirectedMultigraph(TransitionEdge.class);
        for (State s : behavior.getStatesMap().values()) {
            graph.addVertex((Object)s);
        }
        for (Transition t : behavior.getTransitions()) {
            graph.addEdge((Object)t.getSource(), (Object)t.getTarget(), (Object)new TransitionEdge(t));
        }
        return graph;
    }
}

