header
{
package costo.grammar;
// test cvs
}
//TODO problems with quotes and \ in guards, problems with nops after guards
// changes
class AnalyserLex extends Lexer;

options { k=3;defaultErrorHandler=false; }//charVocabulary = '\0'..'\377';
  //testLiterals=false;    // don't automatically test for literals

protected DIGIT : '0'..'9';

UNDER : '_';

protected LETTER : 'a'..'z' | 'A'..'Z';
protected BIDIRPIPE : "<|>";

NUMBER : DIGIT (DIGIT)*;
WORD options {testLiterals=true;}
: LETTER (DIGIT | LETTER | UNDER)* ;
AT:'@';
protected GOTO : "GOTO" ;
// ports
//protected SELF : "_SELF";
//protected CALLER :"_CALLER";

LINKTYPE : "r-r"|"r-p"|"p-p"|"p-r";
//PORT : UNDER (WORD | SELF | CALLER);

//PRIMITIVE TYPES
protected INTEGER_TYPE :"INT";
protected BOOL_TYPE:"BOOL";
protected STRING_TYPE:"STRING";

protected INTEGER : NUMBER;

 
LT : '<';
GT : '>';
EQ : '=';
DIFF : "<>";
LE : "<=";
GE : ">=";


PIPE : "|";
 ARROW_START : "--";

ARROW_END : "-->" ;

COMMA : ',';

SEMICOLON : ';';

BLOCK_START : '{';

BLOCK_END : '}';

PAR_START : '(';

PAR_END : ')';

BRACKET_START : '[';

BRACKET_END : ']';

DB_EXCLAM_MARK : "!!";

DB_QUESTION_MARK : "??";

QUESTION_MARK : '?';

EXCLAM_MARK : '!';

AFFECTE : ":=";

COLON : ':';

QUOT_MARK : '\"';
protected SUBLINKS:"sublinks";
PERIOD : '.';
protected DOTDOT : PERIOD PERIOD;

PLUS : '+';
MINUS : '-';
MULT : '*';
DIV : '/';


LAND : "&&";
LOR : "||" ;

//protected OP_NOT : "not"; 
//LNOT			:	'!'	;
LNOT			:	'~'	;
//TRUE : "true";

//FALSE : "false";

//FOR_ALL : "Forall";

// EXISTS : "Exists";


INCR : "++";

WS    :
    (' ' 
    | '\t' 
    | '\r' '\n' { newline(); } 
    | '\n'      { newline(); }
    )     { $setType(Token.SKIP); } ;

//SPECIAL_CHARS : '@'|'%'|'\\'|'\''|'^'|'&'|'|';

// Single-line comments

protected AT_SL_COMMENT 
        :("#")
			(~('\n'|'\r'))* ('\n'|'\r'('\n')?)
			
		;
		
	
//IDENT
//	options {testLiterals=true;}
//	:	('a'..'z'|'A'..'Z') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')* ;




// character literals
protected CHAR_LITERAL
	:	'\'' ( ESC | ~('\''|'\n'|'\r'|'\\') ) '\''
	;

// string literals
STRING_LITERAL
	:	'"' (ESC|~('"'|'\\'|'\n'|'\r'))* '"'
	;


// escape sequence -- note that this is protected; it can only be called
// from another lexer rule -- it will not ever directly return a token to
// the parser
protected
ESC
	:	'\\'
		(	'n'
		|	'r'
		|	't'
		|	'b'
		|	'f'
		|	'"'
		|	'\''
		|	'\\'
		)
	;

	
		
IMP_ML_COMMENT
	:	"/*" 
	(NEWLINE|~('*'))* "*/" ;

SL_COMMENT
		:	("//"|"#")
			(~('\n'|'\r'))* ('\n'|'\r'('\n')?)
			{$setType(Token.SKIP); newline();}
		;
NEWLINE   :  ( "\r\n" // DOS
               | '\r'   // MAC
               | '\n'   // Unix
             )
             { newline(); 
               $setType(Token.SKIP);
             }
          ;
{
	import antlr.TokenWithIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Iterator;
import java.io.File;
import java.io.FileReader;
// TODO : organize imports when stable
import costo.graph.*; 
import costo.graph.types.*;
import costo.graph.expressions.*;  
import costo.graph.ComponentFactory;
@SuppressWarnings("unused")
//import costo.checks.verification.core.Annotation;
}

/*
* Analyseur syntaxique d'un composant
*/

class AnalyserSyn extends Parser;
options {defaultErrorHandler=false;k=2;buildAST=true;}
// folowing are tokens that don't have simple  syntactic counterparts
tokens { MINUS="-";PLUS="+"; PROPOSITION;POST_INC;POST_DEC;EXPR;ELIST;TRANSITION;LABEL;BRANCHING_STATE;COMPONENT_OCCURRENCE;LINK;SUBLINK;NAMELIST;INTERLOCUTORSET;UNARY_MINUS;UNARY_PLUS;}
//The following code is added to the beginning of the Analyser class

{ 
	protected ComponentFactory componentFactory;
    
    protected Component currentComponent; // this stores the type definitions
protected KmlStructuralElement previousElement=null;
public AnalyserSyn(TokenStream lexer, ComponentFactory cf) {
  this(lexer);
 
  this.componentFactory=cf;
  
}
	public void setCurrentComponent(Component comp){
		this.currentComponent=comp;
	}
    /**
     * @return Returns the componentFactory.
     */
    public ComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    /**
     * @param componentFactory The componentFactory to set.
     */
    public void setComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }
//    private int startline;
    
    public void nextElem(KmlStructuralElement elem, int line){
    //	System.out.println("calling nextElem with "+(elem!=null?elem.getClass():"null")+ " at line "+line);
   	//System.out.println("------------------prev "+(previousElement!=null?previousElement.getClass():"null"));
    	int lline = (elem!=null?elem.getLine():line);
    	 
    	if (previousElement!=null&&previousElement.getLastLine()==0) {previousElement.setLastLine(lline-1);
    	//System.out.println(previousElement.getClass()+ " set to "+lline);
    	}
    	previousElement=elem;
    }
    
   
}
//---------------------------------------------------------------- COMPONENTS --------------------------
//GA : components 

component returns [Component c =null] {ArrayList<Service> servlist=null;
	ArrayList<CostoLibrary> liblist=null; String nom="";
	VariablesClause varlist=null;ConstantsClause constlist=null;
	HashMap <String,String> renamelist=null,servproplist=null;
	HashMap <String,KmlPredicate> proplist=null;
	InvariantClause invarlist=null;
	InitializationsClause initlist=null;
	
	
	 ComponentInterface compinter; Composition cp=null;String com="";String status="";} : 
"COMPONENT"^ nom=name {c=new Component(nom); c.setLogger(componentFactory.getLogger());currentComponent=c; }
(comm:IMP_ML_COMMENT{com=comm.getText();c.setComment(com);})?
("status" s:WORD {status=s.getText();c.setStatus(status);})?
  compinter=compinterface {c.setInterface(compinter);}
 (options {greedy=true;} :liblist=complibclause )?
 {if (liblist==null) liblist= new ArrayList <CostoLibrary>();
	liblist.add(componentFactory.getDefaultLibrary());
	c.setLibraries(liblist);
	}
(comptypesclause)?   
(constlist=compconstantsclause{c.setConstantsClause(constlist);nextElem(constlist,0);})?  
(varlist=compvariablesclause{c.setVariablesClause(varlist);nextElem(varlist,0);})?
(invarlist=compinvariantclause{c.setInvariantClause(invarlist);nextElem(invarlist,0);})? 
(proplist=comppropertiesclause)?  // props not to be checked in the invariant
(servproplist=compservpropertiesclause)? // definition of properties applicable to services 
(initlist=compinitializationclause{c.setInitializationsClause(initlist);nextElem(initlist,0);})? 
 (servlist=services  )? //
 
 (cp=composition)? 
 {
	//c.setInvariant(invarlist);
    c.setProperties(proplist);
    c.setFilePath(componentFactory.getCurrentFile());
    c.setServiceProperties(servproplist);
	c.setServices(servlist);
	c.setComposition(cp);
	// second pass and checks
	c.structureCompletion();

};  





//
compinterface returns [ComponentInterface compint=new ComponentInterface()]{ArrayList<String> prov=null; ArrayList<String> req=null;} 
: a:"INTERFACE"! {nextElem(compint,a.getLine());compint.setColumn(a.getColumn());compint.setLine(a.getLine());}
(prov=providesclause {compint.setProvided(prov);})? 
(req=requiresclause  {compint.setRequired(req);})? ;

providesclause returns [ArrayList<String> al=null]:
"provides"^ COLON! al=namelist; 

requiresclause returns [ArrayList<String> al=null]:
"requires"^ COLON! al=namelist; 

//TODO : change with a simpler namelist without enclosing {}
protected complibclause returns [ArrayList<CostoLibrary> al=new ArrayList<CostoLibrary>();]{ArrayList<String> names;CostoLibrary tempLib=null;} 
:a:"USES"^ {nextElem(null,a.getLine());} names=namelist{for(String name:names){tempLib=new CostoLibrary(name.trim(),componentFactory);tempLib.check();al.add(tempLib);}}; 


protected comptypesclause  
:a:"TYPES"^ {currentComponent.getTypeSpace().setLine(a.getLine());nextElem(currentComponent.getTypeSpace(),a.getLine());}decl_types; 

protected compconstantsclause returns [ConstantsClause c=null] {HashMap<String,Variable> al=null;}
:a:"CONSTANTS"^ al=decl_constants{c= new ConstantsClause(al);c.setLine(a.getLine());c.setColumn(a.getColumn());}; 


protected compvariablesclause returns [VariablesClause c=null]{HashMap<String,Variable> al=null;} 
:a:"VARIABLES"^ al=decl_variables_and_rename{c= new VariablesClause(al);c.setLine(a.getLine());c.setColumn(a.getColumn());}; 

protected compinvariantclause returns [InvariantClause c=null]{HashMap<String,KmlPredicate> al=null;} 
:a:"INVARIANT"^ al=properties{c= new InvariantClause(al);c.setLine(a.getLine());c.setColumn(a.getColumn());};

protected comppropertiesclause returns [HashMap<String,KmlPredicate> al=null] :
"PROPERTIES"^ al=properties; // prop de base (caractérisation des constantes) sur lesquelles s'appuie la verif de l'invariant, 


protected compservpropertiesclause returns [HashMap<String,String> al=null] :
"SERVICE_PROPERTIES"^ al=servproperties; 

protected compinitializationclause returns [InitializationsClause c=null]{HashMap<String, KmlAssignmentExpression> al=null;} 
:a:"INITIALIZATION"^ al=init_variables{c= new InitializationsClause(al);c.setLine(a.getLine());c.setColumn(a.getColumn());};


//-----------------------  Composition 


protected composition returns [Composition c=new Composition();] {HashMap<String,Composition> complist=null;HashMap<String, ContextMapping> contextMapping;HashMap<String,Link> namedLinks=null;Assembly assembl=null;}
:start:"COMPOSITION"^ (comm:IMP_ML_COMMENT{c.setComment(comm.getText());})?
assembl=assembly {c.setAssembly(assembl);} 
("Promotion" 
 ("Links" namedLinks=new_links {c.setPromotionLinks(namedLinks);})? 
 ("Variables" contextMapping=context_mappings{c.setContextMappingOfPromotedVariables(contextMapping); })?
 )? end:"END_COMPOSITION"{c.setLastLine(end.getLine());c.setLine(start.getLine());c.setColumn(start.getColumn());}
;


assembly returns [Assembly assembl= new Assembly()]{ArrayList<ComponentVariable> components=null;ArrayList<AssemblyVariable> assemblies=null;HashMap<String,Link> namedLinks=null;}:
(a:"ASSEMBLY" {assembl.setLine(a.getLine());assembl.setColumn(a.getColumn());}|b:"Assembly"{assembl.setLine(b.getLine());assembl.setColumn(b.getColumn());}) (name:WORD{assembl.setName(name.getText());})?
{assembl.setContext(this.componentFactory);}
"Components" components =component_variables {assembl.setNamedComponents(components);}
("Assemblies" assemblies= assembly_variables{assembl.setAssemblies(assemblies);})?
("Links" namedLinks=new_links {assembl.setLinks(namedLinks);} )? end:"End"{assembl.setLastLine(end.getLine());};

protected new_links returns [HashMap<String,Link> links= new HashMap<String,Link>()]{ServiceIdentifier first=null,second=null;Link ln=null;ArrayList<String> subl=null;HashMap<String,String> messageMap=null;HashMap<String, ContextMapping> contextMapping;}:
(AT linkname:WORD {ln=new Link(linkname.getText(),linkname.getLine(),linkname.getColumn());} COLON (t:LINKTYPE {ln.setLinktype(t.getText());})? first=service_identifier second=service_identifier{ln.setFirst(first);ln.setSecond(second);} 
("context" "mapping" contextMapping=context_mappings {ln.setContextMapping(contextMapping);})?
("message" "mapping" messageMap=message_mappings {ln.setMessageMapping(messageMap);})?
("sublinks"  COLON subl=namelist{ln.setSublinksNames(subl);})?
{links.put(linkname.getText(),ln);})*;

//TODO : manage array elements ? no because separate links would be needed if interpretation differs (BTW, it shouldn't differ in all cases)
protected context_mappings returns [HashMap<String,ContextMapping> map=new HashMap<String,ContextMapping>()]{ContextMapping cxm=null;}:
cxm = context_mapping {map.put(cxm.getVirtualVariable().getRawValue(),cxm);} (options {greedy=true;	}:COMMA cxm = context_mapping {map.put(cxm.getVirtualVariable().getRawValue(),cxm);})*;
//(kid=identPrimary "=" p:WORD (COMMA)?{map.put(m.getText(),p.getText());})*;
protected context_mapping returns [ContextMapping cxm=null] {KmlIdentifier kid=null;KmlExpression value=null;}:
kid=identPrimary "=" value=conditionalExpression {cxm=new ContextMapping(kid,value);};

protected message_mappings returns [HashMap<String,String> map=new HashMap<String,String>()]:
(m:WORD "=" p:WORD (COMMA)?{map.put(m.getText(),p.getText());})*;
protected service_identifier returns [ServiceIdentifier si=null]{KmlIdentifier id=null;}: 
("SELF" PERIOD m:WORD {si=new ServiceIdentifier(m.getText(),"SELF",m.getLine(),m.getColumn());}
| id=identPrimary {si=new ServiceIdentifier(id);}) 
;
protected component_variables returns [ArrayList<ComponentVariable> components=new ArrayList<ComponentVariable>();]{ComponentVariable cv=null;}:
(g:WORD COLON! h:WORD {cv=new ComponentVariable(g.getText(),h.getText(),g.getLine(),g.getColumn());components.add(cv);})
(options {greedy=true;	}:SEMICOLON g2:WORD COLON! h2:WORD {cv=new ComponentVariable(g2.getText(),h2.getText(),g2.getLine(),g2.getColumn());components.add(cv);})*
(SEMICOLON)?;

protected assembly_variables returns [ArrayList<AssemblyVariable> components=new ArrayList<AssemblyVariable>();]{AssemblyVariable cv=null;}:
(g:WORD COLON! h:WORD {cv=new AssemblyVariable(g.getText(),h.getText(),g.getLine(),g.getColumn());components.add(cv);})
(options {greedy=true;	}:SEMICOLON g2:WORD COLON! h2:WORD {cv=new AssemblyVariable(g2.getText(),h2.getText(),g2.getLine(),g2.getColumn());components.add(cv);})*
(SEMICOLON)?;

protected component_list returns [HashMap map=new HashMap();] {HashMap temp=null;}:
BLOCK_START! (temp=componentoccurrence {map.putAll(temp);})* BLOCK_END!;


//TODO : stop loading component at this point. wait for structure completion to do it.
protected componentoccurrence returns [HashMap map=new HashMap();] {String tempoccurrencename=null,line="";}:
   (g:WORD COLON!{tempoccurrencename=g.getText();line=tempoccurrencename+ " : ";})?f:WORD 
   	 { Component c=null;
   	 String currentFile=componentFactory.getCurrentFile();
   	 try{
   	 if (this.componentFactory!=null) 
   	 	{ 
   	 	//gets the type of the component
   	 	
   	 	c=this.componentFactory.getComponent(f.getText());
   	 	line+=f.getText();
   	 	// if no instancename was given, assign typename and issue warning
   	 	if (tempoccurrencename==null) {tempoccurrencename=f.getText();
   	 		this.componentFactory.getLogger().log( "PLEASE Name the occurrences of components in a composition. Defaulting to typename: "+tempoccurrencename,this.currentComponent,"COMPOSITION WARNING",f.getLine(),f.getColumn(),currentFile);		
//componentFactory.setCurrentFile(currentFile);
  // 	 	System.err.println(" PLEASE Name the occurrences of components in a composition. Defaulting to typename");
   	 	}
   	 	
   	 	}
   	 else {
   	 	System.err.println("THIS USE OF THE PARSER IS DEPRECATED : PLEASE USE A costo.graph.ComponentFactory");
	    String path=	System.getProperty("costo.absspecdir");
	    FileReader file = new FileReader(path+f.getText()+".cmp");
	    AnalyserLex lexer = new AnalyserLex(file);
	    AnalyserSyn parser = new AnalyserSyn(lexer);
	    c=parser.component();
	    line+=f.getText();
   	 }
	 }
	 catch(java.io.FileNotFoundException fe)
	 {	 System.err.println(f.getText()+":"+fe);	 
	 }
	 if (c!=null) map.put(tempoccurrencename,c);
	 tempoccurrencename=null;
	 componentFactory.setCurrentFile(currentFile);
	 } 
 {#componentoccurrence = #(#[COMPONENT_OCCURRENCE,line],componentoccurrence);};


//
services returns [ArrayList<Service> servlist = new ArrayList<Service>()] {Service a,b;}
:s:"SERVICES"^ {nextElem(null,s.getLine());}((b=rp_service) {servlist.add(b);})* es:"END_SERVICES"! {nextElem(null,es.getLine());};

protected a_service returns [Service s=null] :
(s=external_service|s=service)
;
//TODO : integrate relative paths
external_service returns [Service s=null] {String filename;} :
"external" f:WORD
{String currentFile=componentFactory.getCurrentFile();
	try{
	  //String path=	System.getProperty("costo.absspecdir");
//	  FileReader file = new FileReader(path+f.getText()+".srv");
	File thefile=this.componentFactory.findFile(f.getText()+".ksv");
	if (thefile==null) thefile=this.componentFactory.findFile(f.getText()+".srv");
	  FileReader file = new FileReader(thefile);
	  AnalyserLex lexer = new AnalyserLex(file);
	  AnalyserSyn parser = new AnalyserSyn(lexer, this.componentFactory);
	  parser.setCurrentComponent(this.currentComponent);
	  componentFactory.setCurrentFile(thefile.getAbsolutePath());
	  s=parser.service(); 
	}
//	catch(java.io.FileNotFoundException fe)
//bad shortcut !
catch (RecognitionException e) {

			this.componentFactory.getLogger().log(e.getMessage() , this , "FATAL PARSING ERROR" , e.getLine() , e.getColumn() ,
					currentFile);}
	catch(Exception fe)
	{	  //System.err.println(fe);
		this.componentFactory.getLogger().log(" external service "+f.getText()+" not found",this.currentComponent,"RESOLUTION ERROR",f.getLine(),f.getColumn(),currentFile);		}
componentFactory.setCurrentFile(currentFile);};



// integrate this into service 
protected rp_service returns [Service s=null] {boolean isquery=false;}: 
("query" {isquery=true;})?(p:"provided"^ s=a_service {if (s!=null) {s.setProvided(true);s.setQuery(isquery);}} | r:"required"^ s=a_service {if (s!=null) {s.setProvided(false);s.setQuery(isquery);}});


 service returns [Service s = null] 
 {String nom="";CostoType rettype=CostoVoid.instance;
 	ArrayList<String>  propertylist=null; ServiceInterface servinterf=new ServiceInterface(); 
 	HashMap<String,Variable> paramMap=null; 
 	HashMap<String,KmlPredicate> pre=null, post=null, inv=null;
 	HashMap<String,Variable> varmap=new HashMap<String,Variable>(); HashMap<String,Variable> constmap=new HashMap<String,Variable>();
 	HashMap<String, KmlAssignmentExpression> initmap=new HashMap<String, KmlAssignmentExpression>();boolean virtualInv=false, virtualVar=false; 
 	LTS auto=null;   
 	String com="";}: 
    sname:WORD^ {s=new Service(sname.getText(),true);s.setLine(sname.getLine());s.setColumn(sname.getColumn());}(PAR_START(paramMap=decl_variables)? PAR_END)? (rettype=return_type)? 
    (comm:IMP_ML_COMMENT{com=comm.getText();})?
   (servinterf=servinterface)? 
   (propertylist=servpropertiesclause)?
   (("Virtual"{virtualVar=true;})? (options {greedy=true;	}:varmap=servvariablesclause))? // 
   (("Virtual")? (options {greedy=true;	}:"Invariant" inv=properties{}))? // 
   (pre=preclause)?
   (constmap=servconstantsclause{})? 
   (varmap=servvariablesclause {})?
   (initmap=servinitializationclause)?
   (auto=lts)?
   (post=postclause)?
   a:"End"!
   {
            
            s.setComment(com);
            s.setParametersMap(paramMap);
            s.setReturnCostoType(rettype);
            s.setInterface(servinterf);
            s.setProperties(propertylist);
            s.setInvMap(inv);
            s.setPreMap(pre);
            s.setVariables(varmap);
            s.setConstants(constmap);
            s.setInitializations(initmap);
            s.setBehavior(auto);
			s.setPostMap(post);
			s.setLastLine(a.getLine());
			            
        } ;

//
servinterface returns [ServiceInterface inter=new ServiceInterface();]{ArrayList<String> mand=null;ArrayList<String> prov=null; ArrayList<String> calreq=null;ArrayList<String> extreq=null;ArrayList<String> intreq=null;ArrayList<String> recept=null;ArrayList<String> sends=null;}
:a:"Interface"^
(prov=subprovidesclause)? 
(calreq=calrequiresclause)? 
(extreq=extrequiresclause)? 
(intreq=intrequiresclause)?
(recept=receptionsclause)?
(sends=sendingsclause)?
{
{inter.setColumn(a.getColumn());inter.setLine(a.getLine());}
inter.setSubprovided(prov);
inter.setCalrequired(calreq);
inter.setExtrequired(extreq);
inter.setIntrequired(intreq);
inter.setReceptions(recept);
inter.setSendings(sends);
};

protected subprovidesclause returns [ArrayList<String> al=null]:
"subprovides"^ COLON! al=namelist; 
protected calrequiresclause returns [ArrayList<String> al=null]:
"calrequires"^ COLON! al=namelist; 
protected extrequiresclause returns [ArrayList<String> al=null]:
"extrequires"^ COLON! al=namelist; 
protected intrequiresclause returns [ArrayList<String> al=null]:
"intrequires"^ COLON! al=namelist; 
protected receptionsclause returns [ArrayList<String> al=null]:
"receptions"^ COLON! al=namelist; 
protected sendingsclause returns [ArrayList<String> al=null]:
"sendings"^ COLON! al=namelist; 

        
protected preclause returns [HashMap<String,KmlPredicate> al=null]:
 "Pre"^ al=properties;

protected postclause returns [HashMap<String,KmlPredicate> al=null]:
 "Post"^ al=properties;

protected servpropertiesclause returns [ArrayList<String> al=null]:
"Properties"^ al=namelist;        
        
protected servconstantsclause returns [HashMap<String,Variable> al=null] :
"Constants"^ al=decl_constants; 

protected servvariablesclause returns [HashMap<String,Variable> al=null] :
"Variables"^ al=decl_variables; //TODO should include c_code=c.code stuff

protected servinitializationclause returns [HashMap<String, KmlAssignmentExpression> al=null] :
"Initialization"^ al=init_variables; 

//--------------------  TYPES AND VARIABLES
//TODO : reconstruct TREE 
protected init_variables returns [HashMap<String, KmlAssignmentExpression> var=new HashMap<String, KmlAssignmentExpression>()]{KmlExpression exp=null,ident=null;Variable s=null;Variable v1, v2;String sv;} :
ident=identPrimary b:AFFECTE^ exp=expression {var.put(ident.getRawValue(),new KmlAssignmentExpression(ident,exp));}
(options {greedy=true;	}:SEMICOLON! ident=identPrimary d:AFFECTE^ exp=expression {var.put(ident.getRawValue(),new KmlAssignmentExpression(ident,exp));})*
(SEMICOLON!)?;//UGLY 


protected decl_variables_and_rename returns [HashMap<String,Variable> var=new HashMap<String,Variable>()]
 {HashMap<String,Variable> v1=null,v2=null;boolean obs=false;}:
 ("obs" {obs=true;})? v1=decl_variables_untype_or_rename {for(Variable v:v1.values()) {v.setObservable(obs);};var.putAll(v1);} 
  (options {greedy=true;	}:SEMICOLON! {obs=false;} ("obs" {obs=true;})? v2=decl_variables_untype_or_rename {for(Variable v:v2.values()) {v.setObservable(obs);}var.putAll(v2);})* 
  (SEMICOLON!)?;//UGLY 

//TODO -- a revoir : declarations variables --  a,b: Integer  est reconnue comme a:Integer ; b:Integer;  
protected decl_variables_untype_or_rename returns [HashMap<String,Variable> var=new HashMap<String,Variable>()]
{CostoType ct=null;String tname="";KmlExpression exp=null; ArrayList<String> varnames=new ArrayList<String>();Variable v=null;} 
: ( a:WORD {varnames.add(a.getText());}) (options {greedy=true;	}: COMMA^ b:WORD{varnames.add(b.getText());} )* COLON ct=typedef ("from" exp=identPrimary)? 
{for (String s:varnames) {v=(ct!=null?ct.createVariable(s,false):new Variable(s,CostoVoid.instance));if (exp!=null) v.setOrigin(exp.getRawValue());var.put(s,v);} //TODO : erreur si var multiples
};
 
lib_constants returns [HashMap<String,Variable> var] :
"LIBRARY_CONSTANTS" var=decl_constants;

protected decl_constants returns [HashMap<String,Variable> var=new HashMap<String,Variable>()] {Variable v1=null,v2=null;}:
v1=decl_aconstant {var.put(v1.getName(),v1);} 
  (options {greedy=true;	}:SEMICOLON! v2=decl_aconstant {var.put(v2.getName(),v2);})* 
  (SEMICOLON!)?;//UGLY ; 

//changed a_typename to typedef
protected decl_aconstant returns [Variable v =null;] {Variable var;KmlExpression exp=null,value;String s;CostoType ctype=null;boolean obs=false;}
:("obs" {obs=true;})? a:WORD^ COLON! ctype=typedef AFFECTE^ value=expression ("from" exp=identPrimary)?{s=value.getRawValue();v=(ctype!=null?ctype.createVariable(a.getText(),true):new Variable(a.getText(),CostoVoid.instance,true));v.setObservable(obs);v.setExpression(value);if (exp!=null) v.setOrigin(exp.getRawValue());};


protected decl_variables returns [HashMap<String,Variable> var=new HashMap<String,Variable>()]
 {HashMap<String,Variable> v1=null,v2=null;}:
v1=decl_variables_untype {var.putAll(v1);} 
  (options {greedy=true;	}:SEMICOLON! v2=decl_variables_untype {var.putAll(v2);})* 
  (SEMICOLON!)?;//UGLY ; 
 //TODO -- a revoir : declarations variables --  a,b: Integer  est reconnue comme a:Integer ; b:Integer;  
protected decl_variables_untype returns [HashMap<String,Variable> var=new HashMap<String,Variable>()]{CostoType ct=null;String tname="";ArrayList<String> varnames=new ArrayList<String>();boolean obs=false;} 
: ("obs" {obs=true;})? (a:WORD {varnames.add(a.getText());} (options {greedy=true;	}: COMMA^ b:WORD{varnames.add(b.getText());} )*)+ COLON ct=typedef 
{for (String s:varnames) {Variable eachvar=(ct!=null?ct.createVariable(s,false):new Variable(s,CostoVoid.instance));eachvar.setObservable(obs);var.put(s,eachvar);}};
 

//------------------------------ TYPES ---------------

// FIXME : if @, then different syntax -- then try again
decl_kml_types {CostoType a,b;KmlExpression jclass=null;} :
"KMLTYPE" (AT jclass=identPrimary {this.currentComponent.addType(CostoType.getNewCostoType(jclass));}| a=a_type ){}  
(options{greedy=true;}:"KMLTYPE" (AT jclass=identPrimary {this.currentComponent.addType(CostoType.getNewCostoType(jclass));}| b=a_type ))*; 


protected decl_types  {CostoType a,b;} :
a=a_type  
(options{greedy=true;}:SEMICOLON! b=a_type )*
(options{greedy=true;}:SEMICOLON!)?;//UGLY ; ;

protected a_type returns [CostoType typ=null;] {CostoType recup=null;} 
:a:WORD^ COLON! COLON! recup=typedef {typ=recup; if (typ!=null) { if (typ.isPrimitive()) 
	typ=new RenamedType(a.getText(),typ);else typ.setName(a.getText());this.currentComponent.addType(typ);}else {System.err.println("typ=null"+a.getText());}};



protected typedef returns [CostoType ct=null]  :
	( ct=a_typename  // primitif ou nouveau type
          | 
          ct=a_struct // "struct"^ BLOCK_START^ decl_variables BLOCK_END! // struct
          |
          ct=an_array// "array"^ BRACKET_START! INTEGER ".."! INTEGER BRACKET_END! "of"! a_typename// tableau
          |
          ct=an_enum// "enum"^ namelist 
          | 
          ct=a_range// "range"^ INTEGER ".."! INTEGER
          |
          ct=a_set)// "setOf "^ a_typename
          
;


protected a_struct returns [CostoType ct=null]
{StructuredType st=new StructuredType(); HashMap<String,Variable> fields=null;} :
"struct"^ BLOCK_START! fields=decl_variables {st.setVarAsFields(fields);ct=st;} BLOCK_END!;


protected an_array returns [CostoType ct=null]
{CostoArray ca=new CostoArray();String s=null;String sa="";String sb="";CostoType type=null;CostoRange rn=null;} :
"array"^ BRACKET_START! (rn=range|type=a_typename{if(type instanceof CostoRange) rn=(CostoRange)type; else rn=CostoRange.instance;})
BRACKET_END! "of"! type=a_typename 
{ca.setReftype(type);ca.setRange(rn);ct=ca;};

protected an_enum returns [CostoType ct=null] {ArrayList<String> lenum=null;} :
"enum"^  lenum=namelist {ct=new CostoEnum(lenum);};

//FIXME : should accept constants 
protected a_range returns [CostoRange ct=null] :
"range"^ ct=range;   

//added empty range 
protected range returns [CostoRange ct=new CostoRange()] {String sa="";String sb="";KmlIdentifier inf=null, sup=null;} :
(options {greedy=true;}:(a:NUMBER {ct.setBorneInf(a.getText());}|inf=identPrimary{ct.setLowerBound(inf);}) PERIOD!PERIOD! (b:NUMBER {ct.setBorneSup(b.getText());}|sup=identPrimary{ct.setUpperBound(sup);}))
|{ct=CostoRange.instance;} 
;


protected a_set returns [CostoType ct=null] {String s=null;CostoType type=null;} :
"setOf"^ type=a_typename {ct=new CostoSet(type);};

//FIXME :  a type coming from a subcomponent cannot be resolved
protected a_typename returns [CostoType type=null]{String typename=null;} :
 (  
  //  "Integer" {type=costo.graph.types.CostoInteger.instance;} 
 //|  "Boolean" {type=costo.graph.types.CostoBoolean.instance;}
 //|  "String" {type=costo.graph.types.CostoString.instance;}
 //|  "Char" {type=costo.graph.types.CostoChar.instance;}
 //|
 w:WORD {typename=w.getText();type =this.currentComponent.resolveType(typename);
 	if (type==null) {this.componentFactory.getLogger().log(" TYPE "+w.getText()+" not found",this.currentComponent,"TYPE ERROR",w.getLine(),w.getColumn(),this.componentFactory.getCurrentFile());type=CostoUnknownType.instance;
 	//System.err.println(" TYPE "+w.getText()+" not found in "+w.getLine()+ " "+w.getColumn() +this.componentFactory.getCurrentFile()+" looking for resolution in "+this.currentComponent.getName());
 	}	
 	} );
 

// --------------------------------------  FIN  TYPES
// --------------------------------------  FUNCTIONS  -- 

decl_kml_functions {ArrayList<KmlSignature> sigs=new ArrayList<KmlSignature>();KmlSignature fun;}:
(sigs=decl_a_kml_function {for(KmlSignature sig:sigs) this.currentComponent.addFunction(sig);}
|fun=decl_new_kml_function {this.currentComponent.addFunction(fun);})*;
//TODO : add pre post , create sig correctly, add to decl_kml_function as alternative
protected decl_new_kml_function returns [KmlFunction func=null]{HashMap<String,Variable> paramMap= null;CostoType rettype=null;HashMap<String,KmlPredicate> pre=null, post=null;}
: sname:WORD^ {func=new KmlFunction(sname.getText(),CostoVoid.instance);func.setLine(sname.getLine());func.setColumn(sname.getColumn());}
(PAR_START(paramMap=decl_variables {func.setFunctionParameters(paramMap);})? PAR_END)? (rettype=return_type{func.setType(rettype);})?
 (pre=preclause{func.setPres(pre);})? (post=postclause{func.setPosts(post);})?;

protected decl_a_kml_function returns [ArrayList<KmlSignature> sigs=new ArrayList<KmlSignature>();]{String s=null;ArrayList<CostoType> paramList=null;ArrayList<String> names=new ArrayList<String>();CostoType rettype=null;} :
"FUNCTION"  sname1:WORD {names.add(sname1.getText());} (options{greedy=true;}:COMMA sname2:WORD {names.add(sname2.getText());} )* 
COLON (options{greedy=true;}: (paramList=typelist )?)  "-" (">"|GT)  (rettype=typedef)? PERIOD
{for (String name:names) sigs.add(new KmlSignature(name,paramList,rettype));};

protected typelist returns [ArrayList<CostoType> list = new ArrayList<CostoType>()] {CostoType ct1,ct2;}:
 ct1=typedef {list.add(ct1);} (options{greedy=true;}:SEMICOLON ct2=typedef {list.add(ct2);})* ;

 // ----------------------------Start of the LTS ---------------------------------- 
protected initial_state returns [State n = null] : "Init"^ n=state ;//SEMICOLON;


final_states returns [ArrayList<State> al= new ArrayList<State>()] {State n1,n2;} :
"Final"^ al =statelist ;

protected statelist returns [ArrayList<State> al= new ArrayList<State>()] {State n1,n2;} :
 n1=state {al.add(n1);} (COMMA! n2=state {al.add(n2);})*;// SEMICOLON;

// D'origine
protected state returns [State n = null] : s:WORD^ { n = new State(s.getText()); };


lts returns [LTS auto=null;] {HashMap<String,Object> map; State init; ArrayList<State> al;}
: "Behavior"^ init=initial_state al=final_states BLOCK_START!  map=lignes_lts BLOCK_END! {
            auto=new LTS();
            auto.addTransitions((ArrayList<Transition>) map.get("transition"));
            auto.addStates((ArrayList<State>) map.get("state"));
            auto.setInitialState(init);
            auto.setFinalStates(al);
            auto.chainIncoming();
          //
        //  auto.initializeBrowzing();
            
        };  




protected lignes_lts returns [HashMap map = new HashMap()] 
{  ArrayList<State> nd=new ArrayList<State>(); ArrayList<Transition> tr=new ArrayList<Transition>(); Transition a1,a2; State n1,n2;}:
 (n1=state_line  {nd.add(n1);}|a1=transition_line {tr.add(a1);}) 
 (options{greedy=true;}:COMMA! (n2=state_line {nd.add(n2);}|a2=transition_line {tr.add(a2);}))* 
 {
 	map.put("state",nd); 
 	map.put("transition", tr);

 	
 };
 


                    
 //GAx
protected  state_line  returns [State n=null;] {ArrayList<ServiceHook> al;} :
 n=state (al=callable_service_list {n.setService(al);})?
 {#state_line=#(#[BRANCHING_STATE,n.getName()],state_line);};
 
 
//GA TODO shouldn't create state that early. should just pass strings and let the implementation of LTS decide later with a factory-like method
 protected transition_line returns [Transition a=null;] {State n1=null,n2=null; Label e;String s="";}:
 n1= state ARROW_START! e=label ARROW_END! n2=state { a = new Transition(n1,n2,e); s=n1.getName()+"--"+n2.getName();}
 {#transition_line =#(#[TRANSITION,s],transition_line);};
 





//-------------############---------- GRAMMAIRE DES EXPRESSIONS -------------############---------- 


protected primaryExpression returns [KmlExpression expr=null;]{ KmlExpression indx=null;ArrayList<KmlExpression> al=null;}
	:	expr=identPrimary  (options{greedy=true;}:al=arg_list {expr=new KmlFunctionCall(expr,al);}(PERIOD indx=primaryExpression {expr=new NavigateExpression(expr,indx);})?)? 	(options{greedy=true;}:indx=array_index {expr= new KmlArrayExpression(expr,indx);} (PERIOD indx=primaryExpression {expr=new NavigateExpression(expr,indx);})? )?  
	|	expr=constant
	|	"true" {expr=new KmlConstant(costo.graph.types.CostoBoolean.instance,"true");}
	|	"false" {expr=new KmlConstant(costo.graph.types.CostoBoolean.instance,"false");}
	|	PAR_START! expr=conditionalExpression PAR_END!  {expr=new KmlParOp(expr,"(",")");}
	
	;

// FIXME : add access expression to navigate after primary with a PERIOD  (either for a struct or a fun call)
// FIXME : arrays index of arrays index too
/** Match a, a.b.c 
 */
protected identPrimary returns [KmlIdentifier expr=new KmlIdentifier()]{ String s="";String next="";}

	:	i:WORD {s=i.getText();} (options {greedy=true;}: PERIOD n:WORD {s+="."+n.getText();})*
	{expr.setRawValue(s);expr.setColumn(i.getColumn());expr.setLine(i.getLine());}; 


protected array_index returns [KmlExpression exp=null;]{KmlExpression right=null;Label l=null;}// single dimension
: b:BRACKET_START! exp=expression BRACKET_END! {exp.setColumn(b.getColumn());exp.setLine(b.getLine());}
{#array_index = #(#[ELIST,exp.getRawValue()],#array_index);};

protected simple_arg_list returns [ArrayList<KmlExpression> ar=null]
	:	PAR_START(	ar=simple_args
		|	/*nothing*/
			//{#simple_arg = #[ELIST,"ELIST"];}
		)PAR_END 
	;
protected simple_args returns [ArrayList<KmlExpression> al=new ArrayList<KmlExpression>();]{KmlExpression expr=null, next=null;}
: expr=primaryExpression {al.add(expr);}(options {greedy=true;	}: COMMA next=primaryExpression {al.add(expr);} )* ;

protected arg_list returns [ArrayList<KmlExpression> al=null]
	:	PAR_START 	(options{greedy=true;}:al=expressionList)? PAR_END 
			{#arg_list = #(#[ELIST,Spec.listToString(al, "(",",",")")],#arg_list);}
		;
	
	// EXPRESSIONS
	
// the mother of all expressions
protected expression returns[KmlExpression exp=new KmlExpression("unknown");]
	:	exp=assignmentExpression
		{#expression = #(#[EXPR,"exp"],#expression);}
	;


// This is a list of expressions.
protected expressionList returns[ArrayList<KmlExpression> al=new ArrayList<KmlExpression>();]{KmlExpression expr=null, next=null;}
	:	expr=expression {al.add(expr);}(options {greedy=true;	}: COMMA next=expression {al.add(next);} )* 
	//exp=expression (COMMA! next=expression {pe+=", "+next;})*
		{#expressionList = #(#[ELIST,Spec.listToString(al, "",",","")], expressionList);}
	;



protected assignmentExpression returns[KmlExpression exp=null;]{KmlExpression right=null;Label l=null;}
	:	exp=conditionalExpression 
		(	AFFECTE^
			(l=communicationbis{ ((KmlCommunication)l.getExpression()).setSynchronous(true);exp=new KmlAssignmentExpression(exp,l.getExpression());} 
			|right=conditionalExpression {exp=new KmlAssignmentExpression(exp,right);} )
		)?
	; 


// conditional test 
protected conditionalExpression returns[KmlExpression exp=null;]
	: //PAR_START exp=logicalImpliesExpression PAR_END
	//|
		exp=logicalImpliesExpression	|exp= forallpredicate |exp = existspredicate|exp=unchangedpredicate
	;
// logical implies
protected logicalImpliesExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=logicalEquivExpression (options {greedy=true;	}: "implies"^ right=conditionalExpression{exp=new KmlBinOP(exp,right,"implies");})*
	;

protected logicalEquivExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=logicalXorExpression (options {greedy=true;	}: "equiv"^ right=conditionalExpression{exp=new KmlBinOP(exp,right,"equiv");})*
	;

// logical xor () 
protected logicalXorExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=logicalOrExpression (options {greedy=true;	}: "xor"^ right=conditionalExpression{exp=new KmlBinOP(exp,right,"xor");})*
	;


// logical or (||) 
protected logicalOrExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=logicalAndExpression (options {greedy=true;	}: (LOR^|"or"^) right=conditionalExpression{exp=new KmlBinOP(exp,right,"or");})*
	;


// logical and (&&)  
protected logicalAndExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=equalityExpression (options {greedy=true;	}:  (LAND^|"and"^) right=conditionalExpression{exp=new KmlBinOP(exp,right,"and");})*
	;


// equality/inequality (=/<>) 
protected equalityExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=relationalExpression (options {greedy=true;	}: (DIFF^{op="<>";}|  EQUAL^{op="=";}) right=relationalExpression{exp=new KmlBinOP(exp,right,op);})*
	;


// boolean relational expressions 
protected relationalExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=additiveExpression
			(options {greedy=true;	}: 	(	"<"^ {op="<";}
				|	">"^ {op=">";}
				|	LE^ {op="<=";}
				|	GE^ {op=">=";}
				|	"="^ {op="=";}//redondant
				|	"<>"^ {op="<>";}//redondant
				|	"in"^ {op="in";}
				)
				right =additiveExpression {exp=new KmlBinOP(exp,right,op);}
			)*
		
		
	;



//TODO add mod (modulo) and  in (sets)
// binary addition/subtraction (level 3)
protected additiveExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=multiplicativeExpression ((PLUS^{op="+";} | ("-"|MINUS){op="-";}) right=multiplicativeExpression{exp=new KmlBinOP(exp,right,op);})*
	;


// multiplication/division/modulo (level 2) 
protected multiplicativeExpression returns[KmlExpression exp=null;]{KmlExpression right=null;String op="";}
	:	exp=unaryExpression ((MULT^ {op="*";}| DIV^ {op="/";}  ) right=unaryExpression{exp=new KmlBinOP(exp,right,op);})*
	;

protected unaryExpression returns[KmlExpression exp=null]
	:	MINUS^ {#MINUS.setType(UNARY_MINUS);} exp=unaryExpression {exp=new KmlUnaryOp("-",true,exp);}
	|	PLUS^ {#PLUS.setType(UNARY_PLUS);} exp=unaryExpression {exp=new KmlUnaryOp("+",true,exp);}
	|	exp=unaryExpressionNotPlusMinus
	;

protected unaryExpressionNotPlusMinus returns[KmlExpression exp=null]
	:	LNOT^ exp=unaryExpression {exp=new KmlUnaryOp("~",true,exp);}
	|	EXCLAM_MARK^ exp=unaryExpression {exp=new KmlUnaryOp("!",true,exp);}
	|	"not"^ exp=unaryExpression {exp=new KmlUnaryOp("not",true,exp);}
	|	exp=postfixExpression
	;

// qualified names, array expressions, method invocation, post inc/dec
protected postfixExpression returns[KmlExpression exp=null]{String pe="";}
	:
		exp=primaryExpression
//no blocks yet !
		//|(	lb:LBRACK^ {#lb.setType(INDEX_OP);} expression RBRACK!
		//)*

		(	// possibly add on a post-increment or post-decrement.
			// allows INC/DEC on too much, but semantics can check
			in:INCR^ {exp=new KmlUnaryOp("++",false,exp);}{#in.setType(POST_INC);}
	 	|	de:ARROW_START^ {exp=new KmlUnaryOp("--",false,exp);}{#de.setType(POST_DEC);}
		)?
 	;
	

	
protected constant returns [KmlExpression exp=null]{;String cst="";}
	:	n:NUMBER {cst=n.getText();exp=new KmlConstant(costo.graph.types.CostoInteger.instance,cst);exp.setColumn(n.getColumn());exp.setLine(n.getLine());}
	|	c:CHAR_LITERAL {cst=c.getText();exp=new KmlConstant(costo.graph.types.CostoChar.instance,cst);exp.setColumn(c.getColumn());exp.setLine(c.getLine());}
	|	s:STRING_LITERAL {cst=s.getText();exp=new KmlConstant(costo.graph.types.CostoString.instance,cst);exp.setColumn(s.getColumn());exp.setLine(s.getLine());}
	| exp=arrayInitializer
//	| exp=structInitializer
	;


protected arrayInitializer returns [KmlArrayInitializer exp=new KmlArrayInitializer();]{ArrayList<KmlExpression> values=null;String cst="";}
 :  "newArray" BLOCK_START values=expressionList BLOCK_END {exp.setExpressions(values);};
 
 protected structInitializer returns [KmlExpression exp=null]{ArrayList<KmlExpression> values=null;String cst="";}
 : "newStruct" BLOCK_START values=expressionList BLOCK_END{};
 
//---------------------  PREDICATS 



protected properties returns [HashMap<String,KmlPredicate> prop=new HashMap<String,KmlPredicate>()] {HashMap a,b;}:
 a= property {prop.putAll(a);}
 (options {greedy=true;	}:COMMA! b=property {prop.putAll(b);})* ;


protected property returns [HashMap<String,KmlPredicate> p=new HashMap<String,KmlPredicate>();] {String s="anonymous"+Spec.getIndex();KmlPredicate pred=null;boolean obs=false,local=false;}
:("obs"{obs=true;}|"local"{local=true;})?(AT a:WORD{s=a.getText();} )? (COLON)? pred =predicate {pred.setObservable(obs);pred.setLocal(local);p.put(s,pred);};

// definition of service properties
protected servproperties returns [HashMap<String,String> sprops=new HashMap<String,String>()] 
:name:WORD COLON pred:WORD {sprops.put(name.getText(),pred.getText());}
(options {greedy=true;	}:COMMA name2:WORD COLON pred2:WORD {sprops.put(name2.getText(),pred2.getText());})* ;



protected return_type returns [CostoType typ=null]: COLON! typ=typedef ;

//FIXME : should only have conditional expressions ? 
protected predicate returns [KmlPredicate p= null] {KmlExpression exp=null;HashMap<String,Variable> forall=null, exists=null;} :
  ("forall" forall=decl_variables) ? ("exists" exists=decl_variables) ? (PIPE)? exp=expression {p=new KmlPredicate("",forall,exists,exp);};

protected forallpredicate returns [KmlPredicate p= null] {KmlExpression exp=null;HashMap<String,Variable> forall=null, exists=null;} :
 "forall" forall=decl_variables ("exists" exists=decl_variables) ? PIPE exp=conditionalExpression {p=new KmlPredicate("",forall,exists,exp);};

protected existspredicate returns [KmlPredicate p= null] {KmlExpression exp=null;HashMap<String,Variable> forall=null, exists=null;} :
 "exists" exists=decl_variables PIPE exp=conditionalExpression {p=new KmlPredicate("",forall,exists,exp);};

protected unchangedpredicate returns [KmlUnchangedExpression p= null] {ArrayList<KmlIdentifier> vars=new ArrayList<KmlIdentifier>();KmlIdentifier var1=null,var2=null;}:
  "Unchanged" b:BLOCK_START! var1=identPrimary {vars.add(var1);} (COMMA! var2=identPrimary {vars.add(var2);})* BLOCK_END! 
 {p=new KmlUnchangedExpression(vars);p.setLine(b.getLine());p.setColumn(b.getColumn());};

//--------------------  COMMANDES


//FIXME - warning bizarre ....
protected label returns [Label e=null] {KmlCondition g=null; KmlExpression expr=null;String raw="";} 
: (options{greedy=true;}:g=guard)? e=command {e.setGuard(g);}
//PIPE g=string PIPE {raw =g; e= new ExtLanguageLabel(g); }  // later or never
//|
//| c1:PORT "<" "|" ">" c2:PORT  {raw = c1.getText()+"<|>" +c2.getText();e = new PipeOperatorLabel(new PipeOperator(c1.getText(),c2.getText()));}
 {#label =#(#[LABEL,raw],label);}; 

protected guard returns [KmlCondition c=null]{KmlExpression expr=null;}
 :BRACKET_START! expr=expression BRACKET_END!{c=new KmlCondition(expr);}
 {#guard =#(#[LABEL,c.asGuard()],guard);}
 ;
//  -----------------------------  CE qu'il y a dans les labels ---------------------------
protected command returns [Label e=new Label();] {KmlExpression expr=null;} :
  (e=communicationbis |expr=expression {e=new Label(expr);} |e=ablock|expr=mandatoryCallExpression{e=new Label(expr);}|expr=conditionalAction{e=new Label(expr);}|expr=whileAction{e=new Label(expr);}|"nop" {expr=new KmlNopExpression();})// |expr=lockReleaseExpression{e=new Label(expr);} ) 
   
 ; 
protected lockReleaseExpression returns[KmlExpression e=null]// ch	nge into LockOrRelease Expression :
: ("Lock" |"Release")  // { x, y+}, ou rien pour release
;

//FIXME : should contain commands transformed into expressions
protected conditionalAction returns [KmlIfExpression ifexp=null;] {KmlExpression expcond=null,expthen=null,expelse=null;Label commandsthen=null,commandselse=null;}
: "if" expcond=conditionalExpression "then" commandsthen=command ("else" commandselse =command)? "endif" {ifexp=new KmlIfExpression(expcond,(commandsthen!=null?commandsthen.getExpression():null),(commandselse!=null?commandselse.getExpression():null));};


protected whileAction returns [KmlWhileExpression whileexp=null;] {KmlExpression expcond=null,expthen=null;Label commands=null;}
: "while" expcond=conditionalExpression "do" commands=command  "endwhile" {whileexp=new KmlWhileExpression(expcond,(commands!=null?commands.getExpression():null));};

//SwitchAction :: "case" KmlExpression "in" ValueExpressionLIST "esac"

protected ablock returns [Label e=new Label()] {KmlCompositeExpression composite=new KmlCompositeExpression(";"); Label e1,e2; } :
//TODO : allow use of parallel, currently just semicolon for sequential 
BLOCK_START! e1=command {composite.add(e1.getExpression());e.setExpression(composite);} (options{greedy=true;}:(a:SEMICOLON!|b:COMMA {composite.setOperatorType(b.getText());}) e2=command {composite.add(e2.getExpression());})* BLOCK_END; 


//--- Communication 


protected communicationbis returns [Label e=new Label()] {KmlCommunication comm=null;InterlocutorSet inter =null;} :
    inter=interlocutorSet (comm=servicecall){comm.setInterlocutorSet(inter);e.setExpression(comm);};


//  channel (:role)? ([selector])? 
protected interlocutorSet returns [InterlocutorSet inter= new InterlocutorSet();] {String selectorstring="";String chan="";}
:u:UNDER chan=port {inter.setChannel("_"+chan);}(COLON! w:WORD  {inter.setRole(w.getText());})? 
(BRACKET_START! selectorstring=selector BRACKET_END!{inter.setMultiplicity(selectorstring);})? {inter.setLine(u.getLine());inter.setColumn(u.getColumn());}

{#interlocutorSet=#[INTERLOCUTORSET,inter.toString()];};
 
 protected port returns [String s] :(UNDER "SELF"{s="_SELF";}|UNDER "CALLER"{s="_CALLER";}|w:WORD{s=w.getText();});
 
 //TODO : filter more  ALL :i  number
protected selector  returns [String select="";]
:(c:COLON {select=c.getText();})? w:WORD {select+=w.getText();}
|n:NUMBER {select+=n.getText();}
;


protected mandatoryCallExpression returns [KmlMandatoryCall exp=null]{InterlocutorSet inter=new InterlocutorSet();inter.setChannel("__CALLER"); String service=null;}:
 BRACKET_START!BRACKET_START! (inter=interlocutorSet PERIOD)? service=name BRACKET_END! BRACKET_END! {exp = new KmlMandatoryCall(inter,service);};

protected servicecall returns [KmlCommunication comm=null] {ArrayList<KmlExpression> params=null;String action="";InterlocutorSet inter=new InterlocutorSet();inter.setChannel("__CALLER");} :
   (a:DB_EXCLAM_MARK{action=a.getText();}|b:EXCLAM_MARK{action=b.getText();}|c:DB_QUESTION_MARK{action=c.getText();}|d:QUESTION_MARK{action=d.getText();}) m:WORD (PAR_START(params=expressionList)?PAR_END)? {comm=new KmlCommunication(inter,action,m.getText(),params);}
   ;

// TODO : retravailler les service hooks
//
protected callable_service_list returns [ArrayList<ServiceHook> al = new ArrayList<ServiceHook>()] {ServiceHookType sht=ServiceHookType.SUBSERVICE;String s="",s1="",s2=""; ServiceHook serv1,serv2;InterlocutorSet inter=new InterlocutorSet();inter.setChannel("__CALLER");} : 
"<"! ((p:PIPE! { sht=ServiceHookType.OPTSUBSERVICE;})|("<"!) )
(inter=interlocutorSet //PERIOD! 
)?(
 a:WORD^ { 	serv1=new ServiceHook(a.getText(),sht);	if  (inter.getChannel()!=null) serv1.setInterlocutorSet(inter);
 	al.add(serv1);serv1.setLine(a.getLine());serv1.setColumn(a.getColumn());}
 	|   BLOCK_START
   c:WORD^ {serv1=new ServiceHook(c.getText(),sht);	if (inter.getChannel()!=null) serv1.setInterlocutorSet(inter);
 	al.add(serv1);serv1.setLine(c.getLine());serv1.setColumn(c.getColumn());} 
   (COMMA !  b:WORD^ {serv2=new ServiceHook(b.getText(),sht);	if (inter.getChannel()!=null) serv2.setInterlocutorSet(inter);al.add(serv2);	serv2.setLine(b.getLine());serv2.setColumn(b.getColumn());}
      	)* 
    BLOCK_END)
      	((p2:PIPE!)|">"!) ">"!;



// ------  VRAC


////{#namelist =#(#[NAMELIST,""],namelist);
protected namelist returns [ArrayList<String> list=new ArrayList<String>()] {String s1="",s2="";}:w:BLOCK_START! s1=name {list.add(s1);} (COMMA! s2=name {list.add(s2);})* BLOCK_END! 
{if (new HashSet<String>(list).size()!=list.size()) this.componentFactory.getLogger().log(" Duplicate name in",this.currentComponent,"RESOLUTION WARNING",w.getLine(),w.getColumn(),this.componentFactory.getCurrentFile());} ;
protected name returns [String s="";]{}:a:WORD^ {s=a.getText();};

