/*
 * Decompiled with CFR 0.152.
 */
package costo.kml2java.monitor.gui.basecomponents;

import costo.kml2java.framework.ExecutableLTS;
import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.ServiceEvolutionListener;
import costo.kml2java.framework.exceptions.ServiceException;
import costo.kml2java.monitor.gui.basecomponents.MyLink;
import costo.kml2java.monitor.gui.basecomponents.MyNode;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.collections15.Transformer;

public class JExecutableServicePanel
extends JPanel
implements ServiceEvolutionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final Map<String, MyNode> NODES = new HashMap<String, MyNode>();
    private final Map<String, MyLink> LINKS = new HashMap<String, MyLink>();
    private Graph<MyNode, MyLink> graph;
    private Layout<MyNode, MyLink> layout;
    private VisualizationViewer<MyNode, MyLink> visuserver;
    private JTextArea servicestate;
    private JTextArea ta;
    private IProvidedService serv;
    private JButton start;
    private JButton reset;

    public JExecutableServicePanel(IProvidedService serv) {
        this.serv = serv;
        this.serv.addServiceListener((ServiceEvolutionListener)this);
        this.graph = new SparseMultigraph();
        this.createGraphFromLTS(serv.getLTS());
        this.init();
    }

    public void createGraphFromLTS(ExecutableLTS lts) {
        if (lts == null) {
            this.createVoidGraph();
            return;
        }
        for (String string : lts.getOutGoing().keySet()) {
            MyNode n = new MyNode(string);
            this.graph.addVertex((Object)n);
            this.NODES.put(string, n);
        }
        for (Map.Entry entry : lts.getTransitionLabels().entrySet()) {
            String[] tab = ((String)entry.getKey()).split("___");
            MyLink ln = new MyLink((String)entry.getKey());
            ln.setLabel((String)entry.getValue());
            this.graph.addEdge((Object)ln, (Object)this.NODES.get(tab[0]), (Object)this.NODES.get(tab[1]), EdgeType.DIRECTED);
            this.LINKS.put((String)entry.getKey(), ln);
        }
    }

    private void createVoidGraph() {
        MyNode n = new MyNode("no");
        this.graph.addVertex((Object)n);
        this.NODES.put("no", n);
        MyLink ln = new MyLink("no_no");
        ln.setLabel("nop");
        this.graph.addEdge((Object)ln, (Object)n, (Object)n, EdgeType.DIRECTED);
        this.LINKS.put("no_no", ln);
    }

    public void init() {
        this.start = new JButton("start");
        this.start.addActionListener(this);
        this.reset = new JButton("reset");
        this.reset.addActionListener(this);
        this.layout = new ISOMLayout(this.graph);
        this.layout.setSize(new Dimension(300, 300));
        this.visuserver = new VisualizationViewer(this.layout);
        this.visuserver.setPreferredSize(new Dimension(350, 350));
        Transformer<MyNode, Paint> nodecolor = new Transformer<MyNode, Paint>(){

            public Paint transform(MyNode arg0) {
                if (arg0.isSelected()) {
                    return Color.RED;
                }
                return Color.GREEN;
            }
        };
        Transformer<MyLink, Paint> edgecolor = new Transformer<MyLink, Paint>(){

            public Paint transform(MyLink arg0) {
                if (arg0.isSelected()) {
                    return Color.RED;
                }
                return Color.GREEN;
            }
        };
        float[] dash = new float[]{10.0f};
        final BasicStroke edgeStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        Transformer<MyLink, Stroke> edgeStrokeTransformer = new Transformer<MyLink, Stroke>(){

            public Stroke transform(MyLink s) {
                return edgeStroke;
            }
        };
        Transformer<MyLink, String> edgeLabelTransformer = new Transformer<MyLink, String>(){

            public String transform(MyLink arg0) {
                return arg0.isSelected() ? arg0.getLabel() : arg0.getName();
            }
        };
        this.visuserver.getRenderContext().setEdgeDrawPaintTransformer((Transformer)edgecolor);
        this.visuserver.getRenderContext().setVertexDrawPaintTransformer((Transformer)nodecolor);
        this.visuserver.getRenderContext().setVertexFillPaintTransformer((Transformer)nodecolor);
        this.visuserver.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.visuserver.getRenderContext().setEdgeLabelTransformer((Transformer)edgeLabelTransformer);
        this.visuserver.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        this.visuserver.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        this.visuserver.addKeyListener(gm.getModeKeyListener());
        this.setLayout(new BorderLayout());
        this.ta = new JTextArea("", 15, 100);
        JScrollPane p = new JScrollPane(this.ta);
        p.setPreferredSize(new Dimension(500, 100));
        this.add((Component)p, "South");
        this.servicestate = new JTextArea(String.valueOf(this.serv.toString()) + "   \n \n                     ");
        this.add((Component)this.servicestate, "North");
        this.setPreferredSize(new Dimension(800, 800));
        this.add((Component)this.visuserver, "Center");
    }

    public IProvidedService getServ() {
        return this.serv;
    }

    public void transitionFired(String tname, String currentState, IService serv, String log, Exception ex) {
        this.ta.append("\n" + log);
        if (ex != null) {
            this.ta.append("Erreur: " + ex.getMessage());
        }
        this.ta.revalidate();
        this.servicestate.setText(serv.toString());
        this.visuserver.getModel().getRelaxer().pause();
        for (MyNode node : this.NODES.values()) {
            node.setSelected(false);
        }
        this.NODES.get(currentState).setSelected(true);
        for (MyLink ln : this.LINKS.values()) {
            ln.setSelected(false);
        }
        MyLink selectedln = this.LINKS.get(tname);
        if (selectedln != null) {
            selectedln.setSelected(true);
        }
        this.visuserver.getModel().getRelaxer().resume();
        this.visuserver.repaint();
        if (((IProvidedService)serv).getLTS().finalStateReached() && !serv.isPostConditionSatisfied().booleanValue()) {
            new JDialog(null, String.valueOf(serv.getName()) + " post condition  violated");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.start) {
            try {
                this.serv.start();
            }
            catch (ServiceException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.reset) {
            this.ta.setText("");
            this.serv.reset();
        }
        if (e.getActionCommand().equals("blocking_calls")) {
            this.serv.setBlockingCalls(true);
        }
        if (e.getActionCommand().equals("non_blocking_calls")) {
            this.serv.setBlockingCalls(false);
        }
    }
}

