/*
 * Decompiled with CFR 0.152.
 */
package attic;

import costo.kml2java.framework.ExecutableLTS;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.ProvidedService;
import costo.kml2java.framework.ServiceEvolutionListener;
import costo.kml2java.monitor.gui.basecomponents.MyLink;
import costo.kml2java.monitor.gui.basecomponents.MyNode;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.collections15.Transformer;

public class CopyOfSimpleTest
implements ServiceEvolutionListener {
    private final Map<String, MyNode> NODES = new HashMap<String, MyNode>();
    private final Map<String, MyLink> LINKS = new HashMap<String, MyLink>();
    private Graph<MyNode, MyLink> graph;
    private Layout<MyNode, MyLink> layout;
    private BasicVisualizationServer<MyNode, MyLink> visuserver;
    private String ltsfile;
    private JTextArea ta;
    private JFrame frame;
    private JPanel graphArea;
    private Map<ProvidedService, Graph<MyNode, MyLink>> graphs = new HashMap<ProvidedService, Graph<MyNode, MyLink>>();

    public CopyOfSimpleTest(String ltsfile) {
        this.ltsfile = ltsfile;
        try {
            this.graph = this.createGraphFromFile(ltsfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CopyOfSimpleTest(ExecutableLTS lts) {
        this.graph = new SparseMultigraph();
        this.createGraphFromLTS(lts);
    }

    public void createGraphFromLTS(ExecutableLTS lts) {
        SparseMultigraph graph = new SparseMultigraph();
        for (String string : lts.getOutGoing().keySet()) {
            MyNode n = new MyNode(string);
            graph.addVertex((Object)n);
            this.NODES.put(string, n);
        }
        for (Map.Entry entry : lts.getTransitionLabels().entrySet()) {
            String[] tab = ((String)entry.getKey()).split("___");
            MyLink ln = new MyLink((String)entry.getKey());
            ln.setLabel((String)entry.getValue());
            graph.addEdge((Object)ln, (Object)this.NODES.get(tab[0]), (Object)this.NODES.get(tab[1]), EdgeType.DIRECTED);
            this.LINKS.put((String)entry.getKey(), ln);
        }
    }

    public Graph<MyNode, MyLink> createGraphFromFile(String filepath) throws IOException {
        SparseMultigraph g = new SparseMultigraph();
        BufferedReader read = new BufferedReader(new FileReader(filepath));
        String line = null;
        while ((line = read.readLine()) != null) {
            String[] tab = line.split(" ");
            if (tab[0].equals("state")) {
                MyNode n = new MyNode(tab[1]);
                g.addVertex((Object)n);
                this.NODES.put(tab[1], n);
                continue;
            }
            if (!tab[0].equals("transition")) continue;
            MyLink ln = new MyLink(tab[1]);
            g.addEdge((Object)ln, (Object)this.NODES.get(tab[2]), (Object)this.NODES.get(tab[3]), EdgeType.DIRECTED);
            this.LINKS.put(tab[1], ln);
        }
        return g;
    }

    public static void main(String[] args) throws IOException {
    }

    public void display() {
        this.layout = new ISOMLayout(this.graph);
        this.layout.setSize(new Dimension(500, 500));
        this.visuserver = new BasicVisualizationServer(this.layout);
        this.visuserver.setPreferredSize(new Dimension(550, 550));
        Transformer<MyNode, Paint> nodecolor = new Transformer<MyNode, Paint>(){

            public Paint transform(MyNode arg0) {
                if (arg0.isSelected()) {
                    return Color.RED;
                }
                return Color.GREEN;
            }
        };
        Transformer<MyLink, Paint> edgecolor = new Transformer<MyLink, Paint>(){

            public Paint transform(MyLink arg0) {
                if (arg0.isSelected()) {
                    return Color.RED;
                }
                return Color.GREEN;
            }
        };
        float[] dash = new float[]{10.0f};
        final BasicStroke edgeStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        Transformer<MyLink, Stroke> edgeStrokeTransformer = new Transformer<MyLink, Stroke>(){

            public Stroke transform(MyLink s) {
                return edgeStroke;
            }
        };
        this.visuserver.getRenderContext().setEdgeDrawPaintTransformer((Transformer)edgecolor);
        this.visuserver.getRenderContext().setVertexDrawPaintTransformer((Transformer)nodecolor);
        this.visuserver.getRenderContext().setVertexFillPaintTransformer((Transformer)nodecolor);
        this.visuserver.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.visuserver.getRenderContext().setEdgeLabelTransformer((Transformer)new ToStringLabeller());
        this.visuserver.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.frame = new JFrame("Simple Graph View");
        this.frame.setPreferredSize(new Dimension(1600, 1200));
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new FlowLayout());
        this.frame.getContentPane().add((Component)this.visuserver);
        this.ta = new JTextArea("test", 15, 100);
        JScrollPane p = new JScrollPane(this.ta);
        this.frame.getContentPane().add(p);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void transitionFired(String tname, String currentState, IService serv, String log, Exception e) {
        this.ta.append("\n" + log);
        this.ta.revalidate();
        this.visuserver.getModel().getRelaxer().pause();
        for (MyNode node : this.NODES.values()) {
            node.setSelected(false);
        }
        this.NODES.get(currentState).setSelected(true);
        for (MyLink ln : this.LINKS.values()) {
            ln.setSelected(false);
        }
        MyLink selectedln = this.LINKS.get(tname);
        if (selectedln == null) {
            System.err.println("transition " + tname + " not found");
        } else {
            selectedln.setSelected(true);
        }
        this.visuserver.getModel().getRelaxer().resume();
        this.visuserver.repaint();
        this.frame.validate();
    }
}

