/*
 * Decompiled with CFR 0.152.
 */
package costo.kml2java.monitor.gui.multipleframes;

import costo.kml2java.framework.ExecutableComponent;
import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.ServiceEvolutionListener;
import costo.kml2java.monitor.gui.basecomponents.JExecutableServicePanel;
import costo.kml2java.monitor.gui.multipleframes.ServiceInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ComponentFrame
extends JFrame
implements ActionListener,
ServiceEvolutionListener {
    JDesktopPane desktop;
    private ExecutableComponent component;
    private JLabel compstate;

    public ComponentFrame() {
        super("InternalFrameDemo");
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.desktop = new JDesktopPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.add((Component)this.desktop, "Center");
        this.compstate = new JLabel("no component loaded yet");
        this.add((Component)this.compstate, "South");
        this.setJMenuBar(this.createMenuBar());
        this.desktop.setDragMode(1);
    }

    public ComponentFrame(String name) {
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Component");
        menu.setMnemonic(68);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Reset");
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        menuItem.setActionCommand("reset");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Pause ");
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        menuItem.setActionCommand("pause");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Un_Pause ");
        menuItem.setMnemonic(85);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        menuItem.setActionCommand("unpause");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Stop ");
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        menuItem.setActionCommand("stop");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("quit");
        menuItem.setMnemonic(81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        menuItem.setActionCommand("quit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("stop".equals(e.getActionCommand())) {
            this.component.stop();
            return;
        }
        if ("reset".equals(e.getActionCommand())) {
            this.component.reset();
            return;
        }
        if ("pause".equals(e.getActionCommand())) {
            this.component.setPaused(true);
            return;
        }
        if ("unpause".equals(e.getActionCommand())) {
            this.component.setPaused(false);
            return;
        }
        if ("quit".equals(e.getActionCommand())) {
            this.quit();
            return;
        }
    }

    public void createFrame(IProvidedService serv) {
        ServiceInternalFrame frame = new ServiceInternalFrame(new JExecutableServicePanel(serv));
        frame.setVisible(true);
        this.desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    protected void quit() {
        System.exit(0);
    }

    public void assignComponent(ExecutableComponent comp) {
        this.component = comp;
        this.compstate.setText(comp.toString());
        this.setTitle(comp.getName());
        for (IProvidedService serv : this.component.getProvidedServices()) {
            serv.addServiceListener((ServiceEvolutionListener)this);
            this.createFrame(serv);
        }
    }

    public void transitionFired(String tname, String currentState, IService serv, String log, Exception ex) {
        this.compstate.setText(this.component.toString());
        System.out.println(log);
        if (ex != null) {
            System.err.println(String.valueOf(log) + ex.getMessage());
        }
    }
}

