package costo.kml2java.framework;

import costo.kml2java.framework.channels.Channel;
import costo.kml2java.framework.exceptions.ServiceException;

public interface IProvidedService extends IService {

	// @Override
	public abstract Boolean isProvided();

	/**
	 * @param ch
	 *            renamed
	 */
	public abstract void setCallChannel(Channel ch);

	// public abstract IRequiredService getRequiredFromChannelName(String ch);

	/**
	 * @return the alive
	 */
	public abstract boolean isAlive();
	public abstract boolean isReady();
	public abstract boolean isFinished();

	/**
	 * Launch the thread
	 */
	public abstract void start() throws ServiceException;

	public abstract void reset();

	public abstract void init();

	/**
	 * FIXME should call receiveServiceCall with proper parameters
	 */
	public abstract void executeStartingTransaction();

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.ServiceAtExecution#fireCommunicationEvent(java .lang.String, java.lang.String, java.lang.Exception)
	 */
	public abstract void fireServiceEvent(String tname, String log, Exception ex);

	/**
	 * RECEIVE Used when this service is waiting for a message
	 * 
	 * @param channel
	 * @param message
	 * @param paramtypes
	 */
	public abstract Object[] receiveMessage(String channel, String message, Class<?>[] params, IService orig);

	/**
	 * EMIT Used when this service is sending a message
	 * 
	 * @param channel
	 * @param message
	 * @param params
	 */
	public abstract void emitMessage(String channel, String message, Object[] params, IService orig);

	/**
	 * 
	 * CALL Used when this service is calling another one
	 * 
	 * @param channel
	 * @param message
	 * @param params
	 */
	public abstract void callService(String channel, String message, Object[] params, IService orig);

	/**
	 * EMIT_RESULT Used when this service is emitting a service return
	 * 
	 * @param channel
	 * @param message
	 * @param params
	 */
	public abstract void returnService(String channel, String message, Object[] params, IService orig);

	/**
	 * START Used when this service is called actually called in the concrete "executeStartingTransaction"
	 * 
	 * 
	 * 
	 * @param channel
	 * @param message
	 * @param params
	 */

	public abstract Object[] receiveServiceCall(String channel, String message, Class<?>[] paramtypes, IService orig);

	/**
	 * RCV_RESULT used when this service is waiting for a RCV_RESULT of another service
	 * 
	 * @param channel
	 * @param message
	 * @param paramtypes
	 */
	public abstract Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig);

	public abstract void lock(LockCase reason);

	public abstract void unlock();

	public abstract boolean isLockedOn(LockCase reason);

	public abstract boolean isLocked();

	// only for provided
	// this is provided !
	public abstract ExecutableLTS getLTS();

	public abstract void setPaused(boolean paused);

	public abstract void setBlockingCalls(boolean block);

	public abstract void setPauseManager(IPauseManager pm);

	public abstract String printStatus();

}