package costo.kml2java.framework;

import costo.kml2java.framework.channels.Channel;
import costo.kml2java.framework.channels.CommTypes;
import costo.kml2java.framework.channels.IChannel;
import costo.kml2java.framework.channels.PPromotionChannel;
import costo.kml2java.framework.exceptions.KmlCommunicationException;
import costo.kml2java.framework.exceptions.ServiceException;

// TODO: remove REquiredService inheritance
public abstract class PromotedProvidedService extends Service implements IProvidedService {

	private PPromotionChannel promChannel;
	// private Service originalservice;
	private String origCompName;
	private String origServName;

	public String getOrigCompName() {
		return origCompName;
	}

	public void setOrigCompName(String origCompName) {
		this.origCompName = origCompName;
	}

	public String getOrigServName() {
		return origServName;
	}

	public void setOrigServName(String origServName) {
		this.origServName = origServName;
	}

	/**
	 * @return the promChannel
	 */
	public PPromotionChannel getPPromotionChannel() {
		return promChannel;
	}

	/**
	 * @param promChannel
	 *            the promChannel to set
	 */
	public void getPPromotionChannel(PPromotionChannel promChannel) {
		this.promChannel = promChannel;
	}

	@Override
	public void setCallChannel(Channel ch) {
		this.assignChannel(ch);
	}

	public Channel getPeerChannel(Channel ch) {
		if (this.getChannel() == ch)
			return getPPromotionChannel();
		return this.getChannel();
	}

	@Override
	public boolean isAlive() {
		// FIXME should not be called
		return false;
	}

	@Override
	public boolean isReady() {
		// FIXME should not be called
		return false;
	}

	@Override
	public boolean isFinished() {
		// FIXME should not be called
		return false;
	}

	public String printStatus() {
		return "PromotedProvided";
	}

	public void start() throws ServiceException {
		// System.out.println("starting serv "+this.toString());
		if (promChannel == null) {
			// System.out.println("||starting serv "+this.toString()+" get inner context");
			ExecutableComponent subComponent = this.getOwner().getInnerContext().getComponentFromName(this.getOrigCompName());
			// System.out.println("||PP starts serv " + this.getOrigServName()+" comp: "+subComponent.toString());
			IProvidedService executableService = subComponent.callService(this.getOrigServName());
			// System.out.println("||Creates prom channel");
			promChannel = new PPromotionChannel("_" + this.getName(), this, executableService);
			// .getOrigServName()
			executableService.setCallChannel(promChannel);
		}
		System.out.println(promChannel.getLongName() + "-> new channel for service " + this.getLongName());
		try {
			this.getPPromotionChannel().callService("_" + this.getOrigServName(), this.getOrigServName(), null, this);
			// FIXME we change the caller
		} catch (KmlCommunicationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public void reset() {
		// TODO Auto-generated method stub

	}

	@Override
	public void init() {
		// TODO Auto-generated method stub

	}

	@Override
	public void executeStartingTransaction() {
		// FIXME should not be called

	}

	@Override
	public void unlock() {
		// FIXME lock only in the base service
	}

	public void lock(LockCase reason) {
		// FIXME lock only in the base service
	}

	public boolean isLockedOn(LockCase reason) {
		// FIXME lock only in the base service
		return false;
	}

	public boolean isLocked() {
		// FIXME lock only in the base service
		return false;
	}

	/**
	 * @param paused
	 *            the paused to set
	 */
	public void setPaused(boolean paused) {
		// done by the subcomponents themselves
	}

	/**
	 * @param blockingCalls
	 *            the blockingCalls to set
	 */
	public void setBlockingCalls(boolean blockingCalls) {
		// done by the subcomponents themselves
	}

	/**
	 * @see costo.kml2java.framework.RequiredService#callService(java.lang.String, java.lang.String, java.lang.Object[],
	 *      costo.kml2java.framework.IService)
	 */
	@Override
	public void callService(String channel, String message, Object[] params, IService orig) {
		// FIXME : means a call on calrequire, NYI
		throw new RuntimeException("call sub Service" + message + "on promoted provided");
	}

	@Override
	public Object[] receiveServiceCall(String channel, String message, Class<?>[] paramtypes, IService orig) {
		// FIXME : means the base service starts : is there a message name mapping ??
		return getChannel().receiveServiceCall(this.getChannel().getName(), this.getName(), paramtypes, this);
	}

	@Override
	public void returnService(String channel, String message, Object[] params, IService orig) {
		// FIXME : means the base service returns
		getChannel().returnService(this.getChannel().getName(), this.getName(), params, this);
	}

	/**
	 * @see costo.kml2java.framework.RequiredService#ack(costo.kml2java.framework.channels.Channel)
	 */
	@Override
	public void ack(Channel owner, int commtype) {
		// FIXME : means ack a 'service return' or a 'msg send' to the base service
		this.getPPromotionChannel().ack(owner, commtype);
		if (commtype == CommTypes.RCV_RESULT) {
			// usually using locks in Provided services
			this.getChannel().close(this);
		}
	}

	@Override
	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig) {
		// FIXME : means a call on calrequire, NYI
		throw new RuntimeException("no service reception on promoted service");
	}

	@Override
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig) {
		// FIXME reverse ???
		return getChannel().receiveMessage(channel, message, paramtypes, this);
	}

	@Override
	public void emitMessage(String channel, String message, Object[] params, IService orig) {
		// FIXME reverse ???
		getChannel().emitMessage(channel, message, params, this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.IService#stop(java.lang.String) interruption from the owner component
	 */
	@Override
	public void stop() {
		// from owner
		this.getPPromotionChannel().close(this);
	}

	@Override
	public void stop(IChannel source) {
		// FIXME should not come from inside ?
		this.getPeerChannel((Channel) source).close(this);
	}

	public String getStateSpace() {
		return "no state space for promoted";
	}

	/**
	 * @see costo.kml2java.framework.IProvidedService#getLTS()
	 */
	@Override
	public ExecutableLTS getLTS() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setPauseManager(IPauseManager pauseManager) {

	}

}
