package costo.kml2java.framework;

import costo.kml2java.framework.channels.Channel;
import costo.kml2java.framework.channels.IChannel;
import costo.kml2java.framework.channels.RPromotionChannel;
import costo.kml2java.framework.exceptions.KmlCommunicationException;

/**
 * @author GA/PA
 */
public abstract class PromotedRequiredService extends Service implements IRequiredService {

	private RPromotionChannel promChannel;
	// private Service originalservice;
	private String origCompName;
	private String origServName;

	/**
	 * @return the promChannel
	 */
	public Channel getPromChannel() {
		return promChannel;
	}

	/**
	 * @param promChannel
	 *            the promChannel to set
	 */
	public void setPromChannel(Channel promChannel) {
		this.promChannel = (RPromotionChannel) promChannel;
	}

	@Override
	public Channel getChannel() {
		if (this.baseChannel == null) {
			this.assignChannel(this.getOwner().getChannel(this));
			System.out.println(this.baseChannel.getLongName()+"-> new channel for "+this.getName());
		}
		return super.getChannel();
	}

	public Channel getPeerChannel(Channel ch) {
		if (this.getChannel() == ch)
			return getPromChannel();
		return this.getChannel();

	}

	public String getOrigCompName() {
		return origCompName;
	}

	public void setOrigCompName(String origCompName) {
		this.origCompName = origCompName;
	}

	public String getOrigServName() {
		return origServName;
	}

	public void setOrigServName(String origServName) {
		this.origServName = origServName;
	}

	/**
	 * @see costo.kml2java.framework.RequiredService#callService(java.lang.String, java.lang.String, java.lang.Object[],
	 *      costo.kml2java.framework.IService)
	 */
	@Override
	public void callService(String channel, String message, Object[] params, IService orig) {
		try {
			getChannel().callService(channel, message, params, this);
		} catch (KmlCommunicationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * @see costo.kml2java.framework.RequiredService#ack(costo.kml2java.framework.channels.Channel)
	 */
	@Override
	public void ack(Channel owner, int commtype) {
		// FIXME this.promChannel.ack(owner, commtype);
		//from promoted to base only ?
		if (owner == baseChannel) 
		this.promChannel.ack(this, commtype);
		else System.out.println("ack error in service "+ this.getLongName());
		//FIXME should be one sense only
	}

	@Override
	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig) {

		Channel chan = this.getChannel();
		if (chan != null) {
			Object[] res = chan.receiveServiceReturn(channel, message, paramtypes, this);
			// not very efficient but correct
			getOwner().closeChannel(this, chan);
			return res;
		}
		return null;
	}

	@Override
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig) {

		if (channel.equals("__CALLER"))
			return getPromChannel().receiveMessage(channel, message, paramtypes, this);
		return getChannel().receiveMessage(channel, message, paramtypes, this);
	}

	@Override
	public void emitMessage(String channel, String message, Object[] params, IService orig) {

		if (channel.equals("__CALLER")) {
			getPromChannel().emitMessage(channel, message, params, this);
		} else {
			getChannel().emitMessage(channel, message, params, this);
		}

	}

	@Override
	public void stop() {
		// TODO owner component point of view
		// FIXME nothing to do ? or close the outer context ?
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.IService#stop(costo.kml2java.framework.channels.IChannel) related services point of view
	 */
	public void stop(IChannel source) {
		this.getPeerChannel((Channel) source).close(this);
	}

	@Override
	public void setReqChannel(Channel ch) {
		this.setPromChannel(ch);
	}

	public String getStateSpace() {
		return "no state space for required - promoted ";
	}

}