package costo.kml2java.framework;

import costo.kml2java.framework.channels.Channel;
import costo.kml2java.framework.channels.IChannel;
import costo.kml2java.framework.exceptions.KmlCommunicationException;

public abstract class RequiredService extends Service implements IRequiredService {

	/**
	 * Suppose one caller only ?
	 */
	IService caller;

	// /**
	// * @param name
	// * @param owner
	// * no caller at the beginning
	// */
	// public RequiredService(String name, ExecutableComponent owner) {
	// super(name, owner);
	// // TODO Auto-generated constructor stub
	// }

	/**
	 * @return false by default
	 */
	@Override
	public Boolean isRequired() {
		return true;
	}

	/**
	 * @param ch
	 *            renamed
	 */
	@Override
	public void setReqChannel(Channel ch) {
		this.assignChannel(ch);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.ServiceAtExecution#callService(java.lang.String, java.lang.String, java.lang.Object[],
	 * costo.kml2java.framework.ExecutableService) Orig is calling a service through myself, a required service. - get the channel (if none then ask
	 * for a channel from my context (bindings). - send the 'callService' message to that channel
	 */
	@Override
	public void callService(String channel, String message, Object[] params, IService orig) {
		// TODO : add checkPRE/POST
		try {
			// perte de orig : pas de com directe
			this.getChannel().callService(channel, message, params, this);
			caller = orig;
			// caller.lock(LockCase.lockedOnCall);
			// no wait() to the thread but a logical lock
		} catch (KmlCommunicationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// FIXME answer to the sender ? no it's now implicit by the method return
	}

	/**
	 * get the communication channel (assembly or promotion) ask for a channel to the owner if there is no current channel
	 * 
	 * @see costo.kml2java.framework.Service#getChannel()
	 */
	@Override
	public Channel getChannel() {

		if (this.baseChannel == null) {
			this.assignChannel(this.getOwner().getChannel(this));
			//System.out.println(this.baseChannel.getLongName()+"-> new AssChannel for "+this.getName());
		}
		return super.getChannel();
	}

	/**
	 * RECEIVE Used when this service is waiting for a message
	 * 
	 * @param channel
	 * @param message
	 * @param paramtypes
	 */
	@Override
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig) {
		IChannel chan = this.getChannel();
		if (chan != null)
			return chan.receiveMessage(channel, message, paramtypes, this);
		return null;
	}

	/**
	 * EMIT Used when this service is sending a message
	 * 
	 * @param channel
	 * @param message
	 * @param params
	 */
	@Override
	public void emitMessage(String channel, String message, Object[] params, IService orig) {
		Channel chan = this.getChannel();
		if (chan != null) {
			chan.emitMessage(channel, message, params, this);

		} else {
			// FIXME no channel
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.ServiceAtExecution#receiveServiceReturn(java.lang.String, java.lang.String, java.lang.Class<?>[],
	 * costo.kml2java.framework.ExecutableService) close the channel
	 */
	@Override
	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig) {
		Channel chan = this.getChannel();
		if (chan != null) {
			Object[] res = chan.receiveServiceReturn(channel, message, paramtypes, this);
			// not very efficient but correct
			getOwner().closeChannel(this, chan);
			return res;
		}
		return null;
	}

	@Override
	public void fireServiceEvent(String tname, String log, Exception ex) {
		// never called
	}

	/**
	 * service interruption from my owner
	 */
	@Override
	public void stop() {
		if (this.getChannel() != null) {
			getOwner().cutChannel(this, this.getChannel());
		}
	}

	/**
	 * service interruption from my connection
	 */
	@Override
	public void stop(IChannel source) {
		// FIXME raise an exception ? the server is no more available because the channel is closed
		// this.caller.stop("no more channel");
	}
	
	@Override
	public void ack(Channel owner, int commtype) {
		this.caller.ack(owner, commtype);
	}

	/**
	 * @see costo.kml2java.framework.IService#getStateSpace()
	 */
	@Override
	public String getStateSpace() {
		// TODO Auto-generated method stub
		return "";
	}

}
