package costo.kml2java.framework;

import java.util.ArrayList;

import costo.kml2java.framework.channels.Channel;
import costo.kml2java.framework.channels.IChannel;
import costo.kml2java.framework.config.ExecutionParameters;

/**
 * @author andre-p common to all services
 */
public abstract class Service implements IService {

	protected boolean debug = ExecutionParameters.debug;
	//protected boolean debug = false;
	protected String name;
	// protected ExecutableComponent owner;
	protected boolean usingPreconditionsAsGuards = false;
	protected Channel baseChannel;

	protected ArrayList<IServiceEvolutionListener> listeners = new ArrayList<IServiceEvolutionListener>();

	// protected HashMap<String, String> assertionsStatus = new HashMap<String,
	// String>();

	/**
	 * @param name
	 */
	// GENERATED with concrete classes
	// public ServiceAtExecution(String name, ExecutableComponent owner) {
	// super();
	// this.name = name;
	// this.owner = owner;
	// }

	/**
	 * @see costo.kml2java.framework.IService#getName()
	 */
	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getLongName() {
		return this.getOwner().getName()+"::"+this.getName();
	}

	/**
	 * @see costo.kml2java.framework.IService#setName(java.lang.String)
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @see costo.kml2java.framework.IService#assignChannel(costo.kml2java.framework.channels.Channel)
	 */
	@Override
	public void assignChannel(Channel chan) {
		this.baseChannel = chan;
	}

	/**
	 * @see costo.kml2java.framework.IService#getChannel()
	 */
	@Override
	public Channel getChannel() {
		return this.baseChannel;
	}

	/**
	 * @see costo.kml2java.framework.IService#getOwner()
	 */
	@Override
	public abstract ExecutableComponent getOwner();

	protected void assertStatus(String assertion, String status) {
		this.log("assertion " + assertion + " " + status);
	}

	/**
	 * @see costo.kml2java.framework.IService#log(java.lang.String)
	 */
	@Override
	public void log(String s) {
		if (debug) {
			System.out.println(s);
		}
	}

	// status queries

	/**
	 * @see costo.kml2java.framework.IService#isProvided()
	 */
	@Override
	public Boolean isProvided() {
		return false;
	}

	/**
	 * @see costo.kml2java.framework.IService#isRequired()
	 */
	@Override
	public Boolean isRequired() {
		return false;
	}

	/**
	 * @see costo.kml2java.framework.IService#isProtocol()
	 */
	@Override
	public Boolean isProtocol() {
		return false;
	}

	/**
	 * @see costo.kml2java.framework.IService#isIninterruptible()
	 */
	@Override
	public Boolean isIninterruptible() {
		return false;
	}

	/**
	 * @see costo.kml2java.framework.IService#callService(java.lang.String, java.lang.String, java.lang.Object[], costo.kml2java.framework.IService)
	 */
	@Override
	abstract public void callService(String channel, String message, Object[] params, IService orig);

	// only provided abstract public Object[] receiveServiceCall(String channel,
	// String message, Class<?>[] paramtypes, ExecutableService orig);
	// only provided abstract public void returnService(String channel, String
	// message, Object[] params, ExecutableService orig);

	/**
	 * @see costo.kml2java.framework.IService#receiveServiceReturn(java.lang.String, java.lang.String, java.lang.Class,
	 *      costo.kml2java.framework.IService)
	 */
	@Override
	abstract public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig);

	/**
	 * @see costo.kml2java.framework.IService#receiveMessage(java.lang.String, java.lang.String, java.lang.Class, costo.kml2java.framework.IService)
	 */
	@Override
	abstract public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig);

	/**
	 * @see costo.kml2java.framework.IService#emitMessage(java.lang.String, java.lang.String, java.lang.Object[], costo.kml2java.framework.IService)
	 */
	@Override
	abstract public void emitMessage(String channel, String message, Object[] params, IService orig);

	/**
	 * @see costo.kml2java.framework.IService#addServiceListener(costo.kml2java.framework.IServiceEvolutionListener)
	 */
	@Override
	public boolean addServiceListener(IServiceEvolutionListener e) {
		return listeners.add(e);
	}

	@Override
	public void fireServiceEvent(String tname, String log, Exception ex) {
		// FIXME est-ce qu'on met ici la r�ception de com ?
		for (IServiceEvolutionListener l : this.listeners) {
			l.transitionFired(tname, "", this, log, ex);
		}
	}

	@Override
	public void fireServiceError(IChannel chan, String log) {
		for (IServiceEvolutionListener l : this.listeners) {
			l.serviceError(this, chan, log);
		}
	}

	/**
	 * @see costo.kml2java.framework.IService#removeServiceListener(java.lang.Object)
	 */
	@Override
	public boolean removeServiceListener(Object o) {
		return listeners.remove(o);
	}

	/**
	 * @see costo.kml2java.framework.IService#stop()
	 */
	@Override
	abstract public void stop();

	/**
	 * Normal end of communication
	 */
	public void eoc(Channel channel) {
		//FIXME subclass responsability
	}

	/**
	 * @see costo.kml2java.framework.IService#ack(costo.kml2java.framework.channels.Channel)
	 */
	@Override
	public abstract void ack(Channel owner, int commtype);

	/**
	 * @see costo.kml2java.framework.IService#isPreSatisfiedWithTheseParameters(java.lang.Object[])
	 */
	@Override
	public boolean isPreSatisfiedWithTheseParameters(Object[] params) {
		return true;
	}

	/**
	 * @see costo.kml2java.framework.IService#isPreConditionSatisfied()
	 */
	@Override
	public Boolean isPreConditionSatisfied() {
		return this.isObsPreConditionSatisfied() && this.isNonObsPreConditionSatisfied();
	}

	/**
	 * @see costo.kml2java.framework.IService#isObsPreConditionSatisfied()
	 */
	@Override
	public Boolean isObsPreConditionSatisfied() {
		return true;
	}

	/**
	 * @see costo.kml2java.framework.IService#isNonObsPreConditionSatisfied()
	 */
	@Override
	public Boolean isNonObsPreConditionSatisfied() {

		return true;
	}

	/**
	 * @see costo.kml2java.framework.IService#isPostConditionSatisfied()
	 */
	@Override
	public Boolean isPostConditionSatisfied() {
		return this.isObsPostConditionSatisfied() && this.isNonObsPostConditionSatisfied();

	}

	/**
	 * @see costo.kml2java.framework.IService#isObsPostConditionSatisfied()
	 */
	@Override
	public Boolean isObsPostConditionSatisfied() {

		return true;
	}

	/**
	 * @see costo.kml2java.framework.IService#isNonObsPostConditionSatisfied()
	 */
	@Override
	public Boolean isNonObsPostConditionSatisfied() {

		return true;
	}

	/**
	 * @see costo.kml2java.framework.IService#setUsingPreconditionsAsGuards(boolean)
	 */
	@Override
	public void setUsingPreconditionsAsGuards(boolean usingPreconditionsAsGuards) {
		this.usingPreconditionsAsGuards = usingPreconditionsAsGuards;
	}

	/**
	 * @see costo.kml2java.framework.IService#isPostSatisfiedWithTheseParameters(java.lang.Object[])
	 */
	@Override
	public boolean isPostSatisfiedWithTheseParameters(Object[] result) {
		this.setResult((result != null && result.length > 0 ? result[0] : null));
		return isPostConditionSatisfied();
	}

	/**
	 * @see costo.kml2java.framework.IService#setResult(java.lang.Object)
	 */
	@Override
	public void setResult(Object o) {
	}
	
	public void channelCut(Channel channel) {
		//my correspondant is no more available
		fireServiceError(channel, "Please help me "+this.getName()+" !!! Damned, my channel "+channel.getName()+" is closed");
		//System.err.println("Please help me "+this.getName()+" !!!\n ");
		//System.err.println("Damned, my channel "+channel.getName()+" is closed");
	}

}
