package costo.kml2java.framework;

import java.util.HashSet;
import java.util.Set;

public class StepByStepPauseManager implements IPauseManager {

	private boolean pauseMode = false;
	private Set<String> breakpoints = new HashSet<String>();

	@Override
	public boolean shouldPause(IProvidedService prov) {

		return pauseMode || breakpoints.contains(prov.getLTS().getCurrentState());
	}

	/**
	 * @return the pauseMode
	 */
	public boolean isPauseMode() {
		return pauseMode;
	}

	/**
	 * @param pauseMode
	 *            the pauseMode to set
	 */
	public void setPauseMode(boolean pauseMode) {
		this.pauseMode = pauseMode;
	}

	/**
	 * @return the breakpoints
	 */
	public Set<String> getBreakpoints() {
		return breakpoints;
	}

	/**
	 * @param breakpoints
	 *            the breakpoints to set
	 */
	public void setBreakpoints(Set<String> breakpoints) {
		this.breakpoints = breakpoints;
	}

	/**
	 * @param e
	 * @return
	 * @see java.util.Set#add(java.lang.Object)
	 */
	public boolean add(String state) {
		return breakpoints.add(state);
	}

	/**
	 * @param o
	 * @return
	 * @see java.util.Set#remove(java.lang.Object)
	 */
	public boolean remove(String state) {
		return breakpoints.remove(state);
	}

}
