/**
 * 
 */
package costo.kml2java.framework.channels;

import costo.kml2java.framework.config.ExecutionParameters;

/**
 * @author Pascal
 *
 */
public class DefaultChannelListener implements IChannelListener {
	
	private boolean isActive = ExecutionParameters.channelListenerActivation;

	/* (non-Javadoc)
	 * @see costo.kml2java.framework.channels.IChannelListener#channelEvolution(costo.kml2java.framework.channels.IChannel, java.lang.String)
	 */
	@Override
	public void channelEvolution(IChannel source, String message) {
		if (isActive)
		System.out.println(">CHAN[" + source.getName() + "]: " + message);
	}

	/* (non-Javadoc)
	 * @see costo.kml2java.framework.channels.IChannelListener#channelError(costo.kml2java.framework.channels.IChannel, java.lang.String)
	 */
	@Override
	public void channelError(IChannel source, String message) {
		if (isActive)
			System.err.println(">CHAN[" + source.getName() + "]: " + message);
	}

}
