package costo.kml2java.framework.channels;

import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.exceptions.ServiceException;

public class InternalChannel extends Channel {

	public InternalChannel(String name, IService client, IService server) {
		super(name, client, server);
	}

	@Override
	public String toString() {
		String str = super.toString();
		str += "- IntChan \n";
		return str;
	}

	/**
	 * Start the provided service
	 */
	@Override
	public void open() {
		super.open();
		try {
			getProvider().start();
		} catch (ServiceException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public IProvidedService getProvider() {
		return (IProvidedService) server;
	}
	
	public IProvidedService getCaller() {
		return (IProvidedService) client;
	}

}
