package costo.kml2java.framework.channels;

import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.exceptions.KmlCommunicationException;
import costo.kml2java.framework.exceptions.ServiceException;

public class PPromotionChannel extends Channel {

	/**
	 * @param name
	 * @param promoted is the client
	 * @param base is the server
	 */
	public PPromotionChannel(String name, IProvidedService promoted, IProvidedService base) {
		super(name, promoted, base);
	}

	@Override
	public String toString() {
		String str = super.toString();
		str += "- PPromChan \n";
		return str;
	}

	/**
	 * @return the promoted service
	 */
	public IProvidedService getPromotedService() {
		return (IProvidedService) client;
	}

	/**
	 * @return the base service
	 */
	public IProvidedService getBaseService() {
		return (IProvidedService) server;
	}

	/**
	 * @see costo.kml2java.framework.channels.Channel#open()
	 */
	@Override
	public void open() {
		try {
			this.getBaseService().start();
		} catch (ServiceException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/* from outside */
	@Override
	public void callService(String channel, String message, Object[] params, IService client) throws KmlCommunicationException {
		this.open();
	}

	/* from inside */
	@Override
	public Object[] receiveServiceCall(String channel, String message, Class<?>[] paramtypes, IService orig) {
		// FIXME change the orig ? 
		return getPromotedService().receiveServiceCall(channel, message, paramtypes, orig);
	}

	/* from inside */
	@Override
	public void emitMessage(String channel, String message, Object[] params, IService orig) {
		// FIXME change the orig ? 
		this.getPromotedService().emitMessage(channel, message, params, orig);
	}

	/* from inside */
	@Override
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig) {
		// FIXME change the orig ? 
		return this.getPromotedService().receiveMessage(channel, message, paramtypes, orig);
	}

	/* from inside */
	@Override
	public void returnService(String channel, String message, Object[] params, IService orig) {
		this.getPromotedService().returnService(channel, message, params, orig);
	}

	/* from outside */
	@Override
	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig) {
		//should not implement
		return null;
	}

	/* from outside */
	public void ack(Channel owner, int commtype) {
		this.getBaseService().ack(this, commtype);
	}

}
