/**
 * 
 */
package costo.kml2java.framework.channels;

import java.util.HashMap;

import costo.kml2java.framework.ExecutableComponent;
import costo.kml2java.framework.ExecutionContext;
import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IRequiredService;
import costo.kml2java.framework.IService;

/**
 * @author Pascal static execution context definition
 */
public class RPromotionBinding extends ExecutionBinding {

	/**
	 * Service types are redefined : assembly (execution) bindings are ordered req-prov
	 */

	protected HashMap<String, RPromotionChannel> activeBindings = new HashMap<String, RPromotionChannel>();

	/**
	 * @param name
	 * @param owner
	 * @param cclientname
	 * @param cservername
	 *            : a required service name
	 * @param sclientname
	 * @param sservername
	 *            : a provided service name no control
	 */
	public RPromotionBinding(String name, ExecutionContext owner, String cclientname, String cservername, String sclientname, String sservername) {
		super(name, owner, cclientname, cservername, sclientname, sservername);
	}

	@Override
	protected Channel createServicesandChannel(String newChanName, String kindofchannel, ExecutableComponent clientComponent,
			IRequiredService clientService) {

		ExecutableComponent serverComp = owner.getComponentFromName(cservername);
		//FIXME in this case the name should be "SELF" for the composite component
		IRequiredService serv = serverComp.getRequiredService(sservername);

		RPromotionChannel chan = new RPromotionChannel(newChanName, this, clientService, serv);
		serv.setReqChannel(chan);

		// the client will set its channel itself
		return chan;
	}


	
}
