package costo.kml2java.framework.test;

import costo.kml2java.framework.IService;

public class ClassInjectorChannel extends RandomChannel {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8944681914920148783L;
	private Class<?> stubclass;
	private Object stubObject;

	public ClassInjectorChannel(Class<?> stubclass) {

		super();
		this.stubclass = stubclass;
		try {
			this.stubObject = stubclass.newInstance();
		} catch (InstantiationException e) {
			//
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			//
			e.printStackTrace();
		}

	}

	private Object[] invokeMethod(String channel, String message, Class<?>[] paramtypes) {
		Object[] tab = super.receiveMessage(channel, message, paramtypes, null);
		try {
			tab = (Object[]) stubclass.getMethod(message, (Class<?>[]) null).invoke(stubObject, (Object[]) null);
		} catch (Exception e) {
			// TODO: handle exception
		}
		return tab;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.RandomChannel#receiveMessage(java.lang.String, java.lang.Class<?>[])
	 */
	@Override
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig) {
		// if ()
		return invokeMethod(channel, message, paramtypes);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.RandomChannel#receiveServiceCall(java.lang.String , java.lang.Class<?>[])
	 */
	@Override
	public Object[] receiveServiceCall(String channel, String message, Class<?>[] paramtypes, IService orig) {
		//
		return invokeMethod(channel, message, paramtypes);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.RandomChannel#receiveServiceReturn(java.lang .String, java.lang.Class<?>[])
	 */
	@Override
	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig) {
		//
		return invokeMethod(channel, message, paramtypes);
	}

}
