package costo.kml2java.framework.test;

import java.io.Serializable;
import java.util.Random;

/**
 * this class gives utility methods for generating random objects of the standard KmeliaTypes
 * 
 * currently supported types : String Integer Boolean Enum KmlStructs
 * 
 * Integer returned are bounded by maxInt
 * 
 * Strings returned are alphabetical and less than maxStringSize long
 * 
 * 
 */
public class RandomProvider extends AbstractDataProvider implements Serializable, IDataInjector {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4077782726310713455L;

	public RandomProvider() {
		super();
	}

	public RandomProvider(long seed, int maxInt, int maxStringSize) {
		super();
		this.seed = seed;
		this.maxInt = maxInt;
		this.maxStringSize = maxStringSize;
	}

	public RandomProvider(String params) {
		super();
		String[] split = params.split(" ");
		this.setSeed(Integer.parseInt(split[0]));
		this.setMaxInt(Integer.parseInt(split[1]));
		this.setMaxStringSize(Integer.parseInt(split[2]));

	}

	transient Random r = new Random();
	int maxInt = 200;
	int maxStringSize = 5;
	long seed = 0;

	@Override
	public Object giveEnum(Class<?> clazz) {
		int nbenum = clazz.getEnumConstants().length;

		return clazz.getEnumConstants()[r.nextInt(nbenum)];
	}

	@Override
	public Object giveBoolean() {

		return r.nextBoolean();
	}

	@Override
	public Object giveInteger() {

		return r.nextInt(maxInt);
	}

	public Object giveChar() {

		return (char) ('A' + r.nextInt('Z' - 'A' + 1));

	}

	@Override
	public Object giveString() {
		int minsize = maxStringSize / 4 + 1;
		int stringsize = minsize + r.nextInt(maxStringSize - (maxStringSize / 4));
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < stringsize; i++) {
			result.append(giveChar());
		}
		return result.toString();
	}

	/**
	 * @return the maxInt
	 */
	public int getMaxInt() {
		return maxInt;
	}

	/**
	 * @param maxInt
	 *            the maxInt to set
	 */
	public void setMaxInt(int maxInt) {
		this.maxInt = maxInt;
	}

	/**
	 * @return the maxStringSize
	 */
	public int getMaxStringSize() {
		return maxStringSize;
	}

	/**
	 * @param maxStringSize
	 *            the maxStringSize to set
	 */
	public void setMaxStringSize(int maxStringSize) {
		this.maxStringSize = maxStringSize;
	}

	public static void main(String[] args) {
		System.out.println("testing");
		// RandomProvider rp = new RandomProvider();
		// for (int i = 0; i < 100; i++) {
		// // System.out.println(rp.giveRandomString() + " -- " +
		// // rp.giveRandomBoolean() + " -- " + rp.giveRandomInteger());
		// // System.out.println(rp.giveRandomEnum(TestEnum.class));
		// // System.out.println(rp.giveRandomKmlStruct(TestStruct.class));
		// }
	}

	/**
	 * set Seed. If seed parameter =0, generate new random Seed
	 * 
	 * @param seed
	 * @see java.util.Random#setSeed(long)
	 */
	public void setSeed(long seed) {
		if (seed != 0) {
			this.seed = seed;
		} else {
			this.seed = 1 + (long) (Math.random() * 100000);
		}
		r.setSeed(this.seed);
	}

	/**
	 * @return the seed
	 */
	public long getSeed() {
		return seed;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Random# ");
		builder.append(seed);
		builder.append(" ");
		builder.append(maxInt);
		builder.append(" ");
		builder.append(maxStringSize);
		builder.append("\n");
		return builder.toString();
	}

	@Override
	public boolean isExact() {

		return false;
	}

	@Override
	public void reset() {
		this.setSeed(seed);
	}
}
