package costo.kml2java.framework.test;

public abstract class StringBasedProvider extends AbstractDataProvider {

	public StringBasedProvider() {
		super();
	}

	@Override
	public Object giveEnum(Class<?> clazz) {
		Object next = nextString();
		for (Object cst : clazz.getEnumConstants()) {

			if (cst.toString().equals(next))
				return cst;
		}

		return null;
	}

	public abstract String nextString();

	@Override
	public Object giveBoolean() {

		return Boolean.parseBoolean(nextString());
	}

	@Override
	public Object giveInteger() {
		// TODO Auto-generated method stub
		return Integer.parseInt(nextString());
	}

	@Override
	public Object giveString() {

		return nextString();
	}

}