package costo.kml2java.framework;

import java.util.ArrayList;
import java.util.HashMap;

import costo.kml2java.framework.channels.ExecutionBinding;

/**
 * @author Pascal
 * 
 *         static execution context definition suppose one assembly context with components but no subassemblies
 */

public class AssemblyContext extends ExecutionContext {

	private boolean autorunEnabled;

	public AssemblyContext(String name, HashMap<String, ExecutableComponent> instances, HashMap<String, ExecutionBinding> bindings) {
		super(name, instances, bindings);
		// TODO Auto-generated constructor stub
	}

	public AssemblyContext(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	public Integer size() {
		return instances.size();
	}

	public void setServiceListeners(ArrayList<IServiceEvolutionListener> listeners) {
		if (listeners.size() != 0) {
			for (ExecutableComponent comp : instances.values()) {
				for (IServiceEvolutionListener l : listeners) {
					comp.addServiceListener(l);
				}
			}
		}
	}

	public void init() {
		for (ExecutableComponent comp : instances.values()) {
			comp.setAutorunEnabled(autorunEnabled);
			// System.out.println("init comp" + comp.getName() + "started");
			comp.init();
			// System.out.println("init comp" + comp.getName() + "done");
		}
	}

	@Override
	public void start() {
		for (ExecutableComponent comp : instances.values()) {
			comp.start();
		}
	}

	public void stop() {
		for (ExecutableComponent comp : instances.values()) {
			comp.stop();
		}

	}

	public void setAutorunEnabled(boolean autorunEnabled) {
		this.autorunEnabled = autorunEnabled;

	}

	public void setPaused(boolean paused) {
		for (ExecutableComponent comp : instances.values()) {
			comp.setPaused(paused);
		}

	}

	public void reset() {
		for (ExecutableComponent comp : instances.values()) {
			comp.reset();
		}
	}

	// bindings are assembly bindings : false
}
