package costo.kml2java.framework;

import java.util.ArrayList;
import java.util.Random;

public class DefaultServiceExecutionPolicy implements IServiceExecutionPolicy {
	IProvidedService owner;
	ExecutableLTS lts;
	Random r = new Random();

	@Override
	public void nextStep() {
		if (!this.checkBeforeStep())
			return;

		ArrayList<String> possible = lts.getPossibleOutGoingTransitions();

		String selected = selectTransitionFrom(possible);
		if (selected != null) {
			try {
				if (this.beforeExecution(selected)) {
					lts.executeTransition(selected);
				}
				this.afterExecution(selected);
			} catch (Exception e) {
				// FIXME : properly log trace
				// LOG ON transition execution exception
				System.err.println("Exception occured when executing transition " + selected);
				e.printStackTrace();
			}
		}
		this.afterStep();
	}

	/**
	 * @param lts
	 *            the lts to set
	 */
	public void setLts(ExecutableLTS lts) {
		this.lts = lts;
	}

	/**
	 * 
	 * @param possible
	 *            list of executable transitions
	 * @return a randomly chosen transition in this implementation
	 */
	public String selectTransitionFrom(ArrayList<String> possible) {
		if (possible == null || possible.size() == 0)
			return null;
		return possible.get(r.nextInt(possible.size()));

	}

	// / Basic template methods

	/**
	 * 
	 * @return true if nextStep evaluation can be performed (in this implementation: lts !=null)
	 */
	protected boolean checkBeforeStep() {

		return lts != null;
	}

	/**
	 * 
	 * @param selected
	 *            transition name
	 * @return true if execution of selected should be allowed (always true in this implementation)
	 */
	protected boolean beforeExecution(String selected) {
		return true;

	}

	protected void afterExecution(String selected) {

	}

	/**
	 * post step execution treatment
	 */
	protected void afterStep() {

	}

}
