package costo.kml2java.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

import costo.kml2java.framework.channels.AutoRunChannel;
import costo.kml2java.framework.channels.Channel;
import costo.kml2java.framework.channels.InternalChannel;
import costo.kml2java.framework.exceptions.ServiceException;

/**
 * @author Pascal Now the components are simply information container All the processes are in the channel to isolate the middleware part.
 */
public class ExecutableComponent implements Runnable {

	public static enum ComponentState {
		CREATED, CONFIGURED, READY, RUNNING, STOPPED
	}

	private int sleepTime = 500;
	private boolean paused = false;
	private boolean aliveJFK = false;
	/**
	 * instance id = component var id in execution context
	 */
	protected String idJFK;
	protected String name;
	protected String autorun;
	protected ComponentState state = ComponentState.CREATED;

	protected ExecutionContext outerContext;

	protected HashMap<String, IProvidedService> providedservices = new HashMap<String, IProvidedService>();
	protected HashMap<String, IRequiredService> requiredservices = new HashMap<String, IRequiredService>();
	protected Thread componentT;
	protected ArrayList<IServiceEvolutionListener> listeners = new ArrayList<IServiceEvolutionListener>();
	/**
	 * State for composites
	 * 
	 * @see subclass ExecutableComposite
	 */
	protected AssemblyContext innerContext;
	private String configServiceName;
	private Object[] configParameters;
	private boolean autorunEnabled = true;

	// several components fields exist if this is a composite
	// protected CompositeContext promotionContext;

	public ExecutableComponent(String name, ExecutionContext owner, String id) {
		super();
		this.name = name;
		this.outerContext = owner;
		this.idJFK = id;
		aliveJFK = false;
		innerContext = new AssemblyContext(name);
	}

	public ExecutableComponent(String name, ExecutionContext context) {
		this(name, context, "noID");
	}

	public ExecutableComponent() {
		this("anonymous", null, "noID");
	}

	public boolean isApplication() {
		return this.outerContext == null;
	}

	/**
	 * This method must be redefined in the generated subclasses. initialize component state and subcomponents
	 */
	public void initState() {

	}

	public void initSubComponents() {

	}

	/**
	 * This method must be redefined in the generated subclasses. Each service creates its LTS. Creates the objects but do not run the threads.
	 */
	public void createServices() {

	}

	/**
	 * Component initialisation process
	 */
	public void init() {
		initState();// and subcomp
		initSubComponents();
		createServices();
		addListeners();
		applyConfig();

		//System.out.println("end of apply config ");
		if (this.isComposite()) {
			initBindings();
			this.innerContext.setPaused(paused);
			this.innerContext.setAutorunEnabled(this.autorunEnabled);
			//FIXME selective propagation of listeners
			if (listeners.size() != 0) innerContext.setServiceListeners(listeners);
			this.innerContext.init();
		}

		//System.out.println("end of composite config ");
		initServices();
		this.state = ComponentState.READY;
		if (this.isApplication() && this.autorunEnabled) {
			start();
		}
	}

	public void reset() {
		initState();// and subcomp
		// createServices();
		// addListeners();
		applyConfig();

		if (this.isComposite()) {
			// initBindings();
			this.innerContext.setPaused(paused);
			this.innerContext.setAutorunEnabled(this.autorunEnabled);
			this.innerContext.reset();
		}

		// initServices();
		this.state = ComponentState.READY;
		if (this.isApplication() && this.autorunEnabled) {
			start();
		}
	}

	private void addListeners() {
		if (listeners.size() == 0)
			return;
		for (IProvidedService serv : this.providedservices.values()) {
			for (IServiceEvolutionListener l : listeners) {
				serv.addServiceListener(l);
			}
		}
	}

	public void setConfig(String configServiceName, Object... configParameters) {
		this.configServiceName = configServiceName;
		this.configParameters = configParameters;
	}

	protected void applyConfig() {
		if (this.configServiceName == null)
			return;
		IProvidedService configServ = this.getProvidedService(configServiceName);
		configServ.init();
		AutoRunChannel channel = new AutoRunChannel(this.configParameters);
		configServ.assignChannel(channel);
		try {
			configServ.setPaused(false);
			// System.out.println("starting config");
			configServ.start();
			while (!configServ.isFinished()) {
				Thread.yield();
				;
				// wait for the end before the comp
			}
			//System.out.println("end of config "+this.getName()+" service : "+configServ.printStatus());
			// configServ.eoc(channel);
			this.state = ComponentState.CONFIGURED;
		} catch (ServiceException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// } catch (InterruptedException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		//
		// }
	}

	private void configSubComp() {
		// done in the initialisation
	}

	/**
	 * generated
	 */
	protected void initBindings() {

	}

	/**
	 * service initialisation not launched yet - must be called
	 */
	public void initServices() {
		for (IProvidedService serv : providedservices.values()) {
			serv.setPaused(paused);
			if (!serv.isReady()) serv.init();
		}
	}

	/**
	 * do not call before init
	 * 
	 * @param sc
	 */
	/*
	 * @Deprecated public void setServiceSchedulers(Scheduler sc) { for (ExecutableService serv : this.providedservices.values()) {
	 * //serv.setSched(sc.twin()); serv.start(); } }
	 */
	public void stop() {
		aliveJFK = false;
	}

	public void stopSystem() {
		this.stop();
	}

	protected void assertStatus(String assertion, String status) {
		System.out.println("assertion " + assertion + " " + status);
	}

	public boolean isInvariantSatisfied() {
		return isObsInvariantSatisfied() && isNonObsInvariantSatisfied();
	}

	private Boolean isObsInvariantSatisfied() {
		return true;
	}

	private Boolean isNonObsInvariantSatisfied() {
		return true;
	}

	// public synchronized Boolean isAliveJFK() {
	public Boolean isAliveJFK() {
		return aliveJFK;
	}

	public Boolean isComposite() {
		return innerContext.size() > 0;
		// return false if the composite implemented by a subclass;
	}

	/**
	 * @param key
	 * @return
	 * @see java.util.HashMap#get(java.lang.Object)
	 */
	public IProvidedService getProvidedService(String key) {
		return providedservices.get(key);
	};

	/**
	 * @param key
	 * @return
	 * @see java.util.HashMap#get(java.lang.Object)
	 */
	public IRequiredService getRequiredService(String key) {
		return requiredservices.get(key);
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return
	 * @see java.util.HashMap#values()
	 */
	public Collection<IProvidedService> getProvidedServices() {
		return providedservices.values();
	}

	/**
	 * @return
	 * @see java.util.HashMap#values()
	 */
	public Collection<IRequiredService> getRequiredServices() {
		return requiredservices.values();
	};

	public IProvidedService getService(String s) {
		IProvidedService serv = this.getProvidedService(s);

		return serv;
	}

	/**
	 * @param name
	 * @return find the good order : channel - service TODO test if exists or not, reset or not
	 */
	public IProvidedService callService(String name) {
		// FIXME create instance of service if needed
		IProvidedService serv = this.getProvidedService(name);
		if (serv.isAlive()) {// reset or wait ?
			System.err.println(name + "is running");
			// exception to raise
		} else {
			// serv = new ExecutableService(name, this);
			// abstract class !!
			serv.init();
			// the callchannel will be assigned by the binding once the channel is created
		}
		return serv;
	}

	/**
	 * @param service
	 * @return a service asks for a channel the code should vary according to the kind of client service (prov/req) and kind of binding
	 *         (assembly/promotion)
	 */
	public Channel getChannel(IRequiredService clientservice) {
		return outerContext.instantiateLink(this, clientservice);
	}

	public void resolvePromotedServices() {

	}

	/**
	 * @return the context
	 */
	public ExecutionContext getOwner() {
		return outerContext;
	}

	/**
	 * @return the id
	 */
	public String getIdJFK() {
		return idJFK;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setIdJFK(String id) {
		this.idJFK = id;
	}

	public void closeChannel(IService clientservice, Channel chan) {
		//System.out.println(this.getName()+"-> close Channel "+chan.getName()+" for service "+clientservice.getName());

		outerContext.closeChannel(this, clientservice, chan);
	}

	public void cutChannel(IService clientservice, Channel chan) {
		outerContext.cutChannel(this, clientservice, chan);
	}

	/**
	 * do not call this method directly unless setAutorun is false and
	 * 
	 */
	public void start() {
		if (this.state != ComponentState.READY)
			throw new IllegalStateException();
		componentT = new Thread(this);
		this.aliveJFK = true;
		if (isComposite()) {
			this.innerContext.start();
		}
		// LOG OFF System.out.println("starting" + componentT);
		componentT.start();
	}

	@Override
	public void run() {
		this.state = ComponentState.RUNNING;
		if (this.autorun != null && this.getService(autorun) != null) {
			try {
				// while (this.isPaused()) {
				// System.out.println(this.getName() + "isPaused");
				// Thread.yield();
				//
				// }
				// ;
				// System.out.println(this.getName() + "is NOT Paused");
				IProvidedService auto = this.getService(autorun);
				// auto.setPaused(false);
				auto.setCallChannel(new AutoRunChannel(null));
				auto.start();
			} catch (ServiceException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		while (isAliveJFK()) {
			// if (this.isLocked()) {
			// Thread.yield();
			try {
				Thread.sleep(sleepTime);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			// // FIXME what to do ?
			// // this.serverT.wait();
			// } else if (nextStep()) {
			// System.out.println("nextStep " + this.getOwner().getName() + ":" + this.getName());
			// // TODO : properly log trace
			// // may call a blocking communication
			// // FIXME the wait-notify
			// }
			// System.out.println("ALIVE");
		}
		// LOG OFF
		System.out.println("component not running" + componentT);
		for (IProvidedService serv : this.providedservices.values()) {
			serv.stop();
		}
		// should stop upper level first or subcomponents first ?
		// LOG OFF
		System.out.println("services ended from " + componentT);
		this.innerContext.stop();
	}

	public void addServiceListener(IServiceEvolutionListener l) {
		listeners.add(l);
	}

	public Channel getIntChannel(String servname, IProvidedService executableService) {
		IProvidedService serv = this.getProvidedService(servname);
		InternalChannel chan = new InternalChannel("_" + servname, executableService, serv);
		return chan;
	}

	/**
	 * @return the autorunEnabled
	 */
	public boolean isAutorunEnabled() {
		return autorunEnabled;
	}

	/**
	 * @param autorunEnabled
	 *            the autorunEnabled to set if set to false before the component init, then start will have to be called manually on the component
	 *            after init
	 */
	public void setAutorunEnabled(boolean autorunEnabled) {
		this.autorunEnabled = autorunEnabled;
	}

	/**
	 * @return the innerContext
	 */
	public AssemblyContext getInnerContext() {
		return innerContext;
	}

	/**
	 * @return the paused
	 */
	public boolean isPaused() {
		return paused;
	}

	/**
	 * @param paused
	 *            the paused to set
	 */
	public void setPaused(boolean paused) {
		this.paused = paused;

		for (IProvidedService serv : providedservices.values()) {
			serv.setPaused(paused);
		}
		if (this.isComposite()) {
			this.innerContext.setPaused(paused);
		}
	}

	/**
	 * @return the sleepTime
	 */
	public int getSleepTime() {
		return sleepTime;
	}

	/**
	 * @param sleepTime
	 *            the sleepTime to set
	 */
	public void setSleepTime(int sleepTime) {
		this.sleepTime = sleepTime;
	}

}
