package costo.kml2java.framework;

import java.util.ArrayList;
import java.util.HashMap;

import costo.kml2java.framework.channels.ICommunication;

public abstract class ExecutableLTS {
	public void nextStep() {
	}

	protected String currentState;
	protected String initialState;
	protected ArrayList<String> finalStates = new ArrayList<String>();
	protected ArrayList<String> terminalStates = new ArrayList<String>();

	protected HashMap<String, ArrayList<String>> outGoing = new HashMap<String, ArrayList<String>>();
	protected HashMap<String, String> transitionLabels = new HashMap<String, String>();
	protected HashMap<String, ICommunication> transitionCommunications = new HashMap<String, ICommunication>();

	public boolean finalStateReached() {
		return (currentState != null && finalStates.contains(currentState));
	}

	public boolean terminalStateReached() {
		return (currentState != null && terminalStates.contains(currentState));
	}

	public ArrayList<String> getPossibleOutGoingTransitions() {

		ArrayList<String> result = new ArrayList<String>();
		if (outGoing.get(currentState) != null) {
			for (String trans : outGoing.get(currentState)) {
				if (isGuardSatisfied(trans)) {
					result.add(trans);
				}
			}
		}

		return result;
	}

	public Boolean isGuardSatisfied(String transition) {
		return true;
	}

	public ICommunication getMessageForTransition(String trans) {
		return this.transitionCommunications.get(trans);
	}

	@SuppressWarnings("unused")
	private String getSource(String trans) {

		return trans.substring(0, trans.indexOf("_"));
	}

	private String getTarget(String trans) {
		return trans.split("___")[1];
	}

	public final void executeTransition(String transition) throws Exception {
		Exception ex = null;
		try {
			applyTransition(transition);
		} catch (Exception e) {
			ex = e;
		}
		// FIXME : new types of transition
		// int targetpos = transition.lastIndexOf("_");
		this.getService().fireServiceEvent(transition, this.transitionLabels.get(transition), ex);
		// FIXME : revoir l'activation des coms avec Channel : existe d�j� dans la gencode service
		// currentState = transition.substring(targetpos + 1);
		// int indexpos = currentState.indexOf("___");
		// if (indexpos != -1) {
		// currentState = transition.substring(0, indexpos);
		// }
		currentState = getTarget(transition);
		if (finalStateReached()) {
			this.getService().fireServiceEvent("", "final state reached", ex);
		}
		if (terminalStateReached()) {
			this.getService().fireServiceEvent("", "terminal state reached", ex);
		}
		// if (ex != null)
		// throw (ex);
		// ex.printStackTrace();
	}

	/**
	 * to be subclassed
	 * 
	 * @param transition
	 */
	protected void applyTransition(String transition) {
		//

	}

	public abstract IProvidedService getService();

	public static ArrayList<String> createArrayListFrom(String... args) {
		ArrayList<String> list = new ArrayList<String>();
		for (String t : args) {
			list.add(t);
		}
		return list;
	}

	public void init() {
		this.currentState = this.initialState;
	}

	/**
	 * Instantiate the service thread here
	 */
	public void start() {
		this.getService().executeStartingTransaction();

	}

	public void reset() {
		this.currentState = this.initialState;
	}

	public String getCurrentState() {
		//
		return currentState;
	}

	/**
	 * @return the initialState
	 */
	public String getInitialState() {
		return initialState;
	}

	/**
	 * @return the outGoing
	 */
	public HashMap<String, ArrayList<String>> getOutGoing() {
		return outGoing;
	}

	/**
	 * @return the transitionLabels
	 */
	public HashMap<String, String> getTransitionLabels() {
		return transitionLabels;
	}
}
