package costo.kml2java.framework;

import costo.kml2java.framework.channels.Channel;
import costo.kml2java.framework.channels.IChannel;
import costo.kml2java.framework.exceptions.ChannelException;

public interface IService {

	/**
	 * @return the name
	 */
	public abstract String getName();

	/**
	 * @param name
	 *            the name to set
	 */
	public abstract void setName(String name);

	/**
	 * @param chan
	 *            TODO on going work
	 */
	// public abstract void setPromChannel(Channel chan);

	/**
	 * @param chan
	 *            the channel to set
	 */
	public abstract void assignChannel(Channel chan);

	public abstract Channel getChannel();

	/**
	 * @return the name
	 */
	public abstract ExecutableComponent getOwner();

	public abstract void log(String s);

	/**
	 * @return false by default
	 */
	public abstract Boolean isProvided();

	/**
	 * @return false by default
	 */
	public abstract Boolean isRequired();

	/**
	 * @return false by default
	 */
	public abstract Boolean isProtocol();

	/**
	 * @return false by default
	 */
	public abstract Boolean isIninterruptible();

	/**
	 * @param channel
	 * @param message
	 * @param params
	 * @param orig
	 *            Orig is calling a service through myself, a service at execution. - get the channel (if none then ask for a channel from my context
	 *            (bindings). - send the 'callService' message to that channel
	 */
	abstract public void callService(String channel, String message, Object[] params, IService orig);

	abstract public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig);

	abstract public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig);

	abstract public void emitMessage(String channel, String message, Object[] params, IService orig);

	public abstract void setResult(Object o);

	// /**
	// * @param chan
	// * @param message
	// * @param params
	// * @param orig
	// * @throws ChannelException
	// * @throws ServiceException
	// * see whether the parameters are useful or not
	// */
	// abstract public void ackMessageSend(Channel chan, String message, Object[] params, IService orig) throws ChannelException, ServiceException;
	//
	// /**
	// * @param channel
	// * @param message
	// * @param params
	// * @param orig
	// * @throws ChannelException
	// * @throws KmlCommunicationException
	// * @throws ServiceException
	// * only for required services ? but see further for internal or promotion calls
	// */
	// abstract public void ackServiceCall(Channel chan) throws ChannelException, KmlCommunicationException, ServiceException;

	/**
	 * @param owner
	 * @param commtype
	 *            a blocking communication is acknowledged
	 */
	public abstract void ack(Channel owner, int commtype);

	abstract public void fireServiceEvent(String tname, String log, Exception ex) throws ChannelException;

	/**
	 * @param e
	 * @return
	 * @see java.util.ArrayList#add(java.lang.Object)
	 */
	public abstract boolean addServiceListener(IServiceEvolutionListener e);

	/**
	 * @param o
	 * @return
	 * @see java.util.ArrayList#remove(java.lang.Object)
	 */
	public abstract boolean removeServiceListener(Object o);

	/**
	 * service interruption my owner stops me
	 */
	public abstract void stop();

	/**
	 * @param source
	 *            the channels channel is (will be) closed
	 */
	public abstract  void stop(IChannel source);

	/**
	 * Normal end of communication
	 */
	public abstract void eoc(Channel channel);

	/**
	 * @param params
	 * @return Assertions management
	 */
	public abstract boolean isPreSatisfiedWithTheseParameters(Object[] params);

	public abstract Boolean isPreConditionSatisfied();

	public abstract Boolean isObsPreConditionSatisfied();

	public abstract Boolean isNonObsPreConditionSatisfied();

	public abstract Boolean isPostConditionSatisfied();

	public abstract Boolean isObsPostConditionSatisfied();

	public abstract Boolean isNonObsPostConditionSatisfied();

	/**
	 * @param usingPreconditionsAsGuards
	 *            the usingPreconditionsAsGuards to set
	 */
	public abstract void setUsingPreconditionsAsGuards(boolean usingPreconditionsAsGuards);

	public abstract boolean isPostSatisfiedWithTheseParameters(Object[] result);

	public abstract String getStateSpace();

	/**
	 * @param channel
	 * The channel was cut by the other connected service
	 */
	public abstract void channelCut(Channel channel);

	String getLongName();

	void fireServiceError(IChannel chan, String log);


}