
/**
 * 
 */
package costo.kml2java.framework.channels;

import java.util.HashMap;

import costo.kml2java.framework.ExecutableComponent;
import costo.kml2java.framework.ExecutionContext;
import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IRequiredService;
import costo.kml2java.framework.IService;

/**
 * @author Pascal static execution context definition
 */
public class AssemblyBinding extends ExecutionBinding {

	/**
	 * Service types are redefined : assembly (execution) bindings are ordered req-prov
	 */

	protected HashMap<String, AssemblyChannel> activeBindings = new HashMap<String, AssemblyChannel>();

	/**
	 * @param name
	 * @param owner
	 * @param cclientname
	 * @param cservername
	 *            : a required service name
	 * @param sclientname
	 * @param sservername
	 *            : a provided service name no control
	 */
	public AssemblyBinding(String name, ExecutionContext owner, String cclientname, String cservername, String sclientname, String sservername) {
		super(name, owner, cclientname, cservername, sclientname, sservername);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see costo.kml2java.framework.ExecutionBinding#createChannel(java.lang.String) there should be a channel factory
	 */
//	@Override
//	@Deprecated
//	public Channel createServicesandChannel(String chanName, String kindofchannel) {
//		ExecutableComponent clientc = owner.getComponentFromName(cclientname);
//		IRequiredService req = clientc.getRequiredService(sclientname);
//		ExecutableComponent serverc = owner.getComponentFromName(cservername);
//		IProvidedService prov = serverc.getProvidedService(sservername);
//		AssemblyChannel chan = new AssemblyChannel(chanName, this, req, prov);
//		prov.setCallChannel(chan);
//		req.setReqChannel(chan);
//		return chan;
//	}

	@Override
	protected Channel createServicesandChannel(String newChanName, String kindofchannel, ExecutableComponent clientComponent,
			IRequiredService clientService) {

		ExecutableComponent serverComp = owner.getComponentFromName(cservername);

		IProvidedService serv = serverComp.callService(sservername);

		AssemblyChannel chan = new AssemblyChannel(newChanName, this, clientService, serv);
		serv.setCallChannel(chan);

		// the client will set its channel itself
		return chan;
	}

}
